/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorRef;
import akka.actor.package$;
import akka.persistence.JournalProtocol;
import akka.persistence.JournalProtocol$ReplayMessages$;
import akka.persistence.JournalProtocol$ReplayMessagesSuccess$;
import akka.persistence.Persistence;
import akka.persistence.Persistence$;
import akka.persistence.Persistent;
import akka.persistence.PersistentRepr;
import akka.persistence.Recover;
import akka.persistence.Recovery;
import akka.persistence.Recovery$;
import akka.persistence.SelectedSnapshot;
import akka.persistence.SnapshotMetadata;
import akka.persistence.SnapshotOffer;
import akka.persistence.SnapshotProtocol;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.util.control.NonFatal$;

public abstract class Recovery$class {
    public static void runReceive(Recovery $this, PartialFunction receive2, Persistent msg) {
        receive2.applyOrElse((Object)msg, (Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Recovery $outer;

            public final void apply(Object message) {
                this.$outer.unhandled(message);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static Recovery.State recoveryStarted(Recovery $this, long replayMax) {
        return new Recovery.State($this, replayMax){
            private final /* synthetic */ Recovery $outer;
            private final long replayMax$1;

            public void process(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Recovery.State.class.process(this, receive2, message);
            }

            public void processPersistent(PartialFunction<Object, BoxedUnit> receive2, Persistent persistent) {
                Recovery.State.class.processPersistent(this, receive2, persistent);
            }

            public void recordFailure(Throwable cause) {
                Recovery.State.class.recordFailure(this, cause);
            }

            public String toString() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"recovery started (replayMax = [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.replayMax$1)}));
            }

            public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Object object = message;
                if (object instanceof Recover) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (object instanceof SnapshotProtocol.LoadSnapshotResult) {
                    SnapshotProtocol.LoadSnapshotResult loadSnapshotResult = (SnapshotProtocol.LoadSnapshotResult)object;
                    Option<SelectedSnapshot> sso = loadSnapshotResult.snapshot();
                    long toSnr = loadSnapshotResult.toSequenceNr();
                    sso.foreach((Function1)new Serializable(this, receive2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ Recovery$.anon.5 $outer;
                        private final PartialFunction receive$1;

                        public final void apply(SelectedSnapshot x0$1) {
                            SelectedSnapshot selectedSnapshot = x0$1;
                            if (selectedSnapshot != null) {
                                SnapshotMetadata metadata = selectedSnapshot.metadata();
                                Object snapshot = selectedSnapshot.snapshot();
                                this.$outer.akka$persistence$Recovery$$anon$$$outer().updateLastSequenceNr(metadata.sequenceNr());
                                this.$outer.process((PartialFunction<Object, BoxedUnit>)this.receive$1, new SnapshotOffer(metadata, snapshot));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError((Object)selectedSnapshot);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.receive$1 = receive$1;
                        }
                    });
                    this.$outer._currentState_$eq(this.$outer.replayStarted(true));
                    package$.MODULE$.actorRef2Scala(this.$outer.journal()).$bang((Object)new JournalProtocol.ReplayMessages(this.$outer.lastSequenceNr() + 1L, toSnr, this.replayMax$1, this.$outer.persistenceId(), this.$outer.self(), JournalProtocol$ReplayMessages$.MODULE$.apply$default$6()), this.$outer.self());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.receiverStash().stash();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public /* synthetic */ Recovery akka$persistence$Recovery$$anon$$$outer() {
                return this.$outer;
            }

            public /* synthetic */ Recovery akka$persistence$Recovery$State$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.replayMax$1 = replayMax$1;
                Recovery.State.class.$init$(this);
            }
        };
    }

    public static Recovery.State replayStarted(Recovery $this, boolean await) {
        return new Recovery.State($this, await){
            private final /* synthetic */ Recovery $outer;
            private final boolean await$1;

            public void process(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                Recovery.State.class.process(this, receive2, message);
            }

            public void processPersistent(PartialFunction<Object, BoxedUnit> receive2, Persistent persistent) {
                Recovery.State.class.processPersistent(this, receive2, persistent);
            }

            public void recordFailure(Throwable cause) {
                Recovery.State.class.recordFailure(this, cause);
            }

            public String toString() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replay started (await = [", "])"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.await$1)}));
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object message) {
                BoxedUnit boxedUnit;
                Object object = message;
                if (object instanceof Recover) {
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    return;
                }
                if (object instanceof JournalProtocol.ReplayedMessage) {
                    JournalProtocol.ReplayedMessage replayedMessage = (JournalProtocol.ReplayedMessage)object;
                    PersistentRepr p = replayedMessage.persistent();
                    try {
                        this.processPersistent(receive2, (Persistent)((Object)p));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable t = (Throwable)option.get();
                        this.$outer._currentState_$eq(this.$outer.replayFailed());
                        this.recordFailure(t);
                        BoxedUnit boxedUnit7 = BoxedUnit.UNIT;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    BoxedUnit boxedUnit2;
                    JournalProtocol$ReplayMessagesSuccess$ journalProtocol$ReplayMessagesSuccess$ = JournalProtocol$ReplayMessagesSuccess$.MODULE$;
                    Object object2 = object;
                    if (!(journalProtocol$ReplayMessagesSuccess$ != null ? !journalProtocol$ReplayMessagesSuccess$.equals(object2) : object2 != null)) {
                        this.$outer.onReplaySuccess(receive2, this.await$1);
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        return;
                    }
                    if (object instanceof JournalProtocol.ReplayMessagesFailure) {
                        JournalProtocol.ReplayMessagesFailure replayMessagesFailure = (JournalProtocol.ReplayMessagesFailure)object;
                        Throwable cause = replayMessagesFailure.cause();
                        this.$outer.onReplayFailure(receive2, this.await$1, cause);
                        BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                        return;
                    }
                    if (this.await$1) {
                        this.$outer.receiverStash().stash();
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.process(receive2, object);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit6 = boxedUnit2;
                    return;
                }
                BoxedUnit boxedUnit8 = boxedUnit;
            }

            public /* synthetic */ Recovery akka$persistence$Recovery$State$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.await$1 = await$1;
                Recovery.State.class.$init$(this);
            }
        };
    }

    public static String processorId(Recovery $this) {
        return $this.extension().persistenceId($this.self());
    }

    public static void withCurrentPersistent(Recovery $this, Persistent persistent, Function1 body) {
        try {
            $this.akka$persistence$Recovery$$_currentPersistent_$eq(persistent);
            $this.updateLastSequenceNr(persistent);
            body.apply((Object)persistent);
            return;
        }
        finally {
            $this.akka$persistence$Recovery$$_currentPersistent_$eq(null);
        }
    }

    public static void updateLastSequenceNr(Recovery $this, Persistent persistent) {
        if (persistent.sequenceNr() > $this.akka$persistence$Recovery$$_lastSequenceNr()) {
            $this.akka$persistence$Recovery$$_lastSequenceNr_$eq(persistent.sequenceNr());
        }
    }

    public static void updateLastSequenceNr(Recovery $this, long value) {
        $this.akka$persistence$Recovery$$_lastSequenceNr_$eq(value);
    }

    public static Option currentPersistentMessage(Recovery $this) {
        return Option$.MODULE$.apply((Object)$this.akka$persistence$Recovery$$_currentPersistent());
    }

    public static Persistent getCurrentPersistentMessage(Recovery $this) {
        return (Persistent)$this.currentPersistentMessage().getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
    }

    public static long lastSequenceNr(Recovery $this) {
        return $this.akka$persistence$Recovery$$_lastSequenceNr();
    }

    public static long snapshotSequenceNr(Recovery $this) {
        return $this.lastSequenceNr();
    }

    public static ActorRef journal(Recovery $this) {
        return $this.extension().journalFor($this.persistenceId());
    }

    public static void aroundReceive(Recovery $this, PartialFunction receive2, Object message) {
        $this._currentState().aroundReceive((PartialFunction<Object, BoxedUnit>)receive2, message);
    }

    public static void $init$(Recovery $this) {
        $this.akka$persistence$Recovery$_setter_$recoveryPending_$eq(new Recovery$.anon.4($this));
        $this.akka$persistence$Recovery$_setter_$replayFailed_$eq(new Recovery$.anon.2($this));
        $this.akka$persistence$Recovery$_setter_$prepareRestart_$eq(new Recovery$.anon.3($this));
        $this.akka$persistence$Recovery$$_lastSequenceNr_$eq(0L);
        $this._currentState_$eq($this.recoveryPending());
        $this.akka$persistence$Recovery$_setter_$extension_$eq((Persistence)Persistence$.MODULE$.apply($this.context().system()));
        $this.akka$persistence$Recovery$_setter_$receiverStash_$eq($this.createStash($this.context(), $this.self()));
    }
}

