/*
 * Decompiled with CFR 0.152.
 */
package play.sbt;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.security.SecureRandom;
import play.sbt.PlayImport$PlayKeys$;
import sbt.AList$;
import sbt.ConfigKey$;
import sbt.Def$;
import sbt.FeedbackProvidedException;
import sbt.IO$;
import sbt.Init;
import sbt.Keys$;
import sbt.Logger;
import sbt.MessageOnlyException;
import sbt.Task;
import sbt.package$;
import sbt.std.FullInstance$;
import sbt.std.TaskStreams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple4;
import scala.collection.GenSeq;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class ApplicationSecretGenerator$ {
    public static final ApplicationSecretGenerator$ MODULE$;
    private final Regex ApplicationSecret;

    static {
        new ApplicationSecretGenerator$();
    }

    public String generateSecret() {
        SecureRandom random = new SecureRandom();
        return ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 64).map((Function1)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final SecureRandom random$1;

            public final char apply(int x$1) {
                return (char)(this.random$1.nextInt(75) + 48);
            }
            {
                this.random$1 = random$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString().replaceAll("\\\\+", "/");
    }

    public Init.Initialize<Task<String>> generateSecretTask() {
        return (Init.Initialize)FullInstance$.MODULE$.map((Object)Keys$.MODULE$.streams(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final String apply(TaskStreams<Init.ScopedKey<?>> $q1) {
                void var2_2;
                String secret = ApplicationSecretGenerator$.MODULE$.generateSecret();
                $q1.log().info((Function0)new Serializable(this, secret){
                    public static final long serialVersionUID = 0L;
                    private final String secret$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Generated new secret: ").append((Object)this.secret$1).toString();
                    }
                    {
                        this.secret$1 = secret$1;
                    }
                });
                return var2_2;
            }
        });
    }

    private Regex ApplicationSecret() {
        return this.ApplicationSecret;
    }

    public Init.Initialize<Task<File>> updateSecretTask() {
        return (Init.Initialize)FullInstance$.MODULE$.app((Object)new Tuple4((Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.resourceDirectory().in(ConfigKey$.MODULE$.configurationToKey(package$.MODULE$.Compile()))), (Object)Keys$.MODULE$.streams(), (Object)Def$.MODULE$.toITask((Init.Initialize)Keys$.MODULE$.baseDirectory()), PlayImport$PlayKeys$.MODULE$.generateSecret()), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final File apply(Tuple4<File, TaskStreams<Init.ScopedKey<?>>, File, String> $p1) {
                Option option;
                block8: {
                    File file;
                    Logger log2;
                    String secret;
                    block7: {
                        File file2;
                        block6: {
                            String string;
                            file2 = (File)$p1._1();
                            TaskStreams taskStreams = (TaskStreams)$p1._2();
                            File file3 = (File)$p1._3();
                            secret = string = (String)$p1._4();
                            File baseDir = file3;
                            log2 = taskStreams.log();
                            option = Option$.MODULE$.apply((Object)System.getProperty("config.file"));
                            if (!(option instanceof Some)) break block6;
                            Some some = (Some)option;
                            String applicationConf = (String)some.x();
                            file = new File(baseDir, applicationConf);
                            break block7;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                        file = package$.MODULE$.richFile(file2).$div("application.conf");
                    }
                    File appConfFile = file;
                    if (appConfFile.exists()) {
                        List list;
                        log2.info((Function0)new Serializable(this, appConfFile){
                            public static final long serialVersionUID = 0L;
                            private final File appConfFile$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Updating application secret in ").append((Object)this.appConfFile$1.getCanonicalPath()).toString();
                            }
                            {
                                this.appConfFile$1 = appConfFile$1;
                            }
                        });
                        List lines = IO$.MODULE$.readLines(appConfFile, IO$.MODULE$.readLines$default$2());
                        Config config = ConfigFactory.parseString((String)lines.mkString("\n"));
                        if (config.hasPath("play.crypto.secret")) {
                            log2.info((Function0)new Serializable(this, config){
                                public static final long serialVersionUID = 0L;
                                private final Config config$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Replacing old application secret: ").append((Object)this.config$1.getString("play.crypto.secret")).toString();
                                }
                                {
                                    this.config$1 = config$1;
                                }
                            });
                            list = ApplicationSecretGenerator$.MODULE$.getUpdatedSecretLines(secret, (List<String>)lines, config);
                        } else {
                            String secretConfig;
                            log2.warn((Function0)new Serializable(this, appConfFile){
                                public static final long serialVersionUID = 0L;
                                private final File appConfFile$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Did not find application secret in ").append((Object)this.appConfFile$1.getCanonicalPath()).toString();
                                }
                                {
                                    this.appConfFile$1 = appConfFile$1;
                                }
                            });
                            log2.warn((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Adding application secret to start of file";
                                }
                            });
                            String string = secretConfig = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"play.crypto.secret=\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{secret}));
                            list = lines.$colon$colon((Object)string);
                        }
                        List newLines = list;
                        IO$.MODULE$.writeLines(appConfFile, newLines, IO$.MODULE$.writeLines$default$3(), IO$.MODULE$.writeLines$default$4());
                        return appConfFile;
                    }
                    log2.error((Function0)new Serializable(this, appConfFile){
                        public static final long serialVersionUID = 0L;
                        private final File appConfFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Could not find configuration file at ").append((Object)this.appConfFile$1.getCanonicalPath()).toString();
                        }
                        {
                            this.appConfFile$1 = appConfFile$1;
                        }
                    });
                    throw new FeedbackProvidedException(this){};
                }
                throw new MatchError((Object)option);
            }
        }, AList$.MODULE$.tuple4());
    }

    public List<String> getUpdatedSecretLines(String newSecret, List<String> lines, Config config) {
        ConfigValue applicationSecretValue;
        ConfigOrigin applicationSecretOrigin;
        ConfigValue secretConfigValue = config.getValue("play.crypto.secret");
        ConfigOrigin secretConfigOrigin = secretConfigValue.origin();
        if (secretConfigOrigin.lineNumber() == -1) {
            throw new MessageOnlyException("Could not change play.crypto.secret");
        }
        int lineNumber = secretConfigOrigin.lineNumber() - 1;
        List newLines = (List)lines.updated(lineNumber, (Object)((String)lines.apply(lineNumber)).replace((String)secretConfigValue.unwrapped(), newSecret), List$.MODULE$.canBuildFrom());
        return config.hasPath("application.secret") ? ((applicationSecretOrigin = (applicationSecretValue = config.getValue("application.secret")).origin()).lineNumber() == -1 ? newLines : (List)newLines.patch(applicationSecretOrigin.lineNumber() - 1, (GenSeq)Nil$.MODULE$, 1, List$.MODULE$.canBuildFrom())) : newLines;
    }

    private ApplicationSecretGenerator$() {
        MODULE$ = this;
        this.ApplicationSecret = new StringOps(Predef$.MODULE$.augmentString("\\s*(?:(?:application\\.secret)|(?:play\\.crypto\\.secret))\\s*[=:].*")).r();
    }
}

