/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJobManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class JavaScriptJobManagerImpl
implements JavaScriptJobManager {
    private static final String LINE_SEPARARATOR = System.getProperty("line.separator");
    private final transient WeakReference<WebWindow> window_;
    private transient PriorityQueue<JavaScriptJob> scheduledJobsQ_ = new PriorityQueue();
    private transient ArrayList<Integer> cancelledJobs_ = new ArrayList();
    private transient JavaScriptJob currentlyRunningJob_ = null;
    private static final AtomicInteger NEXT_JOB_ID_ = new AtomicInteger(1);
    private static final Log LOG = LogFactory.getLog(JavaScriptJobManagerImpl.class);

    JavaScriptJobManagerImpl(WebWindow window) {
        this.window_ = new WeakReference<WebWindow>(window);
    }

    @Override
    public synchronized int getJobCount() {
        return this.scheduledJobsQ_.size() + (this.currentlyRunningJob_ != null ? 1 : 0);
    }

    @Override
    public synchronized int getJobCount(JavaScriptJobManager.JavaScriptJobFilter filter) {
        if (filter == null) {
            return this.scheduledJobsQ_.size() + (this.currentlyRunningJob_ != null ? 1 : 0);
        }
        int count = 0;
        if (this.currentlyRunningJob_ != null && filter.passes(this.currentlyRunningJob_)) {
            ++count;
        }
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            if (!filter.passes(job)) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addJob(JavaScriptJob job, Page page) {
        WebWindow w = this.getWindow();
        if (w == null) {
            return 0;
        }
        if (w.getEnclosedPage() != page) {
            return 0;
        }
        int id = NEXT_JOB_ID_.getAndIncrement();
        job.setId(id);
        JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
        synchronized (javaScriptJobManagerImpl) {
            this.scheduledJobsQ_.add(job);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"job added to queue");
                LOG.debug((Object)("    window is: " + w));
                LOG.debug((Object)("    added job: " + job.toString()));
                LOG.debug((Object)"after adding job to the queue, the queue is: ");
                this.printQueue();
            }
            this.notify();
        }
        return id;
    }

    @Override
    public synchronized void removeJob(int id) {
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            int jobId = job.getId();
            if (jobId != id) continue;
            this.scheduledJobsQ_.remove(job);
            break;
        }
        this.cancelledJobs_.add(id);
        this.notify();
    }

    @Override
    public synchronized void stopJob(int id) {
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            int jobId = job.getId();
            if (jobId != id) continue;
            this.scheduledJobsQ_.remove(job);
            break;
        }
        this.cancelledJobs_.add(id);
        this.notify();
    }

    @Override
    public synchronized void removeAllJobs() {
        if (this.currentlyRunningJob_ != null) {
            this.cancelledJobs_.add(this.currentlyRunningJob_.getId());
        }
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            this.cancelledJobs_.add(job.getId());
        }
        this.scheduledJobsQ_.clear();
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForJobs(long timeoutMillis) {
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Waiting for all jobs to finish (will wait max " + timeoutMillis + " millis)."));
        }
        if (timeoutMillis > 0L) {
            long now = System.currentTimeMillis();
            long end = now + timeoutMillis;
            JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
            synchronized (javaScriptJobManagerImpl) {
                while (this.getJobCount() > 0 && now < end) {
                    try {
                        this.wait(end - now);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"InterruptedException while in waitForJobs", (Throwable)e);
                    }
                    now = System.currentTimeMillis();
                }
            }
        }
        int jobs = this.getJobCount();
        if (debug) {
            LOG.debug((Object)("Finished waiting for all jobs to finish (final job count is " + jobs + ")."));
        }
        return jobs;
    }

    @Override
    public int waitForJobsStartingBefore(long delayMillis) {
        return this.waitForJobsStartingBefore(delayMillis, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitForJobsStartingBefore(long delayMillis, JavaScriptJobManager.JavaScriptJobFilter filter) {
        boolean debug = LOG.isDebugEnabled();
        long latestExecutionTime = System.currentTimeMillis() + delayMillis;
        if (debug) {
            LOG.debug((Object)("Waiting for all jobs that have execution time before " + delayMillis + " (" + latestExecutionTime + ") to finish"));
        }
        long interval = Math.max(40L, delayMillis);
        JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
        synchronized (javaScriptJobManagerImpl) {
            JavaScriptJob earliestJob = this.getEarliestJob(filter);
            boolean pending = earliestJob != null && earliestJob.getTargetExecutionTime() < latestExecutionTime;
            boolean bl = pending = pending || this.currentlyRunningJob_ != null && (filter == null || filter.passes(this.currentlyRunningJob_)) && this.currentlyRunningJob_.getTargetExecutionTime() < latestExecutionTime;
            while (pending) {
                try {
                    this.wait(interval);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"InterruptedException while in waitForJobsStartingBefore", (Throwable)e);
                }
                earliestJob = this.getEarliestJob(filter);
                pending = earliestJob != null && earliestJob.getTargetExecutionTime() < latestExecutionTime;
                pending = pending || this.currentlyRunningJob_ != null && (filter == null || filter.passes(this.currentlyRunningJob_)) && this.currentlyRunningJob_.getTargetExecutionTime() < latestExecutionTime;
            }
        }
        int jobs = this.getJobCount(filter);
        if (debug) {
            LOG.debug((Object)("Finished waiting for all jobs that have target execution time earlier than " + latestExecutionTime + ", final job count is " + jobs));
        }
        return jobs;
    }

    @Override
    public synchronized void shutdown() {
        this.scheduledJobsQ_.clear();
        this.notify();
    }

    private WebWindow getWindow() {
        return (WebWindow)this.window_.get();
    }

    private void printQueue() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"------ printing JavaScript job queue -----");
            LOG.debug((Object)("  number of jobs on the queue: " + this.scheduledJobsQ_.size()));
            int count = 1;
            for (JavaScriptJob job : this.scheduledJobsQ_) {
                LOG.debug((Object)("  " + count + ")  Job target execution time: " + job.getTargetExecutionTime()));
                LOG.debug((Object)("      job to string: " + job.toString()));
                LOG.debug((Object)("      job id: " + job.getId()));
                if (job.isPeriodic()) {
                    LOG.debug((Object)("      period: " + job.getPeriod()));
                }
                ++count;
            }
            LOG.debug((Object)"------------------------------------------");
        }
    }

    @Override
    public synchronized String jobStatusDump(JavaScriptJobManager.JavaScriptJobFilter filter) {
        StringBuilder status = new StringBuilder();
        status.append("------ JavaScript job status -----");
        status.append(LINE_SEPARARATOR);
        if (null != this.currentlyRunningJob_ && (filter == null || filter.passes(this.currentlyRunningJob_))) {
            status.append("  current running job: ").append(this.currentlyRunningJob_.toString());
            status.append("      job id: " + this.currentlyRunningJob_.getId());
            status.append(LINE_SEPARARATOR);
            status.append(LINE_SEPARARATOR);
            status.append(LINE_SEPARARATOR);
        }
        status.append("  number of jobs on the queue: " + this.scheduledJobsQ_.size());
        status.append(LINE_SEPARARATOR);
        int count = 1;
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            if (filter != null && !filter.passes(job)) continue;
            long now = System.currentTimeMillis();
            long execTime = job.getTargetExecutionTime();
            status.append("  " + count);
            status.append(")  Job target execution time: " + execTime);
            status.append(" (should start in " + (double)(execTime - now) / 1000.0 + "s)");
            status.append(LINE_SEPARARATOR);
            status.append("      job to string: ").append(job.toString());
            status.append(LINE_SEPARARATOR);
            status.append("      job id: " + job.getId());
            status.append(LINE_SEPARARATOR);
            if (job.isPeriodic()) {
                status.append("      period: " + job.getPeriod());
                status.append(LINE_SEPARARATOR);
            }
            ++count;
        }
        status.append("------------------------------------------");
        status.append(LINE_SEPARARATOR);
        return status.toString();
    }

    @Override
    public JavaScriptJob getEarliestJob() {
        return this.scheduledJobsQ_.peek();
    }

    @Override
    public synchronized JavaScriptJob getEarliestJob(JavaScriptJobManager.JavaScriptJobFilter filter) {
        if (filter == null) {
            return this.scheduledJobsQ_.peek();
        }
        for (JavaScriptJob job : this.scheduledJobsQ_) {
            if (!filter.passes(job)) continue;
            return job;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runSingleJob(JavaScriptJob givenJob) {
        assert (givenJob != null);
        JavaScriptJob job = this.getEarliestJob();
        if (job != givenJob) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (job.getTargetExecutionTime() > currentTime) {
            return false;
        }
        JavaScriptJobManagerImpl javaScriptJobManagerImpl = this;
        synchronized (javaScriptJobManagerImpl) {
            if (this.scheduledJobsQ_.remove(job)) {
                this.currentlyRunningJob_ = job;
            }
        }
        boolean debug = LOG.isDebugEnabled();
        boolean isPeriodicJob = job.isPeriodic();
        if (isPeriodicJob) {
            long jobPeriod = job.getPeriod().longValue();
            long timeDifference = currentTime - job.getTargetExecutionTime();
            timeDifference = timeDifference / jobPeriod * jobPeriod + jobPeriod;
            job.setTargetExecutionTime(job.getTargetExecutionTime() + timeDifference);
            JavaScriptJobManagerImpl javaScriptJobManagerImpl2 = this;
            synchronized (javaScriptJobManagerImpl2) {
                if (!this.cancelledJobs_.contains(job.getId())) {
                    if (debug) {
                        LOG.debug((Object)("Reschedulling job " + job));
                    }
                    this.scheduledJobsQ_.add(job);
                    this.notify();
                }
            }
        }
        if (debug) {
            String periodicJob = isPeriodicJob ? "interval " : "";
            LOG.debug((Object)("Starting " + periodicJob + "job " + job));
        }
        try {
            job.run();
        }
        catch (RuntimeException e) {
            LOG.error((Object)("Job run failed with unexpected RuntimeException: " + e.getMessage()), (Throwable)e);
        }
        finally {
            JavaScriptJobManagerImpl e = this;
            synchronized (e) {
                if (job == this.currentlyRunningJob_) {
                    this.currentlyRunningJob_ = null;
                }
                this.notify();
            }
        }
        if (debug) {
            String periodicJob = isPeriodicJob ? "interval " : "";
            LOG.debug((Object)("Finished " + (String)periodicJob + "job " + job));
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.scheduledJobsQ_ = new PriorityQueue();
        this.cancelledJobs_ = new ArrayList();
        this.currentlyRunningJob_ = null;
    }
}

