/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class History
extends SimpleScriptable {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.EDGE)})
    public History() {
    }

    @JsxGetter
    public int getLength() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getLength();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public Object getState() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getCurrentState();
    }

    @JsxFunction
    public void back() {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().back();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void forward() {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().forward();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction
    public void go(int relativeIndex) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().go(relativeIndex);
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public void replaceState(Object object, String title, String url) {
        WebWindow w = this.getWindow().getWebWindow();
        HtmlPage page = (HtmlPage)w.getEnclosedPage();
        try {
            URL newStateUrl = null;
            if (StringUtils.isNotBlank((CharSequence)url)) {
                newStateUrl = page.getFullyQualifiedUrl(url);
            }
            w.getHistory().replaceState(object, newStateUrl);
            if (newStateUrl != null) {
                page.getWebResponse().getWebRequest().setUrl(newStateUrl);
            }
        }
        catch (MalformedURLException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE)})
    public void pushState(Object object, String title, String url) {
        try {
            this.getWindow().getLocation().setHref(url, true, object);
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx((Throwable)e);
        }
    }
}

