/*
 * Decompiled with CFR 0.152.
 */
package play.twirl.parser;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.io.Codec;
import scala.io.Codec$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Properties$;

public final class TwirlIO$ {
    public static final TwirlIO$ MODULE$;
    private final String defaultEncoding;
    private final Codec defaultCodec;

    static {
        new TwirlIO$();
    }

    public String defaultEncoding() {
        return this.defaultEncoding;
    }

    public Codec defaultCodec() {
        return this.defaultCodec;
    }

    public byte[] readStream(InputStream stream) {
        byte[] buffer = new byte[8192];
        int len = stream.read(buffer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (len != -1) {
            out.write(buffer, 0, len);
            len = stream.read(buffer);
        }
        return out.toByteArray();
    }

    public byte[] readFile(File file) {
        FileInputStream is = new FileInputStream(file);
        try {
            return this.readStream(is);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    public String readStreamAsString(InputStream stream, Codec codec) {
        return new String(this.readStream(stream), codec.name());
    }

    public Codec readStreamAsString$default$2() {
        return this.defaultCodec();
    }

    public String readUrlAsString(URL url, Codec codec) {
        InputStream is = url.openStream();
        try {
            return this.readStreamAsString(is, codec);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    public Codec readUrlAsString$default$2() {
        return this.defaultCodec();
    }

    public String readFileAsString(File file, Codec codec) {
        FileInputStream is = new FileInputStream(file);
        try {
            return this.readStreamAsString(is, codec);
        }
        finally {
            this.closeQuietly(is);
        }
    }

    public Codec readFileAsString$default$2() {
        return this.defaultCodec();
    }

    public void writeStringToFile(File file, String contents, Codec codec) {
        Object object = file.getParentFile().exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)file.getParentFile().mkdirs());
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), codec.name());
        try {
            writer.write(contents);
            return;
        }
        finally {
            this.closeQuietly(writer);
        }
    }

    public Codec writeStringToFile$default$3() {
        return this.defaultCodec();
    }

    public void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void deleteRecursively(File dir) {
        if (dir.isDirectory()) {
            Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(File dir) {
                    TwirlIO$.MODULE$.deleteRecursively(dir);
                }
            });
        }
        dir.delete();
    }

    private TwirlIO$() {
        MODULE$ = this;
        this.defaultEncoding = Properties$.MODULE$.sourceEncoding();
        this.defaultCodec = Codec$.MODULE$.apply(this.defaultEncoding());
    }
}

