/*
 * Decompiled with CFR 0.152.
 */
package classycle.dependency;

import classycle.dependency.DependencyResult;
import classycle.dependency.PatternVertexCondition;
import classycle.dependency.Result;
import classycle.dependency.ResultContainer;
import classycle.dependency.ResultRenderer;
import classycle.dependency.SetDefinitionRepository;
import classycle.dependency.Statement;
import classycle.graph.AtomicVertex;
import classycle.graph.PathsFinder;
import classycle.graph.Vertex;
import classycle.graph.VertexCondition;
import classycle.util.OrStringPattern;
import classycle.util.StringPattern;
import java.util.HashSet;

public class DependencyStatement
implements Statement {
    private static final String CHECK = "check ";
    private final StringPattern[] _startSets;
    private final StringPattern[] _finalSets;
    private final StringPattern _finalSet;
    private final String _dependencyType;
    private final VertexCondition[] _startConditions;
    private final VertexCondition[] _finalConditions;
    private final VertexCondition _finalCondition;
    private final SetDefinitionRepository _repository;
    private final ResultRenderer _renderer;

    public DependencyStatement(StringPattern[] startSets, StringPattern[] finalSets, String dependencyType, SetDefinitionRepository repository, ResultRenderer renderer) {
        this._startSets = startSets;
        this._finalSets = finalSets;
        this._dependencyType = dependencyType;
        this._repository = repository;
        this._renderer = renderer;
        this._startConditions = this.createVertexConditions(startSets);
        this._finalConditions = this.createVertexConditions(finalSets);
        this._finalSet = new OrStringPattern(this._finalSets);
        this._finalCondition = new VertexUnionCondition(this._finalConditions);
    }

    private VertexCondition[] createVertexConditions(StringPattern[] patterns) {
        VertexCondition[] fromSets = new VertexCondition[patterns.length];
        for (int i = 0; i < fromSets.length; ++i) {
            fromSets[i] = new PatternVertexCondition(patterns[i]);
        }
        return fromSets;
    }

    public Result execute(AtomicVertex[] graph) {
        ResultContainer result = new ResultContainer();
        boolean directPathsOnly = "directlyIndependentOf".equals(this._dependencyType);
        boolean dependsOnly = "dependentOnlyOn".equals(this._dependencyType);
        for (int i = 0; i < this._startConditions.length; ++i) {
            VertexCondition startCondition = this._startConditions[i];
            StringPattern startSet = this._startSets[i];
            if (dependsOnly) {
                HashSet<AtomicVertex> invalids = new HashSet<AtomicVertex>();
                for (AtomicVertex vertex : graph) {
                    if (!startCondition.isFulfilled(vertex)) continue;
                    int n = vertex.getNumberOfOutgoingArcs();
                    for (int j = 0; j < n; ++j) {
                        Vertex headVertex = vertex.getHeadVertex(j);
                        if (this._finalCondition.isFulfilled(headVertex) || startCondition.isFulfilled(headVertex)) continue;
                        invalids.add(vertex);
                        invalids.add((AtomicVertex)headVertex);
                    }
                }
                result.add(new DependencyResult(startSet, this._finalSet, this.toString(startSet, this._finalSet), invalids.toArray(new AtomicVertex[0])));
                continue;
            }
            for (int j = 0; j < this._finalConditions.length; ++j) {
                PathsFinder finder = new PathsFinder(startCondition, this._finalConditions[j], this._renderer.onlyShortestPaths(), directPathsOnly);
                result.add(new DependencyResult(startSet, this._finalSets[j], this.toString(i, j), finder.findPaths(graph)));
            }
        }
        return result;
    }

    private String toString(int i, int j) {
        return this.toString(this._startSets[i], this._finalSets[j]);
    }

    private String toString(StringPattern startSet, StringPattern finalSet) {
        StringBuffer buffer = new StringBuffer(CHECK);
        buffer.append(this._repository.toString(startSet)).append(' ').append(this._dependencyType).append(' ').append(this._repository.toString(finalSet));
        return new String(buffer);
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer(CHECK);
        for (i = 0; i < this._startSets.length; ++i) {
            buffer.append(this._repository.toString(this._startSets[i])).append(' ');
        }
        buffer.append(this._dependencyType).append(' ');
        for (i = 0; i < this._finalSets.length; ++i) {
            buffer.append(this._repository.toString(this._finalSets[i])).append(' ');
        }
        return new String(buffer.substring(0, buffer.length() - 1));
    }

    private static final class VertexUnionCondition
    implements VertexCondition {
        private final VertexCondition[] _conditions;

        VertexUnionCondition(VertexCondition[] conditions) {
            this._conditions = conditions;
        }

        public boolean isFulfilled(Vertex vertex) {
            for (VertexCondition condition : this._conditions) {
                if (!condition.isFulfilled(vertex)) continue;
                return true;
            }
            return false;
        }
    }
}

