/*
 * Decompiled with CFR 0.152.
 */
package classycle.graph;

import classycle.graph.GraphProcessor;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import java.util.Arrays;
import java.util.Comparator;

public class LongestWalkProcessor
extends GraphProcessor {
    protected void initializeProcessing(Vertex[] graph) {
    }

    protected void processBefore(Vertex vertex) {
        StrongComponent component = this.castAsStrongComponent(vertex);
        component.setActive(true);
        component.setLongestWalk(0);
    }

    protected void processArc(Vertex tail, Vertex head) {
        StrongComponent t = this.castAsStrongComponent(tail);
        StrongComponent h = this.castAsStrongComponent(head);
        if (!h.isVisited()) {
            this.process(h);
        } else if (h.isActive()) {
            throw new IllegalArgumentException(h + " is not a strong component.");
        }
        t.setLongestWalk(Math.max(t.getLongestWalk(), 1 + h.getLongestWalk()));
    }

    protected void processAfter(Vertex vertex) {
        this.castAsStrongComponent(vertex).setActive(false);
    }

    protected void finishProcessing(Vertex[] graph) {
        Arrays.sort(graph, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((StrongComponent)obj1).getLongestWalk() - ((StrongComponent)obj2).getLongestWalk();
            }
        });
    }

    private StrongComponent castAsStrongComponent(Vertex vertex) {
        if (vertex instanceof StrongComponent) {
            return (StrongComponent)vertex;
        }
        throw new IllegalArgumentException(vertex + " is not an instance of StrongComponent");
    }
}

