/*
 * Decompiled with CFR 0.152.
 */
package play.api;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.stream.ActorMaterializer$;
import akka.stream.Materializer;
import play.api.Application;
import play.api.BuiltInComponents;
import play.api.DefaultApplication;
import play.api.GlobalSettings;
import play.api.GlobalSettings$;
import play.api.http.DefaultHttpErrorHandler;
import play.api.http.DefaultHttpRequestHandler;
import play.api.http.HttpConfiguration;
import play.api.http.HttpConfiguration$;
import play.api.http.HttpErrorHandler;
import play.api.http.HttpRequestHandler;
import play.api.inject.DefaultApplicationLifecycle;
import play.api.inject.Injector;
import play.api.inject.NewInstanceInjector$;
import play.api.inject.SimpleInjector;
import play.api.inject.SimpleInjector$;
import play.api.libs.Crypto;
import play.api.libs.Files;
import play.api.libs.concurrent.ActorSystemProvider;
import play.api.libs.crypto.AESCrypter;
import play.api.libs.crypto.AESCrypterProvider;
import play.api.libs.crypto.CSRFTokenSigner;
import play.api.libs.crypto.CSRFTokenSignerProvider;
import play.api.libs.crypto.CookieSigner;
import play.api.libs.crypto.CookieSignerProvider;
import play.api.libs.crypto.CryptoConfig;
import play.api.libs.crypto.CryptoConfigParser;
import play.api.routing.Router;
import scala.Function0;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;

public abstract class BuiltInComponents$class {
    public static Injector injector(BuiltInComponents $this) {
        return new SimpleInjector(NewInstanceInjector$.MODULE$, SimpleInjector$.MODULE$.$lessinit$greater$default$2()).$plus($this.router(), ClassTag$.MODULE$.apply(Router.class)).$plus($this.cookieSigner(), ClassTag$.MODULE$.apply(CookieSigner.class)).$plus($this.csrfTokenSigner(), ClassTag$.MODULE$.apply(CSRFTokenSigner.class)).$plus($this.httpConfiguration(), ClassTag$.MODULE$.apply(HttpConfiguration.class)).$plus($this.tempFileCreator(), ClassTag$.MODULE$.apply(Files.TemporaryFileCreator.class)).$plus($this.global(), ClassTag$.MODULE$.apply(GlobalSettings.class)).$plus($this.crypto(), ClassTag$.MODULE$.apply(Crypto.class));
    }

    public static HttpConfiguration httpConfiguration(BuiltInComponents $this) {
        return HttpConfiguration$.MODULE$.fromConfiguration($this.configuration());
    }

    public static HttpRequestHandler httpRequestHandler(BuiltInComponents $this) {
        return new DefaultHttpRequestHandler($this.router(), $this.httpErrorHandler(), $this.httpConfiguration(), $this.httpFilters());
    }

    public static HttpErrorHandler httpErrorHandler(BuiltInComponents $this) {
        return new DefaultHttpErrorHandler($this.environment(), $this.configuration(), $this.sourceMapper(), (Function0<Option<Router>>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BuiltInComponents $outer;

            public final Some<Router> apply() {
                return new Some((Object)this.$outer.router());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static Seq httpFilters(BuiltInComponents $this) {
        return Nil$.MODULE$;
    }

    public static DefaultApplicationLifecycle applicationLifecycle(BuiltInComponents $this) {
        return new DefaultApplicationLifecycle();
    }

    public static Application application(BuiltInComponents $this) {
        return new DefaultApplication($this.environment(), $this.applicationLifecycle(), $this.injector(), $this.configuration(), $this.httpRequestHandler(), $this.httpErrorHandler(), $this.actorSystem(), $this.materializer());
    }

    public static ActorSystem actorSystem(BuiltInComponents $this) {
        return new ActorSystemProvider($this.environment(), $this.configuration(), $this.applicationLifecycle()).get();
    }

    public static Materializer materializer(BuiltInComponents $this) {
        return ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)$this.actorSystem());
    }

    public static CryptoConfig cryptoConfig(BuiltInComponents $this) {
        return new CryptoConfigParser($this.environment(), $this.configuration()).get();
    }

    public static CookieSigner cookieSigner(BuiltInComponents $this) {
        return new CookieSignerProvider($this.cryptoConfig()).get();
    }

    public static CSRFTokenSigner csrfTokenSigner(BuiltInComponents $this) {
        return new CSRFTokenSignerProvider($this.cookieSigner()).get();
    }

    public static AESCrypter aesCrypter(BuiltInComponents $this) {
        return new AESCrypterProvider($this.cryptoConfig()).get();
    }

    public static Crypto crypto(BuiltInComponents $this) {
        return new Crypto($this.cookieSigner(), $this.csrfTokenSigner(), $this.aesCrypter());
    }

    public static GlobalSettings global(BuiltInComponents $this) {
        return GlobalSettings$.MODULE$.apply($this.configuration(), $this.environment());
    }

    public static Files.TemporaryFileCreator tempFileCreator(BuiltInComponents $this) {
        return new Files.DefaultTemporaryFileCreator($this.applicationLifecycle());
    }

    public static void $init$(BuiltInComponents $this) {
    }
}

