/*
 * Decompiled with CFR 0.152.
 */
package play.core.formatters;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import akka.stream.stage.Context;
import akka.stream.stage.PushPullStage;
import akka.stream.stage.SyncDirective;
import akka.stream.stage.TerminationDirective;
import akka.util.ByteString;
import akka.util.ByteString$;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import play.api.mvc.MultipartFormData;
import play.core.formatters.Multipart;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class Multipart$ {
    public static final Multipart$ MODULE$;
    public final byte[] play$core$formatters$Multipart$$alphabet;

    static {
        new Multipart$();
    }

    private String CrLf() {
        return "\r\n";
    }

    public Source<ByteString, ?> transform(Source<MultipartFormData.Part<Source<ByteString, ?>>, ?> body, String boundary) {
        return body.via(this.format(boundary, Charset.defaultCharset(), 4096));
    }

    public Flow<MultipartFormData.Part<Source<ByteString, ?>>, ByteString, NotUsed> format(String boundary, Charset nioCharset, int chunkSize) {
        return (Flow)Flow$.MODULE$.apply().transform((Function0)new Serializable(boundary, nioCharset, chunkSize){
            public static final long serialVersionUID = 0L;
            private final String boundary$1;
            private final Charset nioCharset$1;
            private final int chunkSize$1;

            public final PushPullStage<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>> apply() {
                return Multipart$.MODULE$.play$core$formatters$Multipart$$streamed(this.boundary$1, this.nioCharset$1, this.chunkSize$1);
            }
            {
                this.boundary$1 = boundary$1;
                this.nioCharset$1 = nioCharset$1;
                this.chunkSize$1 = chunkSize$1;
            }
        }).flatMapConcat((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Source<ByteString, Object> apply(Source<ByteString, Object> x) {
                return (Source)Predef$.MODULE$.identity(x);
            }
        });
    }

    public String randomBoundary(int length2, Random random) {
        if (length2 < 1 && length2 > 70) {
            throw new IllegalArgumentException("length can't be greater than 70 or less than 1");
        }
        Seq bytes = (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), length2).map((Function1)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$1;

            public final byte apply(int n) {
                return Multipart$.MODULE$.play$core$formatters$Multipart$$alphabet[this.random$1.nextInt(Multipart$.MODULE$.play$core$formatters$Multipart$$alphabet.length)];
            }
            {
                this.random$1 = random$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return new String((byte[])bytes.toArray(ClassTag$.MODULE$.Byte()), StandardCharsets.US_ASCII);
    }

    public int randomBoundary$default$1() {
        return 18;
    }

    public Random randomBoundary$default$2() {
        return ThreadLocalRandom.current();
    }

    public PushPullStage<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>> play$core$formatters$Multipart$$streamed(String boundary, Charset nioCharset, int chunkSize) {
        return new PushPullStage<MultipartFormData.Part<Source<ByteString, ?>>, Source<ByteString, Object>>(boundary, nioCharset, chunkSize){
            private boolean firstBoundaryRendered;
            private final String boundary$2;
            private final Charset nioCharset$2;
            private final int chunkSize$2;

            private boolean firstBoundaryRendered() {
                return this.firstBoundaryRendered;
            }

            private void firstBoundaryRendered_$eq(boolean x$1) {
                this.firstBoundaryRendered = x$1;
            }

            public SyncDirective onPush(MultipartFormData.Part<Source<ByteString, ?>> bodyPart, Context<Source<ByteString, Object>> ctx) {
                block6: {
                    Tuple3 tuple3;
                    Multipart.CustomCharsetByteStringFormatter f2;
                    block5: {
                        MultipartFormData.Part<Source<ByteString, ?>> part;
                        block4: {
                            f2 = new Multipart.CustomCharsetByteStringFormatter(this.nioCharset$2, this.chunkSize$2);
                            Multipart$.MODULE$.play$core$formatters$Multipart$$renderBoundary(f2, this.boundary$2, !this.firstBoundaryRendered());
                            this.firstBoundaryRendered_$eq(true);
                            part = bodyPart;
                            if (!(part instanceof MultipartFormData.DataPart)) break block4;
                            MultipartFormData.DataPart dataPart = (MultipartFormData.DataPart)part;
                            String innerKey = dataPart.key();
                            tuple3 = new Tuple3((Object)innerKey, (Object)None$.MODULE$, (Object)Option$.MODULE$.apply((Object)"text/plain"));
                            break block5;
                        }
                        if (!(part instanceof MultipartFormData.FilePart)) break block6;
                        MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                        String innerKey = filePart.key();
                        String innerFilename = filePart.filename();
                        Option<String> innerContentType = filePart.contentType();
                        tuple3 = new Tuple3((Object)innerKey, (Object)Option$.MODULE$.apply((Object)innerFilename), innerContentType);
                    }
                    Tuple3 tuple32 = tuple3;
                    if (tuple32 != null) {
                        Tuple3 tuple33;
                        String key = (String)tuple32._1();
                        Option filename = (Option)tuple32._2();
                        Option contentType2 = (Option)tuple32._3();
                        Tuple3 tuple34 = tuple33 = new Tuple3((Object)key, (Object)filename, (Object)contentType2);
                        String key2 = (String)tuple34._1();
                        Option filename2 = (Option)tuple34._2();
                        Option contentType3 = (Option)tuple34._3();
                        Multipart$.MODULE$.play$core$formatters$Multipart$$renderDisposition(f2, key2, (Option<String>)filename2);
                        contentType3.foreach((Function1)new Serializable(this, f2){
                            public static final long serialVersionUID = 0L;
                            private final Multipart.CustomCharsetByteStringFormatter f$1;

                            public final void apply(String ct) {
                                Multipart$.MODULE$.play$core$formatters$Multipart$$renderContentType(this.f$1, ct);
                            }
                            {
                                this.f$1 = f$1;
                            }
                        });
                        Multipart$.MODULE$.play$core$formatters$Multipart$$renderBuffer(f2);
                        return ctx.push((Object)this.completePartFormatting$1(bodyPart, f2));
                    }
                    throw new MatchError((Object)tuple32);
                }
                throw new UnsupportedOperationException();
            }

            public SyncDirective onPull(Context<Source<ByteString, Object>> ctx) {
                Object object;
                boolean finishing = ctx.isFinishing();
                if (finishing && this.firstBoundaryRendered()) {
                    Multipart.ByteStringFormatter f2 = new Multipart.ByteStringFormatter(this.boundary$2.length() + 4);
                    Multipart$.MODULE$.play$core$formatters$Multipart$$renderFinalBoundary(f2, this.boundary$2);
                    object = ctx.pushAndFinish((Object)Source$.MODULE$.single((Object)f2.get()));
                } else {
                    object = finishing ? ctx.finish() : ctx.pull();
                }
                return object;
            }

            public TerminationDirective onUpstreamFinish(Context<Source<ByteString, Object>> ctx) {
                return ctx.absorbTermination();
            }

            private final Source bodyPartChunks$1(Source data, Multipart.CustomCharsetByteStringFormatter f$1) {
                return ((Source)Source$.MODULE$.single((Object)f$1.get()).$plus$plus((Graph)data)).mapMaterializedValue((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(NotUsed x$1) {
                    }
                });
            }

            private final Source completePartFormatting$1(MultipartFormData.Part bodyPart$1, Multipart.CustomCharsetByteStringFormatter f$1) {
                block4: {
                    Source source;
                    block3: {
                        MultipartFormData.Part part;
                        block2: {
                            part = bodyPart$1;
                            if (!(part instanceof MultipartFormData.DataPart)) break block2;
                            MultipartFormData.DataPart dataPart = (MultipartFormData.DataPart)part;
                            String data = dataPart.value();
                            source = Source$.MODULE$.single((Object)f$1.$tilde$tilde(ByteString$.MODULE$.apply(data)).get());
                            break block3;
                        }
                        if (!(part instanceof MultipartFormData.FilePart)) break block4;
                        MultipartFormData.FilePart filePart = (MultipartFormData.FilePart)part;
                        Source ref = (Source)filePart.ref();
                        source = this.bodyPartChunks$1(ref, f$1);
                    }
                    return source;
                }
                throw new UnsupportedOperationException();
            }
            {
                this.boundary$2 = boundary$2;
                this.nioCharset$2 = nioCharset$2;
                this.chunkSize$2 = chunkSize$2;
                this.firstBoundaryRendered = false;
            }
        };
    }

    public void play$core$formatters$Multipart$$renderBoundary(Multipart.Formatter f2, String boundary, boolean suppressInitialCrLf) {
        Object object = suppressInitialCrLf ? BoxedUnit.UNIT : f2.$tilde$tilde(this.CrLf());
        f2.$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary).$tilde$tilde(this.CrLf());
    }

    private boolean renderBoundary$default$3() {
        return false;
    }

    public void play$core$formatters$Multipart$$renderFinalBoundary(Multipart.Formatter f2, String boundary) {
        f2.$tilde$tilde(this.CrLf()).$tilde$tilde('-').$tilde$tilde('-').$tilde$tilde(boundary).$tilde$tilde('-').$tilde$tilde('-');
    }

    public void play$core$formatters$Multipart$$renderDisposition(Multipart.Formatter f2, String contentDisposition, Option<String> filename) {
        f2.$tilde$tilde("Content-Disposition: form-data; name=").$tilde$tilde('\"').$tilde$tilde(contentDisposition).$tilde$tilde('\"');
        filename.foreach((Function1)new Serializable(f2){
            public static final long serialVersionUID = 0L;
            private final Multipart.Formatter f$2;

            public final Multipart.Formatter apply(String name2) {
                return this.f$2.$tilde$tilde("; filename=").$tilde$tilde('\"').$tilde$tilde(name2).$tilde$tilde('\"');
            }
            {
                this.f$2 = f$2;
            }
        });
        f2.$tilde$tilde(this.CrLf());
    }

    public void play$core$formatters$Multipart$$renderContentType(Multipart.Formatter f2, String contentType2) {
        f2.$tilde$tilde("Content-Type: ").$tilde$tilde(contentType2).$tilde$tilde(this.CrLf());
    }

    public void play$core$formatters$Multipart$$renderBuffer(Multipart.Formatter f2) {
        f2.$tilde$tilde(this.CrLf());
    }

    private Multipart$() {
        MODULE$ = this;
        this.play$core$formatters$Multipart$$alphabet = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes(StandardCharsets.US_ASCII);
    }
}

