/*
 * Decompiled with CFR 0.152.
 */
package play.http.websocket;

import akka.util.ByteString;
import java.util.Optional;

public abstract class Message {
    private Message() {
    }

    public static class Close
    extends Message {
        private final Optional<Integer> statusCode;
        private final String reason;

        public Close(int n) {
            this(n, "");
        }

        public Close(int n, String string2) {
            this(Optional.of(n), string2);
        }

        public Close(Optional<Integer> optional, String string2) {
            this.statusCode = optional;
            this.reason = string2;
        }

        public Optional<Integer> code() {
            return this.statusCode;
        }

        public String reason() {
            return this.reason;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Close close2 = (Close)object;
            return this.statusCode.equals(close2.statusCode) && this.reason.equals(close2.reason);
        }

        public int hashCode() {
            int n = this.statusCode.hashCode();
            n = 31 * n + this.reason.hashCode();
            return n;
        }

        public String toString() {
            return "CloseWebSocketMessage(" + this.statusCode + ", '" + this.reason + "')";
        }
    }

    public static class Pong
    extends Message {
        private final ByteString data;

        public Pong(ByteString byteString) {
            this.data = byteString;
        }

        public ByteString data() {
            return this.data;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Pong pong = (Pong)object;
            return this.data.equals((Object)pong.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public String toString() {
            return "PongWebSocketMessage('" + this.data + "')";
        }
    }

    public static class Ping
    extends Message {
        private final ByteString data;

        public Ping(ByteString byteString) {
            this.data = byteString;
        }

        public ByteString data() {
            return this.data;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Ping ping = (Ping)object;
            return this.data.equals((Object)ping.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public String toString() {
            return "PingWebSocketMessage('" + this.data + "')";
        }
    }

    public static class Binary
    extends Message {
        private final ByteString data;

        public Binary(ByteString byteString) {
            this.data = byteString;
        }

        public ByteString data() {
            return this.data;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Binary binary = (Binary)object;
            return this.data.equals((Object)binary.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public String toString() {
            return "BinaryWebSocketMessage('" + this.data + "')";
        }
    }

    public static class Text
    extends Message {
        private final String data;

        public Text(String string2) {
            this.data = string2;
        }

        public String data() {
            return this.data;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Text text2 = (Text)object;
            return this.data.equals(text2.data);
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public String toString() {
            return "TextWebSocketMessage('" + this.data + "')";
        }
    }
}

