/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import play.api.Application;
import play.api.Play;
import play.api.http.MediaRange;
import play.api.i18n.MessagesApi;
import play.api.libs.json.JsValue;
import play.api.mvc.Cookies$;
import play.api.mvc.Flash$;
import play.api.mvc.Headers;
import play.api.mvc.Session$;
import play.core.j.JavaHelpers$;
import play.core.j.JavaParsers;
import play.core.j.RequestHeaderImpl;
import play.core.system.RequestIdProvider;
import play.i18n.Lang;
import play.i18n.Messages;
import play.libs.Json;
import play.libs.Scala;
import play.libs.XML;
import play.mvc.MultipartFormatter;
import scala.Option;
import scala.Tuple2;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.compat.java8.OptionConverters;

public class Http {

    public static interface MimeTypes {
        public static final String TEXT = "text/plain";
        public static final String HTML = "text/html";
        public static final String JSON = "application/json";
        public static final String XML = "application/xml";
        public static final String CSS = "text/css";
        public static final String JAVASCRIPT = "text/javascript";
        public static final String FORM = "application/x-www-form-urlencoded";
        public static final String EVENT_STREAM = "text/event-stream";
        public static final String BINARY = "application/octet-stream";
    }

    public static interface Status {
        public static final int CONTINUE = 100;
        public static final int SWITCHING_PROTOCOLS = 101;
        public static final int OK = 200;
        public static final int CREATED = 201;
        public static final int ACCEPTED = 202;
        public static final int NON_AUTHORITATIVE_INFORMATION = 203;
        public static final int NO_CONTENT = 204;
        public static final int RESET_CONTENT = 205;
        public static final int PARTIAL_CONTENT = 206;
        public static final int MULTI_STATUS = 207;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int MOVED_PERMANENTLY = 301;
        public static final int FOUND = 302;
        public static final int SEE_OTHER = 303;
        public static final int NOT_MODIFIED = 304;
        public static final int USE_PROXY = 305;
        public static final int TEMPORARY_REDIRECT = 307;
        public static final int PERMANENT_REDIRECT = 308;
        public static final int BAD_REQUEST = 400;
        public static final int UNAUTHORIZED = 401;
        public static final int PAYMENT_REQUIRED = 402;
        public static final int FORBIDDEN = 403;
        public static final int NOT_FOUND = 404;
        public static final int METHOD_NOT_ALLOWED = 405;
        public static final int NOT_ACCEPTABLE = 406;
        public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
        public static final int REQUEST_TIMEOUT = 408;
        public static final int CONFLICT = 409;
        public static final int GONE = 410;
        public static final int LENGTH_REQUIRED = 411;
        public static final int PRECONDITION_FAILED = 412;
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_URI_TOO_LONG = 414;
        public static final int UNSUPPORTED_MEDIA_TYPE = 415;
        public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
        public static final int EXPECTATION_FAILED = 417;
        public static final int UNPROCESSABLE_ENTITY = 422;
        public static final int LOCKED = 423;
        public static final int FAILED_DEPENDENCY = 424;
        public static final int UPGRADE_REQUIRED = 426;
        public static final int TOO_MANY_REQUESTS = 429;
        public static final int INTERNAL_SERVER_ERROR = 500;
        public static final int NOT_IMPLEMENTED = 501;
        public static final int BAD_GATEWAY = 502;
        public static final int SERVICE_UNAVAILABLE = 503;
        public static final int GATEWAY_TIMEOUT = 504;
        public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
        public static final int INSUFFICIENT_STORAGE = 507;
    }

    public static interface HeaderNames {
        public static final String ACCEPT = "Accept";
        public static final String ACCEPT_CHARSET = "Accept-Charset";
        public static final String ACCEPT_ENCODING = "Accept-Encoding";
        public static final String ACCEPT_LANGUAGE = "Accept-Language";
        public static final String ACCEPT_RANGES = "Accept-Ranges";
        public static final String AGE = "Age";
        public static final String ALLOW = "Allow";
        public static final String AUTHORIZATION = "Authorization";
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String CONTENT_DISPOSITION = "Content-Disposition";
        public static final String CONTENT_ENCODING = "Content-Encoding";
        public static final String CONTENT_LANGUAGE = "Content-Language";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final String CONTENT_LOCATION = "Content-Location";
        public static final String CONTENT_MD5 = "Content-MD5";
        public static final String CONTENT_RANGE = "Content-Range";
        public static final String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String COOKIE = "Cookie";
        public static final String DATE = "Date";
        public static final String ETAG = "ETag";
        public static final String EXPECT = "Expect";
        public static final String EXPIRES = "Expires";
        public static final String FORWARDED = "Forwarded";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String IF_MATCH = "If-Match";
        public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
        public static final String IF_NONE_MATCH = "If-None-Match";
        public static final String IF_RANGE = "If-Range";
        public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
        public static final String LAST_MODIFIED = "Last-Modified";
        public static final String LOCATION = "Location";
        public static final String MAX_FORWARDS = "Max-Forwards";
        public static final String PRAGMA = "Pragma";
        public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
        public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
        public static final String RANGE = "Range";
        public static final String REFERER = "Referer";
        public static final String RETRY_AFTER = "Retry-After";
        public static final String SERVER = "Server";
        public static final String SET_COOKIE = "Set-Cookie";
        public static final String SET_COOKIE2 = "Set-Cookie2";
        public static final String TE = "Te";
        public static final String TRAILER = "Trailer";
        public static final String TRANSFER_ENCODING = "Transfer-Encoding";
        public static final String UPGRADE = "Upgrade";
        public static final String USER_AGENT = "User-Agent";
        public static final String VARY = "Vary";
        public static final String VIA = "Via";
        public static final String WARNING = "Warning";
        public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
        public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
        public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
        public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
        public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
        public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
        public static final String ORIGIN = "Origin";
        public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
        public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
        public static final String X_FORWARDED_FOR = "X-Forwarded-For";
        public static final String X_FORWARDED_HOST = "X-Forwarded-Host";
        public static final String X_FORWARDED_PORT = "X-Forwarded-Port";
        public static final String X_FORWARDED_PROTO = "X-Forwarded-Proto";
        public static final String X_REQUESTED_WITH = "X-Requested-With";
    }

    public static interface Cookies
    extends Iterable<Cookie> {
        public Cookie get(String var1);
    }

    public static class CookieBuilder {
        private String name;
        private String value;
        private Integer maxAge;
        private String path = "/";
        private String domain;
        private boolean secure = false;
        private boolean httpOnly = false;

        private CookieBuilder(String string2, String string3) {
            this.name = string2;
            this.value = string3;
        }

        public CookieBuilder withName(String string2) {
            this.name = string2;
            return this;
        }

        public CookieBuilder withValue(String string2) {
            this.value = string2;
            return this;
        }

        public CookieBuilder withMaxAge(Integer n) {
            this.maxAge = n;
            return this;
        }

        public CookieBuilder withPath(String string2) {
            this.path = string2;
            return this;
        }

        public CookieBuilder withDomain(String string2) {
            this.domain = string2;
            return this;
        }

        public CookieBuilder withSecure(boolean bl) {
            this.secure = bl;
            return this;
        }

        public CookieBuilder withHttpOnly(boolean bl) {
            this.httpOnly = bl;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.maxAge, this.path, this.domain, this.secure, this.httpOnly);
        }
    }

    public static class Cookie {
        private final String name;
        private final String value;
        private final Integer maxAge;
        private final String path;
        private final String domain;
        private final boolean secure;
        private final boolean httpOnly;

        public Cookie(String string2, String string3, Integer n, String string4, String string5, boolean bl, boolean bl2) {
            this.name = string2;
            this.value = string3;
            this.maxAge = n;
            this.path = string4;
            this.domain = string5;
            this.secure = bl;
            this.httpOnly = bl2;
        }

        public static CookieBuilder builder(String string2, String string3) {
            return new CookieBuilder(string2, string3);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Integer maxAge() {
            return this.maxAge;
        }

        public String path() {
            return this.path;
        }

        public String domain() {
            return this.domain;
        }

        public boolean secure() {
            return this.secure;
        }

        public boolean httpOnly() {
            return this.httpOnly;
        }
    }

    public static class Flash
    extends HashMap<String, String> {
        public boolean isDirty = false;

        public Flash(Map<String, String> map2) {
            super(map2);
        }

        @Override
        public String remove(Object object) {
            this.isDirty = true;
            return (String)super.remove(object);
        }

        @Override
        public String put(String string2, String string3) {
            this.isDirty = true;
            return super.put(string2, string3);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map2) {
            this.isDirty = true;
            super.putAll(map2);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }
    }

    public static class Session
    extends HashMap<String, String> {
        public boolean isDirty = false;

        public Session(Map<String, String> map2) {
            super(map2);
        }

        @Override
        public String remove(Object object) {
            this.isDirty = true;
            return (String)super.remove(object);
        }

        @Override
        public String put(String string2, String string3) {
            this.isDirty = true;
            return super.put(string2, string3);
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map2) {
            this.isDirty = true;
            super.putAll(map2);
        }

        @Override
        public void clear() {
            this.isDirty = true;
            super.clear();
        }
    }

    public static class Response
    implements HeaderNames {
        private final Map<String, String> headers = new TreeMap<String, String>(String::compareToIgnoreCase);
        private final List<Cookie> cookies = new ArrayList<Cookie>();

        public void setHeader(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("Header name cannot be null!");
            }
            if (string3 == null) {
                throw new NullPointerException("Header value cannot be null!");
            }
            this.headers.put(string2, string3);
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Deprecated
        public void setContentType(String string2) {
        }

        @Deprecated
        public void setCookie(String string2, String string3) {
            this.setCookie(string2, string3, null);
        }

        @Deprecated
        public void setCookie(String string2, String string3, Integer n) {
            this.setCookie(string2, string3, n, "/");
        }

        @Deprecated
        public void setCookie(String string2, String string3, Integer n, String string4) {
            this.setCookie(string2, string3, n, string4, null);
        }

        @Deprecated
        public void setCookie(String string2, String string3, Integer n, String string4, String string5) {
            this.setCookie(string2, string3, n, string4, string5, false, false);
        }

        public void setCookie(String string2, String string3, Integer n, String string4, String string5, boolean bl, boolean bl2) {
            this.cookies.add(new Cookie(string2, string3, n, string4, string5, bl, bl2));
        }

        public void setCookie(Cookie cookie) {
            this.cookies.add(cookie);
        }

        public void discardCookie(String string2) {
            this.discardCookie(string2, "/", null, false);
        }

        public void discardCookie(String string2, String string3) {
            this.discardCookie(string2, string3, null, false);
        }

        public void discardCookie(String string2, String string3, String string4) {
            this.discardCookie(string2, string3, string4, false);
        }

        public void discardCookie(String string2, String string3, String string4, boolean bl) {
            this.cookies.add(new Cookie(string2, "", -86400, string3, string4, bl, false));
        }

        public Collection<Cookie> cookies() {
            return this.cookies;
        }

        public Optional<Cookie> cookie(String string2) {
            return this.cookies.stream().filter(cookie -> cookie.name().equals(string2)).findFirst();
        }
    }

    public static final class RequestBody {
        private final Object body;

        public RequestBody(Object object) {
            this.body = object;
        }

        public <A> MultipartFormData<A> asMultipartFormData() {
            return this.as(MultipartFormData.class);
        }

        public Map<String, String[]> asFormUrlEncoded() {
            if (this.body instanceof Map) {
                if (((Map)this.body).isEmpty()) {
                    return Collections.emptyMap();
                }
                Map.Entry entry = ((Map)this.body).entrySet().iterator().next();
                if (entry.getKey() instanceof String && entry.getValue() instanceof String[]) {
                    return (Map)this.body;
                }
            }
            return null;
        }

        public RawBuffer asRaw() {
            return this.as(RawBuffer.class);
        }

        public String asText() {
            return this.as(String.class);
        }

        public Document asXml() {
            return this.as(Document.class);
        }

        public JsonNode asJson() {
            return this.as(JsonNode.class);
        }

        public ByteString asBytes() {
            if (this.body == null) {
                return ByteString.empty();
            }
            if (this.body instanceof Optional) {
                if (!((Optional)this.body).isPresent()) {
                    return ByteString.empty();
                }
            } else {
                if (this.body instanceof ByteString) {
                    return (ByteString)this.body;
                }
                if (this.body instanceof byte[]) {
                    return ByteString.fromArray((byte[])((byte[])this.body));
                }
                if (this.body instanceof String) {
                    return ByteString.fromString((String)((String)this.body));
                }
                if (this.body instanceof RawBuffer) {
                    return ((RawBuffer)this.body).asBytes();
                }
                if (this.body instanceof JsonNode) {
                    return ByteString.fromString((String)Json.stringify((JsonNode)((JsonNode)this.body)));
                }
                if (this.body instanceof Document) {
                    return XML.toBytes((Document)this.body);
                }
                Map<String, String[]> map2 = this.asFormUrlEncoded();
                if (map2 != null) {
                    return ByteString.fromString((String)map2.entrySet().stream().flatMap(entry -> {
                        String string2 = this.encode((String)entry.getKey());
                        return Arrays.asList((Object[])entry.getValue()).stream().map(string3 -> string2 + "=" + this.encode((String)string3));
                    }).collect(Collectors.joining("&")));
                }
            }
            return null;
        }

        private String encode(String string2) {
            try {
                return URLEncoder.encode(string2, "utf8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }

        public <T> T as(Class<T> clazz) {
            if (clazz.isInstance(this.body)) {
                return clazz.cast(this.body);
            }
            return null;
        }

        public String toString() {
            return "RequestBody of " + (this.body == null ? "null" : this.body.getClass());
        }
    }

    public static abstract class MultipartFormData<A> {
        public abstract Map<String, String[]> asFormUrlEncoded();

        public abstract List<FilePart<A>> getFiles();

        public FilePart<A> getFile(String string2) {
            for (FilePart<A> filePart : this.getFiles()) {
                if (!filePart.getKey().equals(string2)) continue;
                return filePart;
            }
            return null;
        }

        public static class DataPart
        implements Part<Source<ByteString, ?>> {
            private final String key;
            private final String value;

            public DataPart(String string2, String string3) {
                this.key = string2;
                this.value = string3;
            }

            public String getKey() {
                return this.key;
            }

            public String getValue() {
                return this.value;
            }
        }

        public static class FilePart<A>
        implements Part<A> {
            final String key;
            final String filename;
            final String contentType;
            final A file;

            public FilePart(String string2, String string3, String string4, A a) {
                this.key = string2;
                this.filename = string3;
                this.contentType = string4;
                this.file = a;
            }

            public String getKey() {
                return this.key;
            }

            public String getFilename() {
                return this.filename;
            }

            public String getContentType() {
                return this.contentType;
            }

            public A getFile() {
                return this.file;
            }
        }

        public static interface Part<A> {
        }

        public static class FileInfo {
            private final String key;
            private final String filename;
            private final String contentType;

            public FileInfo(String string2, String string3, String string4) {
                this.key = string2;
                this.filename = string3;
                this.contentType = string4;
            }

            public String getKey() {
                return this.key;
            }

            public String getFilename() {
                return this.filename;
            }

            public String getContentType() {
                return this.contentType;
            }
        }
    }

    public static abstract class RawBuffer {
        public abstract Long size();

        public abstract ByteString asBytes(int var1);

        public abstract ByteString asBytes();

        public abstract File asFile();
    }

    public static class RequestBuilder {
        protected RequestBody body;
        protected String username;
        protected Long id = RequestIdProvider.requestIDs().incrementAndGet();
        protected Map<String, String> tags = new HashMap<String, String>();
        protected String method;
        protected boolean secure;
        protected URI uri;
        protected String version;
        protected Map<String, String[]> headers = new HashMap<String, String[]>();
        protected String remoteAddress;
        protected Optional<List<X509Certificate>> clientCertificateChain = Optional.empty();

        public RequestBuilder() {
            this.method("GET");
            this.uri("/");
            this.host("localhost");
            this.version("HTTP/1.1");
            this.remoteAddress("127.0.0.1");
            this.body(new RequestBody(null));
        }

        public RequestBody body() {
            return this.body;
        }

        public String username() {
            return this.username;
        }

        public RequestBuilder username(String string2) {
            this.username = string2;
            return this;
        }

        protected RequestBuilder body(RequestBody requestBody, String string2) {
            this.header("Content-Type", string2);
            this.body(requestBody);
            return this;
        }

        protected RequestBuilder body(RequestBody requestBody) {
            this.body = requestBody;
            return this;
        }

        public RequestBuilder bodyRaw(ByteString byteString) {
            play.api.mvc.RawBuffer rawBuffer = new play.api.mvc.RawBuffer(byteString.size(), byteString);
            return this.body(new RequestBody(JavaParsers.toJavaRaw(rawBuffer)), "application/octet-stream");
        }

        public RequestBuilder bodyRaw(byte[] byArray) {
            return this.bodyRaw(ByteString.fromArray((byte[])byArray));
        }

        public RequestBuilder bodyFormArrayValues(Map<String, String[]> map2) {
            return this.body(new RequestBody(map2), "application/x-www-form-urlencoded");
        }

        public RequestBuilder bodyForm(Map<String, String> map2) {
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            for (Map.Entry<String, String> entry : map2.entrySet()) {
                hashMap.put(entry.getKey(), new String[]{entry.getValue()});
            }
            return this.bodyFormArrayValues(hashMap);
        }

        public RequestBuilder bodyMultipart(List<MultipartFormData.Part<Source<ByteString, ?>>> list, Materializer materializer) {
            String string2 = MultipartFormatter.randomBoundary();
            try {
                ByteString byteString = (ByteString)((CompletionStage)MultipartFormatter.transform(Source.from(list), string2).runWith((Graph)Sink.reduce(ByteString::concat), materializer)).toCompletableFuture().get();
                play.api.mvc.RawBuffer rawBuffer = new play.api.mvc.RawBuffer(byteString.size(), byteString);
                return this.body(new RequestBody(JavaParsers.toJavaRaw(rawBuffer)), MultipartFormatter.boundaryToContentType(string2));
            }
            catch (InterruptedException | ExecutionException exception) {
                throw new RuntimeException("Failure while materializing Multipart/Form Data");
            }
        }

        public RequestBuilder bodyJson(JsonNode jsonNode) {
            return this.body(new RequestBody(jsonNode), "application/json");
        }

        public RequestBuilder bodyJson(JsValue jsValue) {
            return this.bodyJson(Json.parse((String)play.api.libs.json.Json.stringify((JsValue)jsValue)));
        }

        public RequestBuilder bodyXml(InputSource inputSource) {
            return this.bodyXml(XML.fromInputSource(inputSource));
        }

        public RequestBuilder bodyXml(Document document) {
            return this.body(new RequestBody(document), "application/xml");
        }

        public RequestBuilder bodyText(String string2) {
            return this.body(new RequestBody(string2), "text/plain");
        }

        public RequestImpl build() {
            return new RequestImpl(new play.api.mvc.RequestImpl<RequestBody>(this.body(), this.id, Scala.asScala(this.tags()), this.uri.toString(), this.uri.getRawPath(), this.method, this.version, RequestBuilder.mapListToScala(this.splitQuery()), this.buildHeaders(), this.remoteAddress, this.secure, (Option<Seq<X509Certificate>>)OptionConverters.toScala(this.clientCertificateChain.map(list -> JavaConversions.asScalaBuffer((List)list).toSeq()))));
        }

        public Long id() {
            return this.id;
        }

        public RequestBuilder id(Long l) {
            this.id = l;
            return this;
        }

        public Map<String, String> tags() {
            return this.tags;
        }

        public RequestBuilder tags(Map<String, String> map2) {
            this.tags = map2;
            return this;
        }

        public RequestBuilder tag(String string2, String string3) {
            this.tags.put(string2, string3);
            return this;
        }

        public String method() {
            return this.method;
        }

        public RequestBuilder method(String string2) {
            this.method = string2;
            return this;
        }

        public String uri() {
            return this.uri.toString();
        }

        public RequestBuilder uri(URI uRI) {
            if (uRI.getScheme() != null) {
                if (!uRI.getScheme().equals("http") && !uRI.getScheme().equals("https")) {
                    throw new IllegalArgumentException("URI scheme must be http or https");
                }
                this.secure = uRI.getScheme().equals("https");
            }
            this.uri = uRI;
            if (uRI.getHost() != null) {
                this.host(uRI.getHost());
            }
            return this;
        }

        public RequestBuilder uri(String string2) {
            try {
                this.uri(new URI(string2));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Exception parsing URI", uRISyntaxException);
            }
            return this;
        }

        public RequestBuilder secure(boolean bl) {
            this.secure = bl;
            return this;
        }

        public boolean secure() {
            return this.secure;
        }

        public String host() {
            return this.header("Host");
        }

        public RequestBuilder host(String string2) {
            this.header("Host", string2);
            return this;
        }

        public String path() {
            return this.uri.getRawPath();
        }

        public RequestBuilder path(String string2) {
            try {
                this.uri = new URI(this.uri.getScheme(), this.uri.getUserInfo(), this.uri.getHost(), this.uri.getPort(), string2, this.uri.getQuery(), this.uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException(uRISyntaxException);
            }
            return this;
        }

        public String version() {
            return this.version;
        }

        public RequestBuilder version(String string2) {
            this.version = string2;
            return this;
        }

        public String header(String string2) {
            String[] stringArray = this.headers.get(string2);
            return stringArray == null || stringArray.length == 0 ? null : stringArray[0];
        }

        public String[] headers(String string2) {
            return this.headers.get(string2);
        }

        public Map<String, String[]> headers() {
            return this.headers;
        }

        public RequestBuilder headers(Map<String, String[]> map2) {
            this.headers = map2;
            return this;
        }

        public RequestBuilder header(String string2, String[] stringArray) {
            this.headers.put(string2, stringArray);
            return this;
        }

        public RequestBuilder header(String string2, String string3) {
            this.headers.put(string2, new String[]{string3});
            return this;
        }

        private play.api.mvc.Cookies scalaCookies() {
            String string2 = this.header("Cookie");
            Option option = Option.apply((Object)string2);
            return Cookies$.MODULE$.fromCookieHeader((Option<String>)option);
        }

        public Cookies cookies() {
            return JavaHelpers$.MODULE$.cookiesToJavaCookies(this.scalaCookies());
        }

        private void cookies(Seq<play.api.mvc.Cookie> seq2) {
            String string2 = this.header("Cookie");
            String string3 = Cookies$.MODULE$.mergeCookieHeader(string2 != null ? string2 : "", seq2);
            this.header("Cookie", string3);
        }

        public RequestBuilder cookie(Cookie cookie) {
            this.cookies(JavaHelpers$.MODULE$.cookiesToScalaCookies(Arrays.asList(cookie)));
            return this;
        }

        public Map<String, String> flash() {
            play.api.mvc.Cookies cookies = this.scalaCookies();
            Option<play.api.mvc.Cookie> option = cookies.get(Flash$.MODULE$.COOKIE_NAME());
            scala.collection.immutable.Map<String, String> map2 = Flash$.MODULE$.decodeCookieToMap(option);
            return JavaConversions.mapAsJavaMap(map2);
        }

        public RequestBuilder flash(String string2, String string3) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.flash());
            hashMap.put(string2, string3);
            this.flash(hashMap);
            return this;
        }

        public RequestBuilder flash(Map<String, String> map2) {
            play.api.mvc.Flash flash = new play.api.mvc.Flash(Scala.asScala(map2));
            this.cookies((Seq<play.api.mvc.Cookie>)JavaConversions.asScalaBuffer(Arrays.asList(Flash$.MODULE$.encodeAsCookie(flash))));
            return this;
        }

        public Map<String, String> session() {
            play.api.mvc.Cookies cookies = this.scalaCookies();
            Option<play.api.mvc.Cookie> option = cookies.get(Session$.MODULE$.COOKIE_NAME());
            scala.collection.immutable.Map<String, String> map2 = Session$.MODULE$.decodeCookieToMap(option);
            return JavaConversions.mapAsJavaMap(map2);
        }

        public RequestBuilder session(String string2, String string3) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.session());
            hashMap.put(string2, string3);
            this.session(hashMap);
            return this;
        }

        public RequestBuilder session(Map<String, String> map2) {
            play.api.mvc.Session session = new play.api.mvc.Session(Scala.asScala(map2));
            this.cookies((Seq<play.api.mvc.Cookie>)JavaConversions.asScalaBuffer(Arrays.asList(Session$.MODULE$.encodeAsCookie(session))));
            return this;
        }

        public String remoteAddress() {
            return this.remoteAddress;
        }

        public RequestBuilder remoteAddress(String string2) {
            this.remoteAddress = string2;
            return this;
        }

        public Optional<List<X509Certificate>> clientCertificateChain() {
            return this.clientCertificateChain;
        }

        public RequestBuilder clientCertificateChain(List<X509Certificate> list) {
            this.clientCertificateChain = Optional.ofNullable(list);
            return this;
        }

        protected Map<String, List<String>> splitQuery() {
            try {
                String[] stringArray;
                LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
                String string2 = this.uri.getRawQuery();
                if (string2 == null) {
                    return new HashMap<String, List<String>>();
                }
                for (String string3 : stringArray = string2.split("&")) {
                    String string4;
                    int n = string3.indexOf("=");
                    String string5 = string4 = n > 0 ? URLDecoder.decode(string3.substring(0, n), "UTF-8") : string3;
                    if (!linkedHashMap.containsKey(string4)) {
                        linkedHashMap.put(string4, new LinkedList());
                    }
                    String string6 = n > 0 && string3.length() > n + 1 ? URLDecoder.decode(string3.substring(n + 1), "UTF-8") : null;
                    ((List)linkedHashMap.get(string4)).add(string6);
                }
                return linkedHashMap;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalStateException("This can never happen", unsupportedEncodingException);
            }
        }

        protected static scala.collection.immutable.Map<String, Seq<String>> mapListToScala(Map<String, List<String>> map2) {
            HashMap<String, Buffer> hashMap = new HashMap<String, Buffer>();
            for (String string2 : map2.keySet()) {
                hashMap.put(string2, JavaConversions.asScalaBuffer(map2.get(string2)));
            }
            return Scala.asScala(hashMap);
        }

        protected Headers buildHeaders() {
            ArrayList<Tuple2> arrayList = new ArrayList<Tuple2>();
            for (Map.Entry<String, String[]> entry : this.headers().entrySet()) {
                for (String string2 : entry.getValue()) {
                    arrayList.add(new Tuple2((Object)entry.getKey(), (Object)string2));
                }
            }
            return new Headers((Seq<Tuple2<String, String>>)JavaConversions.asScalaBuffer(arrayList));
        }
    }

    public static class RequestImpl
    extends RequestHeaderImpl
    implements Request {
        private final play.api.mvc.Request<RequestBody> underlying;
        private String username;

        public RequestImpl(play.api.mvc.RequestHeader requestHeader) {
            super(requestHeader);
            this.underlying = null;
        }

        public RequestImpl(play.api.mvc.Request<RequestBody> request) {
            super(request);
            this.underlying = request;
        }

        private RequestImpl(play.api.mvc.Request<RequestBody> request, String string2) {
            super(request);
            this.underlying = request;
            this.username = string2;
        }

        @Override
        public RequestBody body() {
            return this.underlying != null ? this.underlying.body() : null;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public void setUsername(String string2) {
            this.username = string2;
        }

        @Override
        public Request withUsername(String string2) {
            return new RequestImpl(this.underlying, string2);
        }

        @Override
        public play.api.mvc.Request<RequestBody> _underlyingRequest() {
            return this.underlying;
        }
    }

    public static interface Request
    extends RequestHeader {
        public RequestBody body();

        public String username();

        @Deprecated
        public void setUsername(String var1);

        public Request withUsername(String var1);

        public play.api.mvc.Request<RequestBody> _underlyingRequest();
    }

    public static interface RequestHeader {
        public String uri();

        public String method();

        public String version();

        public String remoteAddress();

        public boolean secure();

        public String host();

        public String path();

        public List<Lang> acceptLanguages();

        public List<MediaRange> acceptedTypes();

        public boolean accepts(String var1);

        public Map<String, String[]> queryString();

        public String getQueryString(String var1);

        public Cookies cookies();

        public Cookie cookie(String var1);

        public Map<String, String[]> headers();

        public String getHeader(String var1);

        public boolean hasHeader(String var1);

        public Optional<String> contentType();

        public Optional<String> charset();

        public Optional<List<X509Certificate>> clientCertificateChain();

        public Map<String, String> tags();

        public play.api.mvc.RequestHeader _underlyingHeader();
    }

    public static abstract class WrappedContext
    extends Context {
        private final Context wrapped;

        public WrappedContext(Context context) {
            super(context.id(), context._requestHeader(), context.request(), context.session(), context.flash(), context.args);
            this.args = context.args;
            this.wrapped = context;
        }

        @Override
        public Long id() {
            return this.wrapped.id();
        }

        @Override
        public Request request() {
            return this.wrapped.request();
        }

        @Override
        public Response response() {
            return this.wrapped.response();
        }

        @Override
        public Session session() {
            return this.wrapped.session();
        }

        @Override
        public Flash flash() {
            return this.wrapped.flash();
        }

        @Override
        public play.api.mvc.RequestHeader _requestHeader() {
            return this.wrapped._requestHeader();
        }

        @Override
        public Lang lang() {
            return this.wrapped.lang();
        }

        @Override
        public boolean changeLang(String string2) {
            return this.wrapped.changeLang(string2);
        }

        @Override
        public boolean changeLang(Lang lang) {
            return this.wrapped.changeLang(lang);
        }

        @Override
        public void clearLang() {
            this.wrapped.clearLang();
        }
    }

    public static class Context {
        public static ThreadLocal<Context> current = new ThreadLocal();
        private final Long id;
        private final play.api.mvc.RequestHeader header;
        private final Request request;
        private final Response response;
        private final Session session;
        private final Flash flash;
        private Lang lang = null;
        public Map<String, Object> args;

        public static Context current() {
            Context context = current.get();
            if (context == null) {
                throw new RuntimeException("There is no HTTP Context available from here.");
            }
            return context;
        }

        public Context(RequestBuilder requestBuilder) {
            this(requestBuilder.build());
        }

        public Context(Request request) {
            this.request = request;
            this.header = request._underlyingHeader();
            this.id = this.header.id();
            this.response = new Response();
            this.session = new Session(JavaConversions.mapAsJavaMap(this.header.session().data()));
            this.flash = new Flash(JavaConversions.mapAsJavaMap(this.header.flash().data()));
            this.args = new HashMap<String, Object>();
            this.args.putAll(JavaConversions.mapAsJavaMap(this.header.tags()));
        }

        public Context(Long l, play.api.mvc.RequestHeader requestHeader, Request request, Map<String, String> map2, Map<String, String> map3, Map<String, Object> map4) {
            this.id = l;
            this.header = requestHeader;
            this.request = request;
            this.response = new Response();
            this.session = new Session(map2);
            this.flash = new Flash(map3);
            this.args = new HashMap<String, Object>(map4);
        }

        public Long id() {
            return this.id;
        }

        public Request request() {
            return this.request;
        }

        public Response response() {
            return this.response;
        }

        public Session session() {
            return this.session;
        }

        public Flash flash() {
            return this.flash;
        }

        public play.api.mvc.RequestHeader _requestHeader() {
            return this.header;
        }

        public Lang lang() {
            if (this.lang != null) {
                return this.lang;
            }
            return this.messages().lang();
        }

        public Messages messages() {
            Cookie cookie = this.request().cookies().get(this.messagesApi().langCookieName());
            Lang lang = cookie == null ? null : new Lang(play.api.i18n.Lang.apply(cookie.value()));
            LinkedList linkedList = Lists.newLinkedList(this.request().acceptLanguages());
            if (lang != null) {
                linkedList.addFirst(lang);
            }
            if (this.lang != null) {
                linkedList.addFirst(this.lang);
            }
            return this.messagesApi().preferred(linkedList);
        }

        public boolean changeLang(String string2) {
            return this.changeLang(Lang.forCode(string2));
        }

        public boolean changeLang(Lang lang) {
            if (Lang.availables(this.currentApp()).contains((Object)lang)) {
                this.lang = lang;
                Option<String> option = play.api.mvc.Session.domain();
                this.response.setCookie(this.messagesApi().langCookieName(), lang.code(), null, play.api.mvc.Session.path(), option.isDefined() ? (String)option.get() : null, this.messagesApi().langCookieSecure(), this.messagesApi().langCookieHttpOnly());
                return true;
            }
            return false;
        }

        public void clearLang() {
            this.lang = null;
            Option<String> option = play.api.mvc.Session.domain();
            this.response.discardCookie(this.messagesApi().langCookieName(), play.api.mvc.Session.path(), option.isDefined() ? (String)option.get() : null, this.messagesApi().langCookieSecure());
        }

        public void setTransientLang(String string2) {
            this.setTransientLang(Lang.forCode(string2));
        }

        public void setTransientLang(Lang lang) {
            if (!Lang.availables(this.currentApp()).contains((Object)lang)) {
                throw new IllegalArgumentException("Language not supported in this application: " + lang + " not in Lang.availables()");
            }
            this.lang = lang;
        }

        public void clearTransientLang() {
            this.lang = null;
        }

        public String toString() {
            return "Context attached to (" + this.request() + ")";
        }

        public Context withRequest(Request request) {
            return new Context(this.id, this.header, request, this.session, this.flash, this.args);
        }

        private play.i18n.MessagesApi messagesApi() {
            MessagesApi messagesApi = this.currentApp().injector().instanceOf(MessagesApi.class);
            return new play.i18n.MessagesApi(messagesApi);
        }

        private Application currentApp() {
            return Play.current();
        }

        public static class Implicit {
            public static Response response() {
                return Context.current().response();
            }

            public static Request request() {
                return Context.current().request();
            }

            public static Flash flash() {
                return Context.current().flash();
            }

            public static Session session() {
                return Context.current().session();
            }

            public static Lang lang() {
                return Context.current().lang();
            }

            public static Messages messages() {
                return Context.current().messages();
            }

            public static Context ctx() {
                return Context.current();
            }
        }
    }
}

