/*
 * Decompiled with CFR 0.152.
 */
package play.mvc;

import akka.japi.function.Creator;
import akka.japi.function.Function;
import akka.stream.javadsl.FileIO;
import akka.stream.javadsl.Source;
import akka.stream.javadsl.StreamConverters;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import play.api.libs.MimeTypes;
import play.api.libs.streams.Streams;
import play.http.HttpEntity;
import play.libs.Json;
import play.mvc.Result;
import play.mvc.Results;
import play.utils.UriEncoding;
import scala.Option;
import scala.compat.java8.OptionConverters;

public class StatusHeader
extends Result {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final boolean DEFAULT_INLINE_MODE = true;

    public StatusHeader(int n) {
        super(n);
    }

    public Result sendInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Null stream");
        }
        return new Result(this.status(), HttpEntity.chunked(StreamConverters.fromInputStream((Creator & Serializable)() -> inputStream, (int)8192), Optional.empty()));
    }

    public Result sendInputStream(InputStream inputStream, long l) {
        if (inputStream == null) {
            throw new NullPointerException("Null stream");
        }
        return new Result(this.status(), (HttpEntity)new HttpEntity.Streamed(StreamConverters.fromInputStream((Creator & Serializable)() -> inputStream, (int)8192), Optional.of(l), Optional.empty()));
    }

    public Result sendResource(String string2) {
        return this.sendResource(string2, true);
    }

    public Result sendResource(String string2, ClassLoader classLoader) {
        return this.sendResource(string2, classLoader, true);
    }

    public Result sendResource(String string2, boolean bl) {
        return this.sendResource(string2, this.getClass().getClassLoader(), bl);
    }

    public Result sendResource(String string2, ClassLoader classLoader, boolean bl) {
        return this.doSendResource(StreamConverters.fromInputStream((Creator & Serializable)() -> classLoader.getResourceAsStream(string2)), Optional.empty(), Optional.of(string2), bl);
    }

    public Result sendResource(String string2, boolean bl, String string3) {
        return this.sendResource(string2, this.getClass().getClassLoader(), bl, string3);
    }

    public Result sendResource(String string2, ClassLoader classLoader, boolean bl, String string3) {
        return this.doSendResource(StreamConverters.fromInputStream((Creator & Serializable)() -> classLoader.getResourceAsStream(string2)), Optional.empty(), Optional.of(string3), bl);
    }

    public Result sendPath(Path path) {
        return this.sendPath(path, true);
    }

    public Result sendPath(Path path, boolean bl) {
        return this.sendPath(path, bl, path.getFileName().toString());
    }

    public Result sendPath(Path path, String string2) {
        return this.sendPath(path, true, string2);
    }

    public Result sendPath(Path path, boolean bl, String string2) {
        if (path == null) {
            throw new NullPointerException("null content");
        }
        try {
            return this.doSendResource(FileIO.fromFile((File)path.toFile()), Optional.of(Files.size(path)), Optional.of(string2), bl);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Result sendFile(File file2) {
        return this.sendFile(file2, true);
    }

    public Result sendFile(File file2, boolean bl) {
        if (file2 == null) {
            throw new NullPointerException("null file");
        }
        return this.doSendResource(FileIO.fromFile((File)file2), Optional.of(file2.length()), Optional.of(file2.getName()), bl);
    }

    public Result sendFile(File file2, String string2) {
        return this.sendFile(file2, true, string2);
    }

    public Result sendFile(File file2, boolean bl, String string2) {
        if (file2 == null) {
            throw new NullPointerException("null file");
        }
        return this.doSendResource(FileIO.fromFile((File)file2), Optional.of(file2.length()), Optional.of(string2), bl);
    }

    private Result doSendResource(Source<ByteString, ?> source, Optional<Long> optional, Optional<String> optional2, boolean bl) {
        Map<String, String> map2 = Collections.singletonMap("Content-Disposition", (bl ? "inline" : "attachment") + (optional2.isPresent() ? "; filename=\"" + optional2.get() + "\"; filename*=utf-8''" + UriEncoding.encodePathSegment(optional2.get(), StandardCharsets.UTF_8) : ""));
        return new Result(this.status(), map2, new HttpEntity.Streamed(source, optional, optional2.map(string2 -> OptionConverters.toJava(MimeTypes.forFileName(string2)).orElse("application/octet-stream"))));
    }

    public Result chunked(Source<ByteString, ?> source) {
        return new Result(this.status(), HttpEntity.chunked(source, Optional.empty()));
    }

    public <T> Result chunked(Results.Chunks<T> chunks) {
        return new Result(this.status(), HttpEntity.chunked(Source.fromPublisher((Publisher)Streams.enumeratorToPublisher(chunks.enumerator, (Option)Option.empty())).map((Function & Serializable)object -> (ByteString)chunks.writable.transform().apply(object)), OptionConverters.toJava(chunks.writable.contentType())));
    }

    public Result sendJson(JsonNode jsonNode) {
        return this.sendJson(jsonNode, JsonEncoding.UTF8);
    }

    public Result sendJson(JsonNode jsonNode, String string2) {
        JsonEncoding jsonEncoding2 = Arrays.stream(JsonEncoding.values()).filter(jsonEncoding -> jsonEncoding.getJavaName().equalsIgnoreCase(string2)).findFirst().orElseGet(() -> {
            throw new IllegalArgumentException(string2 + " is not a valid JsonEncoding");
        });
        return this.sendJson(jsonNode, jsonEncoding2);
    }

    public Result sendJson(JsonNode jsonNode, JsonEncoding jsonEncoding) {
        if (jsonNode == null) {
            throw new NullPointerException("Null content");
        }
        ObjectMapper objectMapper = Json.mapper();
        ByteStringBuilder byteStringBuilder = ByteString$.MODULE$.newBuilder();
        try {
            JsonGenerator jsonGenerator = new JsonFactory((ObjectCodec)objectMapper).createGenerator(byteStringBuilder.asOutputStream(), jsonEncoding);
            objectMapper.writeValue(jsonGenerator, (Object)jsonNode);
            String string2 = "application/json; charset=" + jsonEncoding.getJavaName();
            return new Result(this.status(), (HttpEntity)new HttpEntity.Strict(byteStringBuilder.result(), Optional.of(string2)));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public Result sendEntity(HttpEntity httpEntity) {
        return new Result(this.status(), httpEntity);
    }
}

