/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.ClassCache;
import io.apigee.trireme.core.NodeException;
import io.apigee.trireme.core.NodeScript;
import io.apigee.trireme.core.NodeVersion;
import io.apigee.trireme.core.Sandbox;
import io.apigee.trireme.core.internal.RhinoContextFactory;
import io.apigee.trireme.core.internal.RootModuleRegistry;
import io.apigee.trireme.core.internal.SoftClassCache;
import io.apigee.trireme.core.internal.VersionMatcher;
import io.apigee.trireme.core.spi.NodeImplementation;
import io.apigee.trireme.net.spi.HttpServerContainer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.StackStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeEnvironment {
    private static final Logger log = LoggerFactory.getLogger(RootModuleRegistry.class);
    public static final String DEFAULT_NODE_VERSION = "0.10.x";
    public static final int CORE_POOL_SIZE = 50;
    public static final int MAX_POOL_SIZE = 1000;
    public static final int POOL_QUEUE_SIZE = 8;
    public static final long POOL_TIMEOUT_SECS = 60L;
    public static final int DEFAULT_JS_VERSION = 180;
    public static final int DEFAULT_OPT_LEVEL = 9;
    private boolean initialized;
    private final Object initializationLock = new Object();
    private ExecutorService asyncPool;
    private ExecutorService scriptPool;
    private HttpServerContainer httpContainer;
    private Sandbox sandbox;
    private RhinoContextFactory contextFactory;
    private long scriptTimeLimit;
    private ClassCache classCache;
    private int optLevel = 9;
    private final VersionMatcher<RootModuleRegistry> versions = new VersionMatcher();

    public NodeEnvironment() {
        ServiceLoader<NodeImplementation> impls = ServiceLoader.load(NodeImplementation.class);
        for (NodeImplementation impl : impls) {
            if (log.isDebugEnabled()) {
                log.debug("Discovered Node version {}", (Object)impl.getVersion());
            }
            this.versions.add(new NodeVersion<RootModuleRegistry>(impl.getVersion(), new RootModuleRegistry(impl)));
        }
    }

    public NodeEnvironment setSandbox(Sandbox box) {
        this.sandbox = box;
        return this;
    }

    public Sandbox getSandbox() {
        return this.sandbox;
    }

    public void close() {
    }

    public List<String> getNodeVersions() {
        ArrayList<String> a = new ArrayList<String>();
        for (RootModuleRegistry reg : this.versions.getVersions()) {
            a.add(reg.getImplementation().getVersion());
        }
        return a;
    }

    public String getDefaultNodeVersion() {
        RootModuleRegistry reg = this.versions.match(DEFAULT_NODE_VERSION);
        if (reg == null) {
            return null;
        }
        return reg.getImplementation().getVersion();
    }

    public NodeScript createScript(String scriptName, File script, String[] args) throws NodeException {
        this.initialize();
        return new NodeScript(this, scriptName, script, args);
    }

    public NodeScript createScript(String scriptName, String script, String[] args) throws NodeException {
        this.initialize();
        return new NodeScript(this, scriptName, script, args);
    }

    public NodeScript createScript(String[] args, boolean forceRepl) throws NodeException {
        this.initialize();
        return new NodeScript(this, args, forceRepl);
    }

    public NodeEnvironment setHttpContainer(HttpServerContainer container) {
        this.httpContainer = container;
        return this;
    }

    public HttpServerContainer getHttpContainer() {
        return this.httpContainer;
    }

    public int getOptLevel() {
        return this.optLevel;
    }

    public NodeEnvironment setOptLevel(int optLevel) {
        this.optLevel = optLevel;
        return this;
    }

    @Deprecated
    public boolean isSealRoot() {
        return false;
    }

    @Deprecated
    public NodeEnvironment setSealRoot(boolean sealRoot) {
        return this;
    }

    public NodeEnvironment setScriptTimeLimit(long limit, TimeUnit unit) {
        this.scriptTimeLimit = unit.toMillis(limit);
        return this;
    }

    public long getScriptTimeLimit() {
        return this.scriptTimeLimit;
    }

    public void setClassCache(ClassCache cache) {
        this.classCache = cache;
    }

    public void setDefaultClassCache() {
        this.classCache = new SoftClassCache();
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public ExecutorService getAsyncPool() {
        return this.asyncPool;
    }

    public ExecutorService getScriptPool() {
        return this.scriptPool;
    }

    public RootModuleRegistry getRegistry(String version) {
        if (version == null) {
            return this.versions.match(DEFAULT_NODE_VERSION);
        }
        return this.versions.match(version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.initializationLock;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            try {
                RhinoException.setStackStyle((StackStyle)StackStyle.V8);
            }
            catch (Throwable t) {
                log.debug("Running on a version of Rhino without V8-style stack traces");
            }
            if (this.sandbox != null && this.sandbox.getAsyncThreadPool() != null) {
                this.asyncPool = this.sandbox.getAsyncThreadPool();
            }
            if (this.asyncPool == null) {
                ThreadPoolExecutor pool = new ThreadPoolExecutor(50, 1000, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(8), new PoolNameFactory("Trireme Async Pool"), new ThreadPoolExecutor.AbortPolicy());
                pool.allowCoreThreadTimeOut(true);
                this.asyncPool = pool;
            }
            this.scriptPool = Executors.newCachedThreadPool(new PoolNameFactory("Trireme Script Thread"));
            this.contextFactory = new RhinoContextFactory();
            this.contextFactory.setJsVersion(180);
            this.contextFactory.setOptLevel(this.optLevel);
            this.contextFactory.setCountOperations(this.scriptTimeLimit > 0L);
            this.contextFactory.setExtraClassShutter(this.getSandbox() == null ? null : this.getSandbox().getExtraClassShutter());
            this.initialized = true;
        }
    }

    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    private static final class PoolNameFactory
    implements ThreadFactory {
        private final String name;

        PoolNameFactory(String name) {
            this.name = name;
        }

        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, this.name);
            t.setDaemon(true);
            return t;
        }
    }
}

