/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.internal.charsets.Base64Charset;
import io.apigee.trireme.core.internal.charsets.BinaryCharset;
import io.apigee.trireme.core.internal.charsets.HexCharset;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;

public class Charsets {
    public static final String DEFAULT_ENCODING = "utf8";
    public static final Charset UTF8 = Charset.forName("UTF8");
    public static final Charset UCS2 = Charset.forName("UTF-16LE");
    public static final Charset UTF16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF32LE = Charset.forName("UTF-32LE");
    public static final Charset UTF32BE = Charset.forName("UTF-32BE");
    public static final Charset BASE64 = new Base64Charset();
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset NODE_HEX = new HexCharset();
    public static final Charset NODE_BINARY = new BinaryCharset();
    public static final Charset DEFAULT = UTF8;
    private static final Charsets charsets = new Charsets();
    private final HashMap<String, Charset> encodings = new HashMap();

    private Charsets() {
        this.encodings.put("undefined", DEFAULT);
        this.encodings.put(DEFAULT_ENCODING, UTF8);
        this.encodings.put("UTF8", UTF8);
        this.encodings.put("utf-8", UTF8);
        this.encodings.put("UTF-8", UTF8);
        this.encodings.put("utf16le", UCS2);
        this.encodings.put("UTF16LE", UCS2);
        this.encodings.put("utf-16le", UCS2);
        this.encodings.put("UTF-16LE", UCS2);
        this.encodings.put("utf16be", UTF16BE);
        this.encodings.put("UTF16BE", UTF16BE);
        this.encodings.put("utf-16be", UTF16BE);
        this.encodings.put("UTF-16BE", UTF16BE);
        this.encodings.put("utf32be", UTF32BE);
        this.encodings.put("UTF32BE", UTF32BE);
        this.encodings.put("utf-32be", UTF32BE);
        this.encodings.put("UTF-32BE", UTF32BE);
        this.encodings.put("utf32le", UTF32LE);
        this.encodings.put("UTF32LE", UTF32LE);
        this.encodings.put("utf-32le", UTF32LE);
        this.encodings.put("UTF-32LE", UTF32LE);
        this.encodings.put("ucs2", UCS2);
        this.encodings.put("UCS2", UCS2);
        this.encodings.put("ucs-2", UCS2);
        this.encodings.put("UCS-2", UCS2);
        this.encodings.put("ascii", ASCII);
        this.encodings.put("ASCII", ASCII);
        this.encodings.put("binary", NODE_BINARY);
        this.encodings.put("raw", NODE_BINARY);
        this.encodings.put("hex", NODE_HEX);
        this.encodings.put("base64", BASE64);
    }

    public static final Charsets get() {
        return charsets;
    }

    public Charset resolveCharset(String name) {
        if (name == null || name.isEmpty()) {
            return DEFAULT;
        }
        return this.encodings.get(name);
    }

    public Charset getCharset(String name) {
        return this.encodings.get(name);
    }

    public CharsetDecoder getDecoder(Charset cs) {
        CharsetDecoder dec = cs.newDecoder();
        dec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        return dec;
    }

    public CharsetEncoder getEncoder(Charset cs) {
        CharsetEncoder enc = cs.newEncoder();
        if (BASE64.equals(cs)) {
            enc.onUnmappableCharacter(CodingErrorAction.IGNORE);
        } else {
            enc.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return enc;
    }
}

