/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.ClassCache;
import io.apigee.trireme.core.InternalNodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.ScriptRunner;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSStaticFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evals
implements InternalNodeModule {
    protected static final Logger log = LoggerFactory.getLogger(Evals.class);
    public static final String CACHE_KEY_HASH = "SHA-256";
    private static final Object CODE_KEY = "_compiledCode";
    private static final Object FILE_NAME_KEY = "_codeFileName";
    private static final Object SOURCE_KEY = "_sourceCode";
    private static final Pattern BYTECODE_SIZE_MESSAGE = Pattern.compile(".*generated bytecode .+ exceeds 64K limit.*");
    private static final int MAX_COMPILED_SCRIPT_LENGTH = 131072;

    public String getModuleName() {
        return "evals";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Scriptable export = cx.newObject(scope);
        export.setPrototype(scope);
        export.setParentScope(null);
        ScriptableObject.defineClass((Scriptable)export, NodeScriptImpl.class);
        return export;
    }

    public static class NodeScriptImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "NodeScript";

        public String getClassName() {
            return CLASS_NAME;
        }

        @JSStaticFunction
        public static Object runInThisContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String code = ArgUtils.stringArg(args, 0);
            String fileName = ArgUtils.stringArg(args, 1);
            if (log.isDebugEnabled()) {
                log.debug("Running code from {} in this context of {}", (Object)fileName, (Object)thisObj);
            }
            return NodeScriptImpl.runScript(cx, thisObj, code, fileName);
        }

        @JSStaticFunction
        public static Object runInNewContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String code = ArgUtils.stringArg(args, 0);
            Scriptable sandbox = ArgUtils.objArg(args, 1, Scriptable.class, true);
            String fileName = ArgUtils.stringArg(args, 2);
            if (log.isDebugEnabled()) {
                log.debug("Running code from {} in new context of {}", (Object)fileName, (Object)sandbox);
            }
            return NodeScriptImpl.runScript(cx, sandbox, code, fileName);
        }

        @JSStaticFunction
        public static Object compile(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String code = ArgUtils.stringArg(args, 0);
            String fileName = ArgUtils.stringArg(args, 1);
            if (log.isDebugEnabled()) {
                log.debug("Compiling code from {}", (Object)fileName);
            }
            ScriptableObject ret = (ScriptableObject)cx.newObject(thisObj);
            ret.associateValue(FILE_NAME_KEY, (Object)fileName);
            Script compiled = NodeScriptImpl.getCompiledScript(cx, code, fileName);
            if (compiled == null) {
                ret.associateValue(SOURCE_KEY, (Object)code);
            } else {
                ret.associateValue(CODE_KEY, (Object)compiled);
            }
            return ret;
        }

        @JSStaticFunction
        public static Object run(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Scriptable context = ArgUtils.objArg(args, 0, Scriptable.class, true);
            ScriptableObject compiled = ArgUtils.objArg(args, 1, ScriptableObject.class, true);
            String fileName = (String)compiled.getAssociatedValue(FILE_NAME_KEY);
            if (fileName == null) {
                throw Utils.makeError(cx, thisObj, "Invalid compiled script argument");
            }
            Script compiledScript = (Script)compiled.getAssociatedValue(CODE_KEY);
            if (compiledScript == null) {
                String scriptSource = (String)compiled.getAssociatedValue(SOURCE_KEY);
                if (scriptSource == null) {
                    throw Utils.makeError(cx, thisObj, "Invalid compiled script argument");
                }
                return NodeScriptImpl.interpretScript(cx, context, scriptSource, fileName);
            }
            return compiledScript.exec(cx, context);
        }

        @JSStaticFunction
        public static Object createContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptRunner runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            Scriptable ctx = cx.newObject(runner.getScriptScope());
            ctx.setPrototype(NodeScriptImpl.getTopLevelScope((Scriptable)runner.getScriptScope()));
            ctx.setParentScope(null);
            return ctx;
        }

        @JSStaticFunction
        public static Object getGlobalContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ScriptRunner runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            return runner.getScriptScope();
        }

        private static Object runScript(Context cx, Scriptable scope, String code, String fileName) {
            Script compiled = NodeScriptImpl.getCompiledScript(cx, code, fileName);
            if (compiled == null) {
                return NodeScriptImpl.interpretScript(cx, scope, code, fileName);
            }
            return compiled.exec(cx, scope);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object interpretScript(Context cx, Scriptable scope, String code, String fileName) {
            if (log.isDebugEnabled()) {
                log.debug("Executing script from {} in interpreted mode because it was too large", (Object)fileName);
            }
            int oldOpt = cx.getOptimizationLevel();
            try {
                cx.setOptimizationLevel(-1);
                Object object = cx.evaluateString(scope, code, fileName, 1, null);
                return object;
            }
            finally {
                cx.setOptimizationLevel(oldOpt);
            }
        }

        private static Script getCompiledScript(Context cx, String code, String fileName) {
            ScriptRunner runner = (ScriptRunner)cx.getThreadLocal((Object)"runner");
            ClassCache cache = runner.getEnvironment().getClassCache();
            if (cache == null) {
                return NodeScriptImpl.compileScript(cx, code, fileName);
            }
            String cacheKey = NodeScriptImpl.makeCacheKey(code);
            Script compiled = cache.getCachedScript(cacheKey);
            if (compiled == null && (compiled = NodeScriptImpl.compileScript(cx, code, fileName)) != null) {
                cache.putCachedScript(cacheKey, compiled);
            }
            return compiled;
        }

        private static Script compileScript(Context cx, String code, String fileName) {
            if (code.length() > 131072) {
                return null;
            }
            try {
                return cx.compileString(code, fileName, 1, null);
            }
            catch (EvaluatorException ee) {
                if (BYTECODE_SIZE_MESSAGE.matcher(ee.getMessage()).matches()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Source code for {} is too large -- running later in interpreted mode", (Object)fileName);
                    }
                    return null;
                }
                throw ee;
            }
            catch (IllegalArgumentException ie) {
                if (log.isDebugEnabled()) {
                    log.debug("Source code for {} failed compilation, possibly too large", (Object)fileName);
                }
                return null;
            }
        }

        private static String makeCacheKey(String code) {
            try {
                MessageDigest md = MessageDigest.getInstance(Evals.CACHE_KEY_HASH);
                ByteBuffer codeBuf = Utils.stringToBuffer(code, Charsets.UTF8);
                md.update(codeBuf);
                ByteBuffer keyBuf = ByteBuffer.wrap(md.digest());
                return Utils.bufferToString(keyBuf, Charsets.BASE64);
            }
            catch (NoSuchAlgorithmException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Can't calculate cache key for source code: " + e);
                }
                return null;
            }
        }
    }
}

