/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.NodeExitException;
import io.apigee.trireme.core.internal.Platform;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.internal.Version;
import io.apigee.trireme.core.internal.handles.AbstractHandle;
import io.apigee.trireme.core.internal.handles.ConsoleHandle;
import io.apigee.trireme.core.internal.handles.JavaInputStreamHandle;
import io.apigee.trireme.core.internal.handles.JavaOutputStreamHandle;
import io.apigee.trireme.core.modules.ProcessWrap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Process
implements NodeModule {
    protected static final String OBJECT_NAME = "process";
    public static final String MODULE_NAME = "process";
    public static final String EXECUTABLE_NAME = "./node";
    public static final int DEFAULT_UMASK = 18;
    private static final long NANO = 1000000000L;
    protected static final Logger log = LoggerFactory.getLogger(Process.class);
    private static final Pattern FILE_NAME_PATTERN = Pattern.compile("^((.*[/\\\\])|([^/\\\\]*))(.+)\\.node$");

    public String getModuleName() {
        return "process";
    }

    public Scriptable registerExports(Context cx, Scriptable scope, NodeRuntime runner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        ScriptableObject.defineClass((Scriptable)scope, ProcessImpl.class, (boolean)false, (boolean)true);
        ScriptableObject.defineClass((Scriptable)scope, EnvImpl.class, (boolean)false, (boolean)true);
        ProcessImpl exports = (ProcessImpl)cx.newObject(scope, "_processClass");
        exports.setRunner(cx, runner);
        EnvImpl env = (EnvImpl)cx.newObject(scope, "_Environment");
        env.initialize(runner.getScriptObject().getEnvironment());
        exports.setEnv(env);
        scope.put("process", scope, (Object)exports);
        return exports;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnvImpl
    extends ScriptableObject {
        public static final String CLASS_NAME = "_Environment";
        private final HashMap<String, Object> env = new HashMap();
        private final HashMap<String, Object> aliases = new HashMap();

        public String getClassName() {
            return CLASS_NAME;
        }

        public Object[] getIds() {
            return this.env.keySet().toArray();
        }

        public Object get(String name, Scriptable scope) {
            Object ret = this.env.get(name);
            if (ret == null) {
                ret = this.aliases.get(name.toUpperCase());
            }
            return ret == null ? Scriptable.NOT_FOUND : ret;
        }

        public boolean has(String name, Scriptable scope) {
            return this.env.containsKey(name) || this.aliases.containsKey(name.toUpperCase());
        }

        public void put(String name, Scriptable scope, Object value) {
            this.env.put(name, value);
            String uc = name.toUpperCase();
            if (!uc.equals(name)) {
                this.aliases.put(uc, value);
            }
        }

        public void delete(String name) {
            this.env.remove(name);
            String uc = name.toUpperCase();
            if (!uc.equals(name)) {
                this.aliases.remove(uc);
            }
        }

        void initialize(Map<String, String> e) {
            for (Map.Entry<String, String> entry : e.entrySet()) {
                this.put(entry.getKey(), null, entry.getValue());
            }
        }
    }

    public static class ProcessImpl
    extends ScriptableObject {
        protected static final String CLASS_NAME = "_processClass";
        private Scriptable argv;
        private Scriptable env;
        private long startTime;
        private ScriptRunner runner;
        private Function submitTick;
        private boolean needTickCallback;
        private Function tickSpinnerCallback;
        private Function tickCallback;
        private boolean needImmediateCallback;
        private Function immediateCallback;
        private Function fatalException;
        private Function emit;
        private Object domain;
        private boolean exiting;
        private int umask = 18;
        private boolean throwDeprecation;
        private boolean traceDeprecation;
        private String eval;
        private boolean printEval;
        private boolean forceRepl;
        private boolean connected;
        private Scriptable tickInfoBox;

        @JSConstructor
        public static Object ProcessImpl(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
            ProcessImpl ret = new ProcessImpl();
            ret.startTime = System.currentTimeMillis();
            ret.tickInfoBox = cx.newArray((Scriptable)ret, 3);
            return ret;
        }

        public String getClassName() {
            return CLASS_NAME;
        }

        public void setRunner(Context cx, NodeRuntime runner) {
            this.runner = (ScriptRunner)runner;
        }

        @JSGetter(value="_eval")
        public String getEval() {
            return this.eval;
        }

        @JSSetter(value="_eval")
        public void setEval(String eval) {
            this.eval = eval;
        }

        @JSGetter(value="_print_eval")
        public boolean isPrintEval() {
            return this.printEval;
        }

        @JSSetter(value="_print_eval")
        public void setPrintEval(boolean eval) {
            this.printEval = eval;
        }

        @JSGetter(value="_forceRepl")
        public boolean isForceRepl() {
            return this.forceRepl;
        }

        @JSSetter(value="_forceRepl")
        public void setForceRepl(boolean force) {
            this.forceRepl = force;
        }

        @JSGetter(value="_tickInfoBox")
        public Object getTickInfoBox() {
            return this.tickInfoBox;
        }

        @JSGetter(value="connected")
        public boolean isConnected() {
            return this.connected;
        }

        @JSSetter(value="connected")
        public void setConnected(boolean c) {
            this.connected = c;
        }

        @JSGetter(value="_childProcess")
        public boolean isChildProcess() {
            return this.runner.getScriptObject()._isChildProcess();
        }

        @JSSetter(value="_childProcess")
        public void setChildProcess(boolean child) {
            this.runner.getScriptObject()._setChildProcess(child);
        }

        @JSFunction
        public static Object binding(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String name = ArgUtils.stringArg(args, 0);
            ProcessImpl proc = (ProcessImpl)thisObj;
            return proc.getInternalModule(name, cx);
        }

        public Object getInternalModule(String name, Context cx) {
            Object mod = this.runner.getCachedInternalModule(name);
            if (mod == null) {
                try {
                    mod = this.runner.initializeModule(name, AbstractModuleRegistry.ModuleType.INTERNAL, cx, this.runner.getScriptScope());
                    if (log.isTraceEnabled()) {
                        log.trace("Creating new instance {} of internal module {}", (Object)System.identityHashCode(mod), (Object)name);
                    }
                    if (mod == null && ("buffer".equals(name) || "native_module".equals(name))) {
                        return this.runner.require(name, cx);
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    throw new EvaluatorException("Error initializing module: " + (targetException != null ? e.toString() + ": " + targetException.toString() : e.toString()));
                }
                catch (InstantiationException e) {
                    throw new EvaluatorException("Error initializing module: " + e.toString());
                }
                catch (IllegalAccessException e) {
                    throw new EvaluatorException("Error initializing module: " + e.toString());
                }
                this.runner.cacheInternalModule(name, mod);
            } else if (log.isTraceEnabled()) {
                log.trace("Returning cached copy {} of internal module {}", (Object)System.identityHashCode(mod), (Object)name);
            }
            return mod;
        }

        @JSFunction
        public static void dlopen(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Scriptable module = ArgUtils.objArg(args, 0, Scriptable.class, true);
            String fileName = ArgUtils.stringArg(args, 1);
            ScriptRunner runner = ProcessImpl.getRunner(cx);
            Matcher m = FILE_NAME_PATTERN.matcher(fileName);
            if (!m.matches()) {
                throw Utils.makeError(cx, thisObj, "dlopen(" + fileName + "): Native module not supported");
            }
            String name = m.group(4);
            try {
                Object nativeMod = runner.initializeModule(name, AbstractModuleRegistry.ModuleType.NATIVE, cx, runner.getScriptScope());
                if (log.isTraceEnabled()) {
                    log.trace("Creating new instance {} of native module {}", (Object)System.identityHashCode(nativeMod), (Object)name);
                }
                if (nativeMod == null) {
                    throw Utils.makeError(cx, thisObj, "dlopen(" + fileName + "): Native module not supported");
                }
                module.put("exports", module, nativeMod);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                throw new EvaluatorException("Error initializing module: " + (targetException != null ? e.toString() + ": " + targetException.toString() : e.toString()));
            }
            catch (InstantiationException e) {
                throw new EvaluatorException("Error initializing module: " + e.toString());
            }
            catch (IllegalAccessException e) {
                throw new EvaluatorException("Error initializing module: " + e.toString());
            }
        }

        private Scriptable createStreamHandle(Context cx, AbstractHandle handle) {
            Scriptable module = (Scriptable)this.runner.requireInternal("java_stream_wrap", cx);
            return cx.newObject(module, "JavaStream", new Object[]{handle});
        }

        private Scriptable createConsoleHandle(Context cx, AbstractHandle handle) {
            Scriptable module = (Scriptable)this.runner.requireInternal("console_wrap", cx);
            return cx.newObject(module, "Console", new Object[]{handle});
        }

        @JSGetter(value="_stdoutHandle")
        public Object getStdoutHandle() {
            Context cx = Context.getCurrentContext();
            if (this.runner.getStdout() == System.out && ConsoleHandle.isConsoleSupported()) {
                ConsoleHandle streamHandle = new ConsoleHandle(this.runner);
                return this.createConsoleHandle(cx, streamHandle);
            }
            JavaOutputStreamHandle streamHandle = new JavaOutputStreamHandle(this.runner.getStdout());
            return this.createStreamHandle(cx, streamHandle);
        }

        @JSGetter(value="_stderrHandle")
        public Object getStderrHandle() {
            Context cx = Context.getCurrentContext();
            JavaOutputStreamHandle streamHandle = new JavaOutputStreamHandle(this.runner.getStderr());
            return this.createStreamHandle(cx, streamHandle);
        }

        @JSGetter(value="_stdinHandle")
        public Object getStdinHandle() {
            Context cx = Context.getCurrentContext();
            if (this.runner.getStdin() == System.in && ConsoleHandle.isConsoleSupported()) {
                ConsoleHandle streamHandle = new ConsoleHandle(this.runner);
                return this.createConsoleHandle(cx, streamHandle);
            }
            JavaInputStreamHandle streamHandle = new JavaInputStreamHandle(this.runner.getStdin(), this.runner);
            return this.createStreamHandle(cx, streamHandle);
        }

        @JSGetter(value="argv")
        public Object getArgv() {
            return this.argv;
        }

        @JSSetter(value="argv")
        public void setArgv(Scriptable argv) {
            this.argv = argv;
        }

        public void initializeArgv(String[] args) {
            Object[] argvArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                argvArgs[i] = args[i];
            }
            this.argv = Context.getCurrentContext().newArray((Scriptable)this, argvArgs);
        }

        @JSGetter(value="execArgv")
        public Object getExecArgv() {
            return Context.getCurrentContext().newArray((Scriptable)this, 0);
        }

        public void setEnv(EnvImpl env) {
            this.env = env;
        }

        @JSGetter(value="execPath")
        public String getExecPath() {
            return Process.EXECUTABLE_NAME;
        }

        @JSFunction
        public void abort() throws NodeExitException {
            throw new NodeExitException(NodeExitException.Reason.FATAL);
        }

        @JSFunction
        public static void chdir(Context cx, Scriptable thisObj, Object[] args, Function func) {
            String cd = ArgUtils.stringArg(args, 0);
            ProcessImpl self = (ProcessImpl)thisObj;
            try {
                self.runner.setWorkingDirectory(cd);
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, (Scriptable)self, ioe.toString());
            }
        }

        @JSFunction
        public String cwd() {
            return this.runner.getWorkingDirectory();
        }

        @JSGetter(value="env")
        public Scriptable getEnv() {
            return this.env;
        }

        @JSFunction
        public static void reallyExit(Context cx, Scriptable thisObj, Object[] args, Function func) throws NodeExitException {
            ProcessImpl self = (ProcessImpl)thisObj;
            if (args.length >= 1) {
                int code = (Integer)Context.jsToJava((Object)args[0], Integer.class);
                throw new NodeExitException(NodeExitException.Reason.NORMAL, code);
            }
            throw new NodeExitException(NodeExitException.Reason.NORMAL, 0);
        }

        @JSGetter(value="version")
        public String getVersion() {
            return "v" + this.runner.getRegistry().getImplementation().getVersion();
        }

        @JSGetter(value="versions")
        public Object getVersions() {
            Scriptable env = Context.getCurrentContext().newObject((Scriptable)this);
            env.put("trireme", env, (Object)Version.TRIREME_VERSION);
            env.put("node", env, (Object)this.runner.getRegistry().getImplementation().getVersion());
            if (Version.SSL_VERSION != null) {
                env.put("ssl", env, (Object)Version.SSL_VERSION);
            }
            env.put("java", env, (Object)System.getProperty("java.version"));
            return env;
        }

        @JSGetter(value="config")
        public Scriptable getConfig() {
            Scriptable c = Context.getCurrentContext().newObject((Scriptable)this);
            Scriptable vars = Context.getCurrentContext().newObject((Scriptable)this);
            c.put("variables", c, (Object)vars);
            return c;
        }

        @JSGetter(value="title")
        public String getTitle() {
            return "trireme";
        }

        @JSSetter(value="title")
        public void setTitle(String title) {
        }

        @JSGetter(value="arch")
        public String getArch() {
            String arch = System.getProperty("os.arch");
            if (arch.equals("x86")) {
                return "ia32";
            }
            if (arch.equals("x86_64")) {
                return "x64";
            }
            return arch;
        }

        @JSFunction
        public static void _kill(Context cx, Scriptable thisObj, Object[] args, Function func) {
            int pid = ArgUtils.intArg(args, 0);
            String signal = ArgUtils.stringArg(args, 1, "TERM");
            if ("0".equals(signal)) {
                signal = null;
            }
            ProcessWrap.kill(cx, thisObj, pid, signal);
        }

        @JSGetter(value="pid")
        public int getPid() {
            return System.identityHashCode(this.runner) % 65536;
        }

        @JSFunction
        public static void send(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Object message = ArgUtils.objArg(args, 0, Object.class, true);
            ProcessImpl self = (ProcessImpl)thisObj;
            if (!self.connected) {
                throw Utils.makeError(cx, thisObj, "IPC to the parent is disconnected");
            }
            if (self.runner.getParentProcess() == null) {
                throw Utils.makeError(cx, thisObj, "IPC is not enabled back to the parent");
            }
            ProcessWrap.ProcessImpl childObj = self.runner.getParentProcess();
            childObj.getRuntime().enqueueIpc(cx, message, childObj);
        }

        @JSFunction
        public static void disconnect(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ProcessImpl self = (ProcessImpl)thisObj;
            if (self.runner.getParentProcess() == null) {
                throw Utils.makeError(cx, thisObj, "IPC is not enabled back to the parent");
            }
            ProcessWrap.ProcessImpl childObj = self.runner.getParentProcess();
            self.emit.call(cx, (Scriptable)self.emit, thisObj, new Object[]{"disconnected"});
            self.connected = false;
            childObj.getRuntime().enqueueIpc(cx, ProcessWrap.IPC_DISCONNECT, childObj);
        }

        @JSGetter(value="_errno")
        public Object getErrno() {
            return this.runner.getErrno();
        }

        @JSGetter(value="platform")
        public String getPlatform() {
            if (this.runner.getSandbox() != null && this.runner.getSandbox().isHideOSDetails()) {
                return "java";
            }
            return Platform.get().getPlatform();
        }

        @JSFunction
        public static Object memoryUsage(Context cx, Scriptable thisObj, Object[] args, Function func) {
            Runtime r = Runtime.getRuntime();
            Scriptable mem = cx.newObject(thisObj);
            mem.put("rss", mem, (Object)r.totalMemory());
            mem.put("heapTotal", mem, (Object)r.maxMemory());
            mem.put("heapUsed", mem, (Object)r.totalMemory());
            return mem;
        }

        public void fireExit(Context cx, int code) {
            this.emit.call(cx, (Scriptable)this.emit, (Scriptable)this, new Object[]{"exit", code});
        }

        @JSSetter(value="_submitTick")
        public void setSubmitTick(Function submit) {
            this.submitTick = submit;
        }

        @JSGetter(value="_submitTick")
        public Function getSubmitTick() {
            return this.submitTick;
        }

        @JSFunction(value="_pin")
        public void pin() {
            this.runner.pin();
        }

        @JSFunction(value="_unpin")
        public void unPin() {
            this.runner.unPin();
        }

        @JSFunction
        public static void _needTickCallback(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ProcessImpl self = (ProcessImpl)thisObj;
            self.needTickCallback = true;
        }

        public void callTickFromSpinner(Context cx) {
            this.needTickCallback = false;
            this.tickSpinnerCallback.call(cx, (Scriptable)this.tickSpinnerCallback, (Scriptable)this, ScriptRuntime.emptyArgs);
        }

        public boolean isNeedTickCallback() {
            return this.needTickCallback;
        }

        @JSSetter(value="emit")
        public void setEmit(Function f) {
            this.emit = f;
        }

        @JSGetter(value="emit")
        public Function getEmit() {
            return this.emit;
        }

        @JSSetter(value="_tickCallback")
        public void setTickCallback(Function f) {
            this.tickCallback = f;
        }

        @JSGetter(value="_tickCallback")
        public Function getTickCallback() {
            return this.tickCallback;
        }

        @JSSetter(value="_tickFromSpinner")
        public void setTickSpinnerCallback(Function f) {
            this.tickSpinnerCallback = f;
        }

        @JSGetter(value="_tickFromSpinner")
        public Function getTickSpinnerCallback() {
            return this.tickSpinnerCallback;
        }

        @JSSetter(value="_needImmediateCallback")
        public void setNeedImmediateCallback(boolean n) {
            this.needImmediateCallback = n;
        }

        @JSGetter(value="_needImmediateCallback")
        public boolean isNeedImmediateCallback() {
            return this.needImmediateCallback;
        }

        @JSSetter(value="_immediateCallback")
        public void setImmediateCallback(Function f) {
            this.immediateCallback = f;
        }

        @JSGetter(value="_immediateCallback")
        public Function getImmediateCallback() {
            return this.immediateCallback;
        }

        public boolean isCallbacksRequired() {
            return this.needImmediateCallback || this.needTickCallback;
        }

        public void callImmediateTasks(Context cx) {
            if (log.isTraceEnabled()) {
                log.trace("Calling immediate timer tasks");
            }
            this.immediateCallback.call(cx, (Scriptable)this.immediateCallback, (Scriptable)this, ScriptRuntime.emptyArgs);
            if (log.isTraceEnabled()) {
                log.trace("Immediate tasks done. needImmediateCallback = {}", (Object)this.needImmediateCallback);
            }
        }

        @JSGetter(value="_fatalException")
        public Function getFatalException() {
            return this.fatalException;
        }

        @JSSetter(value="_fatalException")
        public void setFatalException(Function f) {
            this.fatalException = f;
        }

        @JSFunction
        public static Object umask(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ProcessImpl self = (ProcessImpl)thisObj;
            if (args.length > 0) {
                int newMask;
                int oldMask = self.umask;
                self.umask = newMask = ArgUtils.octalOrHexIntArg(args, 0);
                return Context.toNumber((Object)oldMask);
            }
            return Context.toNumber((Object)self.umask);
        }

        public int getUmask() {
            return this.umask;
        }

        @JSFunction
        public static Object uptime(Context cx, Scriptable thisObj, Object[] args, Function func) {
            ProcessImpl self = (ProcessImpl)thisObj;
            long up = (System.currentTimeMillis() - self.startTime) / 1000L;
            return Context.javaToJS((Object)up, (Scriptable)thisObj);
        }

        @JSFunction
        public static Object hrtime(Context cx, Scriptable thisObj, Object[] args, Function func) {
            long nanos = System.nanoTime();
            if (args.length == 1) {
                Scriptable arg = ProcessImpl.ensureScriptable((Object)args[0]);
                if (!arg.has(0, arg) || !arg.has(1, arg)) {
                    throw new EvaluatorException("Argument must be an array");
                }
                long startSecs = (long)Context.toNumber((Object)arg.get(0, arg));
                long startNs = (long)Context.toNumber((Object)arg.get(1, arg));
                long startNanos = startSecs * 1000000000L + startNs;
                nanos -= startNanos;
            } else if (args.length > 1) {
                throw new EvaluatorException("Invalid arguments");
            }
            Object[] ret = new Object[]{(int)(nanos / 1000000000L), (int)(nanos % 1000000000L)};
            return cx.newArray(thisObj, ret);
        }

        @JSGetter(value="features")
        public Object getFeatures() {
            Scriptable features = Context.getCurrentContext().newObject((Scriptable)this);
            return features;
        }

        @JSGetter(value="domain")
        public Object getDomain() {
            return this.domain;
        }

        @JSSetter(value="domain")
        public void setDomain(Object d) {
            this.domain = d;
        }

        @JSGetter(value="_exiting")
        public boolean isExiting() {
            return this.exiting;
        }

        @JSSetter(value="_exiting")
        public void setExiting(boolean e) {
            this.exiting = e;
        }

        @JSSetter(value="throwDeprecation")
        public void setThrowDeprecation(boolean d) {
            this.throwDeprecation = d;
        }

        @JSGetter(value="throwDeprecation")
        public boolean isThrowDeprecation() {
            return this.throwDeprecation;
        }

        @JSSetter(value="traceDeprecation")
        public void setTraceDeprecation(boolean d) {
            this.traceDeprecation = d;
        }

        @JSGetter(value="traceDeprecation")
        public boolean isTraceDeprecation() {
            return this.traceDeprecation;
        }

        private static ScriptRunner getRunner(Context cx) {
            return (ScriptRunner)cx.getThreadLocal((Object)"runner");
        }
    }
}

