/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.modules.crypto;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.Charsets;
import io.apigee.trireme.core.internal.CompositeTrustManager;
import io.apigee.trireme.core.internal.CryptoException;
import io.apigee.trireme.core.internal.SSLCiphers;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.Crypto;
import io.apigee.trireme.core.modules.crypto.DefaultTrustStore;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureContextImpl
extends ScriptableObject {
    private static final Logger log = LoggerFactory.getLogger((String)SecureContextImpl.class.getName());
    public static final String CLASS_NAME = "SecureContext";
    private static final String DEFAULT_PROTO = "TLS";
    private static final Pattern COLON = Pattern.compile(":");
    private static final String DEFAULT_KEY_ENTRY = "key";
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private X509TrustManager trustedCertManager;
    private X509Certificate[] certChain;
    private PrivateKey privateKey;
    private KeyStore trustedCertStore;
    private int trustedCertSequence = 0;
    private List<X509CRL> crls;
    private String protocol;
    private String mainProtocol;
    private String[] cipherSuites;
    private boolean initialized;

    public String getClassName() {
        return CLASS_NAME;
    }

    @JSFunction
    public static void init(Context cx, Scriptable thisObj, Object[] args, Function func) {
        SecureContextImpl self = (SecureContextImpl)thisObj;
        String protocol = ArgUtils.stringArg(args, 0, null);
        if ("SSLv2_client_method".equals(protocol)) {
            self.protocol = "SSLv2";
            self.mainProtocol = "SSL";
        } else if ("SSLv2_server_method".equals(protocol)) {
            self.protocol = "SSLv2";
            self.mainProtocol = "SSL";
        } else if ("SSLv2_method".equals(protocol)) {
            self.protocol = "SSLv2";
            self.mainProtocol = "SSL";
        } else if ("SSLv3_client_method".equals(protocol)) {
            self.protocol = "SSLv3";
            self.mainProtocol = "SSL";
        } else if ("SSLv3_server_method".equals(protocol)) {
            self.protocol = "SSLv3";
            self.mainProtocol = "SSL";
        } else if ("SSLv3_method".equals(protocol)) {
            self.protocol = "SSLv3";
            self.mainProtocol = "SSL";
        } else if ("TLSv1_client_method".equals(protocol)) {
            self.protocol = "TLSv1";
            self.mainProtocol = DEFAULT_PROTO;
        } else if ("TLSv1_server_method".equals(protocol)) {
            self.protocol = "TLSv1";
            self.mainProtocol = DEFAULT_PROTO;
        } else if ("TLSv1_method".equals(protocol)) {
            self.protocol = "TLSv1";
            self.mainProtocol = DEFAULT_PROTO;
        } else if (protocol == null) {
            self.protocol = DEFAULT_PROTO;
            self.mainProtocol = DEFAULT_PROTO;
        } else {
            self.protocol = protocol;
            self.mainProtocol = DEFAULT_PROTO;
        }
        try {
            SSLContext.getInstance(self.protocol);
            if (log.isDebugEnabled()) {
                log.debug("Creating secure context for {}", (Object)self.protocol);
            }
        }
        catch (NoSuchAlgorithmException nse) {
            throw Utils.makeError(cx, thisObj, "Unsupported TLS/SSL protocol " + protocol);
        }
    }

    @JSFunction
    public static void close(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void setKey(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Crypto.ensureCryptoService(cx, thisObj);
        String key = ArgUtils.stringArg(args, 0);
        String p = ArgUtils.stringArg(args, 1, null);
        char[] passphrase = p == null ? null : p.toCharArray();
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        try {
            KeyPair kp = Crypto.getCryptoService().readKeyPair("RSA", key, passphrase);
            self.privateKey = kp.getPrivate();
            log.debug("Set private key from an RSA key pair");
        }
        catch (CryptoException ce) {
            throw Utils.makeError(cx, thisObj, ce.toString());
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, thisObj, ioe.toString());
        }
        finally {
            if (passphrase != null) {
                Arrays.fill(passphrase, '\u0000');
            }
        }
    }

    @JSFunction
    public static void setCert(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Crypto.ensureCryptoService(cx, thisObj);
        String certStr = ArgUtils.stringArg(args, 0);
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certStr.getBytes(Charsets.ASCII));
            X509Certificate cert = Crypto.getCryptoService().readCertificate(bis);
            if (log.isDebugEnabled()) {
                log.debug("Set my certificate to: {}", (Object)cert.getSubjectDN());
            }
            self.certChain = new X509Certificate[]{cert};
        }
        catch (CryptoException ce) {
            throw Utils.makeError(cx, thisObj, ce.toString());
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, thisObj, ioe.toString());
        }
    }

    private void ensureCertStore() throws GeneralSecurityException, IOException {
        if (this.trustedCertStore == null) {
            this.trustedCertStore = Crypto.getCryptoService().createPemKeyStore();
            this.trustedCertStore.load(null, null);
        }
    }

    @JSFunction
    public static void addCACert(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Crypto.ensureCryptoService(cx, thisObj);
        String certStr = ArgUtils.stringArg(args, 0);
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        try {
            self.ensureCertStore();
            ByteArrayInputStream bis = new ByteArrayInputStream(certStr.getBytes(Charsets.ASCII));
            X509Certificate cert = Crypto.getCryptoService().readCertificate(bis);
            if (log.isDebugEnabled()) {
                log.debug("Adding trusted CA cert {}");
            }
            self.trustedCertStore.setCertificateEntry("Cert " + self.trustedCertSequence, cert);
            ++self.trustedCertSequence;
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, thisObj, gse.toString());
        }
        catch (CryptoException ce) {
            throw Utils.makeError(cx, thisObj, ce.toString());
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, thisObj, ioe.toString());
        }
    }

    @JSFunction
    public static void addCRL(Context cx, Scriptable thisObj, Object[] args, Function func) {
        String crlStr = ArgUtils.stringArg(args, 0);
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        ByteArrayInputStream bis = new ByteArrayInputStream(crlStr.getBytes(Charsets.ASCII));
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509CRL crl = (X509CRL)certFactory.generateCRL(bis);
            if (self.crls == null) {
                self.crls = new ArrayList<X509CRL>();
            }
            self.crls.add(crl);
            log.debug("Added CRL");
        }
        catch (CertificateException e) {
            throw Utils.makeError(cx, thisObj, "Error reading CRL: " + e);
        }
        catch (CRLException e) {
            throw Utils.makeError(cx, thisObj, "Error reading CRL: " + e);
        }
    }

    @JSFunction
    public static void addRootCerts(Context cx, Scriptable thisObj, Object[] args, Function func) {
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        self.trustManagers = DefaultTrustStore.get().getTrustManagers();
        if (self.trustManagers == null) {
            throw Utils.makeError(cx, thisObj, "Cannot load default root CA certificates");
        }
        log.debug("Will be using default root certificates");
    }

    @JSFunction
    public static void setCiphers(Context cx, Scriptable thisObj, Object[] args, Function func) {
        String cipherList = ArgUtils.stringArg(args, 0);
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        ArrayList<String> finalList = new ArrayList<String>();
        for (String cipher : COLON.split(cipherList)) {
            SSLCiphers.Ciph c = SSLCiphers.get().getSslCipher(self.mainProtocol, cipher);
            if (c == null) {
                finalList.add(cipher);
                continue;
            }
            finalList.add(c.getJavaName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Enabling cipher suites", finalList);
        }
        self.cipherSuites = finalList.toArray(new String[finalList.size()]);
    }

    @JSFunction
    public static void setOptions(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void setSessionIdContext(Context cx, Scriptable thisObj, Object[] args, Function func) {
    }

    @JSFunction
    public static void loadPKCS12(Context cx, Scriptable thisObj, Object[] args, Function func) {
        Buffer.BufferImpl pfxBuf = ArgUtils.objArg(args, 0, Buffer.BufferImpl.class, true);
        String p = ArgUtils.stringArg(args, 1, null);
        char[] passphrase = p == null ? null : p.toCharArray();
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(pfxBuf.getArray(), pfxBuf.getArrayOffset(), pfxBuf.getLength());
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(bis, passphrase);
            KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyFactory.init(keyStore, passphrase);
            self.keyManagers = keyFactory.getKeyManagers();
            log.debug("Loaded SSL key from PKCS12");
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, thisObj, "Error opening key store: " + gse);
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, thisObj, "I/O error reading key store: " + ioe);
        }
        finally {
            if (passphrase != null) {
                Arrays.fill(passphrase, '\u0000');
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public static void setTrustStore(Context cx, Scriptable thisObj, Object[] args, Function func) {
        String name = ArgUtils.stringArg(args, 0);
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        ScriptRunner runtime = (ScriptRunner)cx.getThreadLocal((Object)"runner");
        try {
            FileInputStream keyIn = new FileInputStream(runtime.translatePath(name));
            try {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(keyIn, null);
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustFactory.init(trustStore);
                self.trustManagers = trustFactory.getTrustManagers();
            }
            finally {
                keyIn.close();
            }
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, (Scriptable)self, "Error opening key store: " + gse);
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, (Scriptable)self, "I/O error reading key store: " + ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JSFunction
    public static void setKeyStore(Context cx, Scriptable thisObj, Object[] args, Function func) {
        String name = ArgUtils.stringArg(args, 0);
        String p = ArgUtils.stringArg(args, 1);
        SecureContextImpl self = (SecureContextImpl)thisObj;
        self.initialized = false;
        ScriptRunner runtime = (ScriptRunner)cx.getThreadLocal((Object)"runner");
        char[] passphrase = p.toCharArray();
        try {
            FileInputStream keyIn = new FileInputStream(runtime.translatePath(name));
            try {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(keyIn, passphrase);
                KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyFactory.init(keyStore, passphrase);
                self.keyManagers = keyFactory.getKeyManagers();
            }
            finally {
                keyIn.close();
                keyIn.close();
            }
        }
        catch (GeneralSecurityException gse) {
            throw Utils.makeError(cx, (Scriptable)self, "Error opening key store: " + gse);
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, (Scriptable)self, "I/O error reading key store: " + ioe);
        }
        finally {
            if (passphrase != null) {
                Arrays.fill(passphrase, '\u0000');
            }
        }
    }

    public String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public String getProtocol() {
        return this.protocol;
    }

    private void initialize(Context cx, Scriptable scope) {
        if (this.keyManagers == null && this.privateKey != null) {
            Crypto.ensureCryptoService(cx, scope);
            KeyStore pemKs = Crypto.getCryptoService().createPemKeyStore();
            try {
                pemKs.load(null, null);
                pemKs.setKeyEntry(DEFAULT_KEY_ENTRY, this.privateKey, null, this.certChain);
                KeyManagerFactory keyFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                if (log.isDebugEnabled()) {
                    log.debug("Setting up key manager factory {}", (Object)keyFactory);
                }
                keyFactory.init(pemKs, null);
                this.keyManagers = keyFactory.getKeyManagers();
                assert (this.keyManagers != null);
                assert (this.keyManagers.length == 1);
            }
            catch (GeneralSecurityException gse) {
                throw Utils.makeError(cx, scope, gse.toString());
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, scope, ioe.toString());
            }
        }
        if (this.trustManagers == null && this.trustedCertStore != null) {
            try {
                this.ensureCertStore();
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                if (log.isDebugEnabled()) {
                    log.debug("Setting up trust manager factory {}", (Object)factory);
                }
                factory.init(this.trustedCertStore);
                this.trustManagers = factory.getTrustManagers();
            }
            catch (GeneralSecurityException gse) {
                throw Utils.makeError(cx, (Scriptable)this, gse.toString());
            }
            catch (IOException ioe) {
                throw Utils.makeError(cx, (Scriptable)this, ioe.toString());
            }
        }
        if (this.trustManagers != null) {
            assert (this.trustManagers.length == 1);
            assert (this.trustManagers[0] instanceof X509TrustManager);
            this.trustedCertManager = (X509TrustManager)this.trustManagers[0];
        }
        if (this.crls != null && this.trustManagers != null) {
            this.trustedCertManager = new CompositeTrustManager((X509TrustManager)this.trustManagers[0], this.crls);
            if (log.isDebugEnabled()) {
                log.debug("Adding composite trust manager {}", (Object)this.trustedCertManager);
            }
        }
        this.initialized = true;
    }

    public SSLContext makeContext(Context cx, Scriptable scope) {
        if (!this.initialized) {
            this.initialize(cx, scope);
        }
        try {
            SSLContext context = SSLContext.getInstance(this.protocol);
            context.init(this.keyManagers, new TrustManager[]{AllTrustingManager.INSTANCE}, null);
            if (log.isDebugEnabled()) {
                log.debug("Created a new SSLContext {}", (Object)context);
            }
            return context;
        }
        catch (NoSuchAlgorithmException nse) {
            throw new AssertionError((Object)nse);
        }
        catch (KeyManagementException kme) {
            throw Utils.makeError(cx, scope, "Error initializing SSL context: " + kme);
        }
    }

    public X509TrustManager getTrustManager() {
        return this.trustedCertManager;
    }

    private static final class AllTrustingManager
    implements X509TrustManager {
        static final AllTrustingManager INSTANCE = new AllTrustingManager();

        private AllTrustingManager() {
        }

        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

