/*
 * Decompiled with CFR 0.152.
 */
package activator.analytics.analyzer;

import activator.analytics.AnalyticsExtension$;
import activator.analytics.StandardAnalyticsExtension;
import activator.analytics.analyzer.StatsAnalyzer;
import activator.analytics.analyzer.StatsAnalyzer$;
import activator.analytics.data.TimeRange;
import activator.analytics.data.TimeRange$;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import akka.actor.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class StatsAnalyzer$class {
    public static ActorSystem system(StatsAnalyzer $this) {
        return $this.context().system();
    }

    public static ActorRef statsStoreWorker(StatsAnalyzer $this) {
        return $this.context().actorOf(Props$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsAnalyzer $outer;

            public final StatsAnalyzer.StatsStoreWorker apply() {
                return new StatsAnalyzer.StatsStoreWorker(this.$outer, this.$outer.statsRepository());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(StatsAnalyzer.StatsStoreWorker.class)).withDispatcher(StatsAnalyzer$.MODULE$.StatsStoreWorkerDispatcherId()), "statsStoreWorker");
    }

    public static void updateNextStoreTimestamp(StatsAnalyzer $this, long eventTimestamp) {
        $this.nextStoreTimestamp_$eq(eventTimestamp + $this.storeTimeIntervalMillis());
    }

    public static void addCurrentlyTouched(StatsAnalyzer $this, Object group, long timestamp) {
        if (!$this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched().isDefinedAt(group)) {
            $this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouchedSize_$eq($this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouchedSize() + 1);
        }
        $this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched().update(group, (Object)BoxesRunTime.boxToLong((long)timestamp));
    }

    public static void clearCurrentlyTouched(StatsAnalyzer $this) {
        $this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched().clear();
        $this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouchedSize_$eq(0);
    }

    public static void clearState(StatsAnalyzer $this) {
        $this.activator$analytics$analyzer$StatsAnalyzer$$previouslyTouched().$plus$plus$eq($this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched());
        $this.clearCurrentlyTouched();
        if (!$this.activator$analytics$analyzer$StatsAnalyzer$$previouslyTouched().isEmpty()) {
            long latest = BoxesRunTime.unboxToLong((Object)$this.activator$analytics$analyzer$StatsAnalyzer$$previouslyTouched().values().max((Ordering)Ordering.Long$.MODULE$));
            long purgeTimestamp = latest - $this.purgeUnusedMillis();
            $this.activator$analytics$analyzer$StatsAnalyzer$$previouslyTouched().withFilter((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                    Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable($this, purgeTimestamp){
                public static final long serialVersionUID = 0L;
                private final long purgeTimestamp$1;

                public final boolean apply(Tuple2<Object, Object> x$3) {
                    Tuple2<Object, Object> tuple2 = x$3;
                    if (tuple2 != null) {
                        long timestamp = tuple2._2$mcJ$sp();
                        boolean bl = timestamp < this.purgeTimestamp$1;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.purgeTimestamp$1 = purgeTimestamp$1;
                }
            }).foreach((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StatsAnalyzer $outer;

                public final Map<Object, Object> apply(Tuple2<Object, Object> x$4) {
                    Tuple2<Object, Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        Object group = tuple2._1();
                        this.$outer.stats().$minus$eq(group);
                        this.$outer.statsBuffers().$minus$eq(group);
                        Map map = (Map)this.$outer.activator$analytics$analyzer$StatsAnalyzer$$previouslyTouched().$minus$eq(group);
                        return map;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public static long purgeUnusedMillis(StatsAnalyzer $this) {
        return StatsAnalyzer$.MODULE$.PurgeUnusedMillis();
    }

    public static Object statsFor(StatsAnalyzer $this, Object group) {
        return $this.stats().getOrElseUpdate(group, (Function0)new Serializable($this, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsAnalyzer $outer;
            private final Object group$1;

            public final Object apply() {
                return this.$outer.loadStat(this.group$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.group$1 = group$1;
            }
        });
    }

    public static Object loadStat(StatsAnalyzer $this, Object group) {
        return $this.statsRepository().findBy(group).getOrElse((Function0)new Serializable($this, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsAnalyzer $outer;
            private final Object group$2;

            public final Object apply() {
                return this.$outer.create(this.group$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.group$2 = group$2;
            }
        });
    }

    public static StatsAnalyzer.StatsBuffer statsBufferFor(StatsAnalyzer $this, Object group) {
        return (StatsAnalyzer.StatsBuffer)$this.statsBuffers().getOrElseUpdate(group, (Function0)new Serializable($this, group){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StatsAnalyzer $outer;
            private final Object group$3;

            public final StatsAnalyzer.StatsBuffer apply() {
                return this.$outer.createStatsBuffer(this.$outer.statsFor(this.group$3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.group$3 = group$3;
            }
        });
    }

    public static Seq allTimeRanges(StatsAnalyzer $this, long time) {
        TimeRange minute = TimeRange$.MODULE$.minuteRange(time, TimeRange$.MODULE$.minuteRange$default$2());
        TimeRange hour = TimeRange$.MODULE$.hourRange(time, TimeRange$.MODULE$.hourRange$default$2());
        TimeRange day = TimeRange$.MODULE$.dayRange(time, TimeRange$.MODULE$.dayRange$default$2());
        TimeRange month = TimeRange$.MODULE$.monthRange(time, TimeRange$.MODULE$.monthRange$default$2());
        return $this.useAllTime() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeRange[]{minute, hour, day, month, new TimeRange(TimeRange$.MODULE$.apply$default$1(), TimeRange$.MODULE$.apply$default$2(), TimeRange$.MODULE$.apply$default$3())})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeRange[]{minute, hour, day, month}));
    }

    public static void store(StatsAnalyzer $this) {
        if ($this.storeTimeIntervalMillis() == 0L || (long)$this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouchedSize() >= $this.storeLimit()) {
            $this.storeStats();
            $this.clearState();
        }
    }

    public static void store(StatsAnalyzer $this, long timestamp) {
        if ($this.storeTimeIntervalMillis() != 0L) {
            if ($this.nextStoreTimestamp() == 0L) {
                $this.updateNextStoreTimestamp(timestamp);
            }
            if (timestamp >= $this.nextStoreTimestamp()) {
                $this.storeStats();
                $this.clearState();
                $this.updateNextStoreTimestamp(timestamp);
            }
        }
    }

    public static void storeStats(StatsAnalyzer $this) {
        if ($this.storeTimeIntervalMillis() == 0L) {
            Iterable changedStats = (Iterable)$this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched().keys().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StatsAnalyzer $outer;

                public final Object apply(Object group) {
                    return this.$outer.statsBufferFor(group).toStats();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Iterable$.MODULE$.canBuildFrom());
            $this.statsRepository().save((Iterable<Object>)changedStats);
        } else {
            scala.collection.immutable.Map changedStats = ((TraversableOnce)$this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StatsAnalyzer $outer;

                public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Object group = tuple2._1();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(group), this.$outer.statsBufferFor(group).toStats());
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            package$.MODULE$.actorRef2Scala($this.statsStoreWorker()).$bang((Object)new StatsAnalyzer.StatsStoreWorkerJob($this, (scala.collection.immutable.Map<Object, Object>)changedStats), $this.self());
        }
    }

    public static void $init$(StatsAnalyzer $this) {
        $this.nextStoreTimestamp_$eq(0L);
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$actorPathLevelTimeRanges_$eq(((StandardAnalyticsExtension)AnalyticsExtension$.MODULE$.apply($this.system())).ActorPathTimeRanges());
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$storeTimeIntervalMillis_$eq(((StandardAnalyticsExtension)AnalyticsExtension$.MODULE$.apply($this.system())).StoreTimeInterval());
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$storeLimit_$eq(((StandardAnalyticsExtension)AnalyticsExtension$.MODULE$.apply($this.system())).StoreLimit());
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$useAllTime_$eq(((StandardAnalyticsExtension)AnalyticsExtension$.MODULE$.apply($this.system())).StoreUseAllTime());
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$stats_$eq((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$statsBuffers_$eq((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$activator$analytics$analyzer$StatsAnalyzer$$currentlyTouched_$eq((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        $this.activator$analytics$analyzer$StatsAnalyzer$$currentlyTouchedSize_$eq(0);
        $this.activator$analytics$analyzer$StatsAnalyzer$_setter_$activator$analytics$analyzer$StatsAnalyzer$$previouslyTouched_$eq((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
    }
}

