/*
 * Decompiled with CFR 0.152.
 */
package activator.analytics.rest.http;

import activator.analytics.data.TimeRange;
import activator.analytics.data.TimeRangeType$;
import activator.analytics.rest.http.Paging;
import activator.analytics.rest.http.TimeParser$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class TraceEventResource$ {
    public static final TraceEventResource$ MODULE$;
    private final String TraceEventsIntervalPath;
    private final String SpansIntervalPath;
    private final String TraceUri;
    private final String TraceTreeUri;
    private final String EventUri;
    private final String SpanUri;
    private final String TraceEventsUri;
    private final String SpansUri;
    private final Regex TraceTreePattern;
    private final Regex TraceEventPattern;
    private final Regex SpanPattern;
    private final Regex TraceContextPattern;
    private final String TimeRangeToQueryParametersTemplate;
    private final String PagingQueryParametersTemplate;

    static {
        new TraceEventResource$();
    }

    public String TraceEventsIntervalPath() {
        return this.TraceEventsIntervalPath;
    }

    public String SpansIntervalPath() {
        return this.SpansIntervalPath;
    }

    public String TraceUri() {
        return this.TraceUri;
    }

    public String TraceTreeUri() {
        return this.TraceTreeUri;
    }

    public String EventUri() {
        return this.EventUri;
    }

    public String SpanUri() {
        return this.SpanUri;
    }

    public String TraceEventsUri() {
        return this.TraceEventsUri;
    }

    public String SpansUri() {
        return this.SpansUri;
    }

    public Regex TraceTreePattern() {
        return this.TraceTreePattern;
    }

    public Regex TraceEventPattern() {
        return this.TraceEventPattern;
    }

    public Regex SpanPattern() {
        return this.SpanPattern;
    }

    public Regex TraceContextPattern() {
        return this.TraceContextPattern;
    }

    public String TimeRangeToQueryParametersTemplate() {
        return this.TimeRangeToQueryParametersTemplate;
    }

    public String PagingQueryParametersTemplate() {
        return this.PagingQueryParametersTemplate;
    }

    public Option<String> timeRangeToQueryParameters(TimeRange timeRange) {
        None$ none$;
        Enumeration.Value value = timeRange.rangeType();
        Enumeration.Value value2 = TimeRangeType$.MODULE$.AllTime();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            none$ = None$.MODULE$;
        } else {
            String str = new StringOps(Predef$.MODULE$.augmentString(this.TimeRangeToQueryParametersTemplate())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TimeParser$.MODULE$.format(timeRange.startTime()), TimeParser$.MODULE$.format(timeRange.endTime())}));
            none$ = new Some((Object)str);
        }
        return none$;
    }

    public Option<String> nextQueryParameters(Paging paging, TimeRange timeRange) {
        return paging.nextPosition().map((Function1)new Serializable(paging, timeRange){
            public static final long serialVersionUID = 0L;
            private final Paging paging$1;
            private final TimeRange timeRange$1;

            public final String apply(int next) {
                String pagingParams = new StringOps(Predef$.MODULE$.augmentString(TraceEventResource$.MODULE$.PagingQueryParametersTemplate())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)next), BoxesRunTime.boxToInteger((int)this.paging$1.limit())}));
                Option<String> timeQueryParams = TraceEventResource$.MODULE$.timeRangeToQueryParameters(this.timeRange$1);
                return new StringBuilder().append((Object)pagingParams).append(timeQueryParams.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$1) {
                        return new StringBuilder().append((Object)"&").append((Object)x$1).toString();
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).toString();
            }
            {
                this.paging$1 = paging$1;
                this.timeRange$1 = timeRange$1;
            }
        });
    }

    private TraceEventResource$() {
        MODULE$ = this;
        this.TraceEventsIntervalPath = "events";
        this.SpansIntervalPath = "spans";
        this.TraceUri = "/monitoring/trace/";
        this.TraceTreeUri = new StringBuilder().append((Object)this.TraceUri()).append((Object)"tree/").toString();
        this.EventUri = new StringBuilder().append((Object)this.TraceUri()).append((Object)"event/").toString();
        this.SpanUri = new StringBuilder().append((Object)this.TraceUri()).append((Object)"span/").toString();
        this.TraceEventsUri = new StringBuilder().append((Object)this.TraceUri()).append((Object)this.TraceEventsIntervalPath()).toString();
        this.SpansUri = new StringBuilder().append((Object)this.TraceUri()).append((Object)this.SpansIntervalPath()).toString();
        this.TraceTreePattern = new StringOps(Predef$.MODULE$.augmentString("^.*/tree\\/([\\w\\-]+)")).r();
        this.TraceEventPattern = new StringOps(Predef$.MODULE$.augmentString("^.*/event\\/([\\w\\-]+)")).r();
        this.SpanPattern = new StringOps(Predef$.MODULE$.augmentString("^.*/span\\/([\\w\\-]+)")).r();
        this.TraceContextPattern = new StringOps(Predef$.MODULE$.augmentString("^.*/([\\w\\-]+)")).r();
        this.TimeRangeToQueryParametersTemplate = "startTime=%s&endTime=%s";
        this.PagingQueryParametersTemplate = "offset=%s&limit=%s";
    }
}

