/*
 * Decompiled with CFR 0.152.
 */
package play.core.netty.utils;

import java.util.BitSet;

final class CookieUtil {
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets(VALID_COOKIE_VALUE_OCTETS);

    private static BitSet validCookieValueOctets() {
        BitSet bitSet = new BitSet(8);
        for (int i = 35; i < 127; ++i) {
            bitSet.set(i);
        }
        bitSet.set(34, false);
        bitSet.set(44, false);
        bitSet.set(59, false);
        bitSet.set(92, false);
        return bitSet;
    }

    private static BitSet validCookieNameOctets(BitSet bitSet) {
        BitSet bitSet2 = new BitSet(8);
        bitSet2.or(bitSet);
        bitSet2.set(40, false);
        bitSet2.set(41, false);
        bitSet2.set(60, false);
        bitSet2.set(62, false);
        bitSet2.set(64, false);
        bitSet2.set(58, false);
        bitSet2.set(47, false);
        bitSet2.set(91, false);
        bitSet2.set(93, false);
        bitSet2.set(63, false);
        bitSet2.set(61, false);
        bitSet2.set(123, false);
        bitSet2.set(125, false);
        bitSet2.set(32, false);
        bitSet2.set(9, false);
        return bitSet2;
    }

    static String stripTrailingSeparatorOrNull(StringBuilder stringBuilder) {
        return stringBuilder.length() == 0 ? null : CookieUtil.stripTrailingSeparator(stringBuilder);
    }

    static String stripTrailingSeparator(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    static void add(StringBuilder stringBuilder, String string, long l) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(l);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void add(StringBuilder stringBuilder, String string, String string2) {
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append(string2);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void add(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string);
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static void addQuoted(StringBuilder stringBuilder, String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        stringBuilder.append(string);
        stringBuilder.append('=');
        stringBuilder.append('\"');
        stringBuilder.append(string2);
        stringBuilder.append('\"');
        stringBuilder.append(';');
        stringBuilder.append(' ');
    }

    static int firstInvalidCookieNameOctet(CharSequence charSequence) {
        return CookieUtil.firstInvalidOctet(charSequence, VALID_COOKIE_NAME_OCTETS);
    }

    static int firstInvalidCookieValueOctet(CharSequence charSequence) {
        return CookieUtil.firstInvalidOctet(charSequence, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence charSequence, BitSet bitSet) {
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (bitSet.get(c)) continue;
            return i;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence charSequence) {
        int n = charSequence.length();
        if (n > 0 && charSequence.charAt(0) == '\"') {
            if (n >= 2 && charSequence.charAt(n - 1) == '\"') {
                return n == 2 ? "" : charSequence.subSequence(1, n - 1);
            }
            return null;
        }
        return charSequence;
    }

    private CookieUtil() {
    }
}

