/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import play.api.libs.json.JsValue;
import play.api.libs.json.jackson.PlayJsonModule$;
import scala.runtime.BoxedUnit;

public final class JacksonJson$ {
    public static final JacksonJson$ MODULE$;
    private final ObjectMapper mapper;
    private final JsonFactory jsonFactory;

    static {
        new JacksonJson$();
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    private JsonFactory jsonFactory() {
        return this.jsonFactory;
    }

    private JsonGenerator stringJsonGenerator(StringWriter out) {
        return this.jsonFactory().createGenerator((Writer)out);
    }

    private JsonParser jsonParser(String c) {
        return this.jsonFactory().createParser(c);
    }

    private JsonParser jsonParser(byte[] data) {
        return this.jsonFactory().createParser(data);
    }

    private JsonParser jsonParser(InputStream stream) {
        return this.jsonFactory().createParser(stream);
    }

    public JsValue parseJsValue(byte[] data) {
        return (JsValue)this.mapper().readValue(this.jsonParser(data), JsValue.class);
    }

    public JsValue parseJsValue(String input) {
        return (JsValue)this.mapper().readValue(this.jsonParser(input), JsValue.class);
    }

    public JsValue parseJsValue(InputStream stream) {
        return (JsValue)this.mapper().readValue(this.jsonParser(stream), JsValue.class);
    }

    public String generateFromJsValue(JsValue jsValue, boolean escapeNonASCII) {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = this.stringJsonGenerator(sw);
        Object object = escapeNonASCII ? gen.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII) : BoxedUnit.UNIT;
        this.mapper().writeValue(gen, (Object)jsValue);
        sw.flush();
        return sw.getBuffer().toString();
    }

    public boolean generateFromJsValue$default$2() {
        return false;
    }

    public String prettyPrint(JsValue jsValue) {
        StringWriter sw = new StringWriter();
        JsonGenerator gen = this.stringJsonGenerator(sw).setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        ObjectWriter writer = this.mapper().writerWithDefaultPrettyPrinter();
        writer.writeValue(gen, (Object)jsValue);
        sw.flush();
        return sw.getBuffer().toString();
    }

    public JsonNode jsValueToJsonNode(JsValue jsValue) {
        return this.mapper().valueToTree((Object)jsValue);
    }

    public JsValue jsonNodeToJsValue(JsonNode jsonNode) {
        return (JsValue)this.mapper().treeToValue((TreeNode)jsonNode, JsValue.class);
    }

    private JacksonJson$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper().registerModule((Module)PlayJsonModule$.MODULE$);
        this.jsonFactory = new JsonFactory((ObjectCodec)this.mapper());
    }
}

