/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$InfoLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetector;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tew!B\u0001\u0003\u0011\u00039\u0011aB\"mkN$XM\u001d\u0006\u0003\u0007\u0011\tqa\u00197vgR,'OC\u0001\u0006\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t91\t\\;ti\u0016\u00148#B\u0005\r%\t%\u0006CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00015M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001C:fiRLgnZ:\u0016\u00035\u0002\"\u0001\u0003\u0018\n\u0005=\u0012!aD\"mkN$XM]*fiRLgnZ:\t\rEJ\u0002\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005C\u000443\t\u0007I\u0011\u0001\u001b\u0002#M,GNZ+oSF,X-\u00113ee\u0016\u001c8/F\u00016!\tAa'\u0003\u00028\u0005\tiQK\\5rk\u0016\fE\r\u001a:fgNDa!O\r!\u0002\u0013)\u0014AE:fY\u001a,f.[9vK\u0006#GM]3tg\u0002BQaO\r\u0005\u0002q\n1b]3mM\u0006#GM]3tgV\tQ\b\u0005\u0002\u0014}%\u0011q\b\u0006\u0002\b\u0003\u0012$'/Z:t\u0011\u0015\t\u0015\u0004\"\u0001C\u0003%\u0019X\r\u001c4S_2,7/F\u0001D!\r!uI\u0013\b\u0003\u001b\u0015K!A\u0012\b\u0002\rA\u0013X\rZ3g\u0013\tA\u0015JA\u0002TKRT!A\u0012\b\u0011\u0005\u0011[\u0015B\u0001'J\u0005\u0019\u0019FO]5oO\")a*\u0007C\u0001\u001f\u0006aq-\u001a;TK24'k\u001c7fgV\t\u0001\u000bE\u0002R-*k\u0011A\u0015\u0006\u0003'R\u000bA!\u001e;jY*\tQ+\u0001\u0003kCZ\f\u0017B\u0001%S\u0011\u001dA\u0016D1A\u0005\ne\u000bQbX5t)\u0016\u0014X.\u001b8bi\u0016$W#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016AB1u_6L7M\u0003\u0002`%\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0005d&!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004d3\u0001\u0006IAW\u0001\u000f?&\u001cH+\u001a:nS:\fG/\u001a3!\u0011\u001d)\u0017D1A\u0005\n\u0019\f1\u0001\\8h+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016\u0005\u0003\u0015)g/\u001a8u\u0013\ta\u0017N\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\r9L\u0002\u0015!\u0003h\u0003\u0011awn\u001a\u0011\t\u000fAL\u0002\u0019!C\u0005c\u0006Q1\r\\;ti\u0016\u0014(*\u001c=\u0016\u0003I\u00042!D:v\u0013\t!hB\u0001\u0004PaRLwN\u001c\t\u0003\u0011YL!a\u001e\u0002\u0003\u0015\rcWo\u001d;fe*k\u0007\u0010C\u0004z3\u0001\u0007I\u0011\u0002>\u0002\u001d\rdWo\u001d;fe*k\u0007p\u0018\u0013fcR\u00111P \t\u0003\u001bqL!! \b\u0003\tUs\u0017\u000e\u001e\u0005\b\u007fb\f\t\u00111\u0001s\u0003\rAH%\r\u0005\b\u0003\u0007I\u0002\u0015)\u0003s\u0003-\u0019G.^:uKJTU\u000e\u001f\u0011\t\u0013\u0005\u001d\u0011D1A\u0005\u0002\u0005%\u0011a\u00044bS2,(/\u001a#fi\u0016\u001cGo\u001c:\u0016\u0005\u0005-\u0001#BA\u0007\u0003'iTBAA\b\u0015\r\t\t\u0002B\u0001\u0007e\u0016lw\u000e^3\n\t\u0005U\u0011q\u0002\u0002\u0018\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;peJ+w-[:uefD\u0001\"!\u0007\u001aA\u0003%\u00111B\u0001\u0011M\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe\u0002B!\"!\b\u001a\u0005\u0004%\tAAA\u0010\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002\"A\u00191#a\t\n\u0007\u0005\u0015BCA\u0005TG\",G-\u001e7fe\"A\u0011\u0011F\r!\u0002\u0013\t\t#\u0001\u0006tG\",G-\u001e7fe\u0002B\u0011\"!\f\u001a\u0005\u0004%I!a\f\u0002\u001d\rdWo\u001d;fe\u0012\u000bW-\\8ogV\u0011\u0011\u0011\u0007\t\u0004'\u0005M\u0012bAA\u001b)\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u0002:e\u0001\u000b\u0011BA\u0019\u0003=\u0019G.^:uKJ$\u0015-Z7p]N\u0004\u0003BCA\u001f3\t\u0007I\u0011\u0001\u0002\u00020\u0005Y1\r\\;ti\u0016\u00148i\u001c:f\u0011!\t\t%\u0007Q\u0001\n\u0005E\u0012\u0001D2mkN$XM]\"pe\u0016\u0004\u0003BCA#3\t\u0007I\u0011\u0001\u0002\u0002H\u0005A!/Z1e-&,w/\u0006\u0002\u0002JA\u0019\u0001\"a\u0013\n\u0007\u00055#AA\bDYV\u001cH/\u001a:SK\u0006$g+[3x\u0011!\t\t&\u0007Q\u0001\n\u0005%\u0013!\u0003:fC\u00124\u0016.Z<!\u0011\u001d\t)&\u0007C\u0001\u0003/\nA\"[:UKJl\u0017N\\1uK\u0012,\"!!\u0017\u0011\u00075\tY&C\u0002\u0002^9\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002be!\t!a\u0019\u0002\u000bM$\u0018\r^3\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003[r1\u0001CA5\u0013\r\tYGA\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0003_\n\tHA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0002l\tAq!!\u001e\u001a\t\u0003\t9(A\u0005tk\n\u001c8M]5cKR)10!\u001f\u0002~!A\u00111PA:\u0001\u0004\t\t$\u0001\u0006tk\n\u001c8M]5cKJD\u0001\"a \u0002t\u0001\u0007\u0011\u0011Q\u0001\u0003i>\u0004R!DAB\u0003\u000fK1!!\"\u000f\u0005)a$/\u001a9fCR,GM\u0010\u0019\u0005\u0003\u0013\u000b\u0019\nE\u0003E\u0003\u0017\u000by)C\u0002\u0002\u000e&\u0013Qa\u00117bgN\u0004B!!%\u0002\u00142\u0001A\u0001DAK\u0003{\n\t\u0011!A\u0003\u0002\u0005]%aA0%cE!\u0011\u0011TAP!\ri\u00111T\u0005\u0004\u0003;s!a\u0002(pi\"Lgn\u001a\t\u0004\u001b\u0005\u0005\u0016bAAR\u001d\t\u0019\u0011I\\=)\t\u0005M\u0014q\u0015\t\u0005\u0003S\u000by+\u0004\u0002\u0002,*\u0019\u0011Q\u0016\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0006-&a\u0002<be\u0006\u0014xm\u001d\u0005\b\u0003kJB\u0011AA[)\u001dY\u0018qWA]\u0003\u0007D\u0001\"a\u001f\u00024\u0002\u0007\u0011\u0011\u0007\u0005\t\u0003w\u000b\u0019\f1\u0001\u0002>\u0006\u0001\u0012N\\5uS\u0006d7\u000b^1uK6{G-\u001a\t\u0005\u0003O\ny,\u0003\u0003\u0002B\u0006E$\u0001H*vEN\u001c'/\u001b9uS>t\u0017J\\5uS\u0006d7\u000b^1uK6{G-\u001a\u0005\t\u0003\u007f\n\u0019\f1\u0001\u0002FB)Q\"a!\u0002HB\"\u0011\u0011ZAg!\u0015!\u00151RAf!\u0011\t\t*!4\u0005\u0019\u0005=\u00171YA\u0001\u0002\u0003\u0015\t!a&\u0003\u0007}##\u0007\u000b\u0003\u00024\u0006\u001d\u0006bBAk3\u0011\u0005\u0011q[\u0001\fk:\u001cXOY:de&\u0014W\rF\u0002|\u00033D\u0001\"a\u001f\u0002T\u0002\u0007\u0011\u0011\u0007\u0005\b\u0003+LB\u0011AAo)\u0015Y\u0018q\\Aq\u0011!\tY(a7A\u0002\u0005E\u0002\u0002CA@\u00037\u0004\r!a91\t\u0005\u0015\u0018\u0011\u001e\t\u0006\t\u0006-\u0015q\u001d\t\u0005\u0003#\u000bI\u000f\u0002\u0007\u0002l\u0006\u0005\u0018\u0011!A\u0001\u0006\u0003\t9JA\u0002`IMBq!a<\u001a\t\u0003\t\t0\u0001\u000eqk\nd\u0017n\u001d5DkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$X\rF\u0001|Q!\ti/!>\u0002|\u0006}\bcA\u0007\u0002x&\u0019\u0011\u0011 \b\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002~\u0006\tUk]3!g\u0016tGmQ;se\u0016tGo\u00117vgR,'o\u0015;bi\u0016\u0004\u0013N\\:uK\u0006$\u0007e\u001c4!aV\u0014G.[:i\u0007V\u0014(/\u001a8u\u00072,8\u000f^3s'R\fG/Z\u0011\u0003\u0005\u0003\t1A\r\u00184\u0011\u001d\u0011)!\u0007C\u0001\u0005\u000f\tqc]3oI\u000e+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\u0015\u0007m\u0014I\u0001\u0003\u0005\u0003\f\t\r\u0001\u0019AA\u0019\u0003!\u0011XmY3jm\u0016\u0014\bb\u0002B\b3\u0011\u0005!\u0011C\u0001\u0005U>Lg\u000eF\u0002|\u0005'AqA!\u0006\u0003\u000e\u0001\u0007Q(A\u0004bI\u0012\u0014Xm]:\t\u000f\te\u0011\u0004\"\u0001\u0003\u001c\u0005i!n\\5o'\u0016,GMT8eKN$2a\u001fB\u000f\u0011!\u0011yBa\u0006A\u0002\t\u0005\u0012!C:fK\u0012tu\u000eZ3t!\u0015\u0011\u0019C!\f>\u001b\t\u0011)C\u0003\u0003\u0003(\t%\u0012!C5n[V$\u0018M\u00197f\u0015\r\u0011YCD\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0018\u0005K\u00111aU3r\u0011\u001d\u0011\u0019$\u0007C\u0001\u0005k\tQ\u0001\\3bm\u0016$2a\u001fB\u001c\u0011\u001d\u0011)B!\rA\u0002uBqAa\u000f\u001a\t\u0003\u0011i$\u0001\u0003e_^tGcA>\u0003@!9!Q\u0003B\u001d\u0001\u0004i\u0004b\u0002B\"3\u0011\u0005!QI\u0001\u0013e\u0016<\u0017n\u001d;fe>sW*Z7cKJ,\u0006/\u0006\u0003\u0003H\tUCcA>\u0003J!I!1\nB!\t\u0003\u0007!QJ\u0001\u0005G>$W\rE\u0003\u000e\u0005\u001f\u0012\u0019&C\u0002\u0003R9\u0011\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0005\u0003#\u0013)\u0006\u0002\u0005\u0003X\t\u0005#\u0019AAL\u0005\u0005!\u0006b\u0002B\"3\u0011\u0005!1\f\u000b\u0004w\nu\u0003\u0002\u0003B0\u00053\u0002\rA!\u0019\u0002\u0011\r\fG\u000e\u001c2bG.\u0004BAa\u0019\u0003j5\u0011!Q\r\u0006\u0004\u0005O\"\u0016\u0001\u00027b]\u001eLAAa\u001b\u0003f\tA!+\u001e8oC\ndW\r\u0003\u0005\u0003pe!\tAAAy\u0003!\u0019\b.\u001e;e_^t\u0007b\u0002B:3\u0011%\u0011\u0011_\u0001\u000fG2|7/Z*dQ\u0016$W\u000f\\3s\u000f!\u00119(\u0007E\u0001\u0005\te\u0014AC%oM>dunZ4feB!!1\u0010B?\u001b\u0005Ib\u0001\u0003B@3!\u0005!A!!\u0003\u0015%sgm\u001c'pO\u001e,'oE\u0002\u0003~1Aqa\nB?\t\u0003\u0011)\t\u0006\u0002\u0003z!A!\u0011\u0012B?\t\u0003\u0011Y)A\u0004m_\u001eLeNZ8\u0015\u0007m\u0014i\tC\u0004\u0003\u0010\n\u001d\u0005\u0019\u0001&\u0002\u000f5,7o]1hK\"A!\u0011\u0012B?\t\u0003\u0011\u0019\nF\u0003|\u0005+\u0013I\nC\u0004\u0003\u0018\nE\u0005\u0019\u0001&\u0002\u0011Q,W\u000e\u001d7bi\u0016D\u0001Ba'\u0003\u0012\u0002\u0007\u0011qT\u0001\u0005CJ<\u0017\u0007\u0003\u0005\u0003\n\nuD\u0011\u0001BP)\u001dY(\u0011\u0015BR\u0005KCqAa&\u0003\u001e\u0002\u0007!\n\u0003\u0005\u0003\u001c\nu\u0005\u0019AAP\u0011!\u00119K!(A\u0002\u0005}\u0015\u0001B1sOJ\u00022a\u0005BV\u0013\r\u0011i\u000b\u0006\u0002\u0014\u000bb$XM\\:j_:LE\r\u0015:pm&$WM\u001d\u0005\u0007O%!\tA!-\u0015\u0003\u001dAqA!.\n\t\u0003\u00129,A\u0002hKR$2\u0001\u0007B]\u0011\u001dy\"1\u0017a\u0001\u0005w\u00032a\u0005B_\u0013\r\u0011y\f\u0006\u0002\f\u0003\u000e$xN]*zgR,W\u000eC\u0004\u0003D&!\tE!2\u0002\r1|wn[;q)\t\u00119M\u0004\u0002\t\u0001!9!1Z\u0005\u0005B\t5\u0017aD2sK\u0006$X-\u0012=uK:\u001c\u0018n\u001c8\u0015\u0007a\u0011y\r\u0003\u0004 \u0005\u0013\u0004\r!\t\u0005\u000b\u0005'L!\u0019!C\u0003\u0005\u0005]\u0013!G5t\u0003N\u001cXM\u001d;J]Z\f'/[1oiN,e.\u00192mK\u0012D\u0001Ba6\nA\u00035\u0011\u0011L\u0001\u001bSN\f5o]3si&sg/\u0019:jC:$8/\u00128bE2,G\r\t")
public class Cluster
implements Extension {
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile Cluster$InfoLogger$ InfoLogger$module;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cluster$InfoLogger$ InfoLogger$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.InfoLogger$module != null) return this.InfoLogger$module;
            this.InfoLogger$module = new Cluster$InfoLogger$(this);
            return this.InfoLogger$module;
        }
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$2 = new InternalClusterAction.Subscribe(subscriber, ClusterEvent$InitialStateAsSnapshot$.MODULE$, to.toSet());
        ActorRef x$3 = qual$1.$bang$default$2((Object)x$2);
        qual$1.$bang((Object)x$2, x$3);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$4 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$5 = qual$2.$bang$default$2((Object)x$4);
        qual$2.$bang((Object)x$4, x$5);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$6 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$7 = qual$3.$bang$default$2((Object)x$6);
        qual$3.$bang((Object)x$6, x$7);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$8 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$9 = qual$4.$bang$default$2((Object)x$8);
        qual$4.$bang((Object)x$8, x$9);
    }

    public void publishCurrentClusterState() {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.PublishCurrentClusterState x$10 = new InternalClusterAction.PublishCurrentClusterState((Option<ActorRef>)None$.MODULE$);
        ActorRef x$11 = qual$5.$bang$default$2((Object)x$10);
        qual$5.$bang((Object)x$10, x$11);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$6 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.PublishCurrentClusterState x$12 = new InternalClusterAction.PublishCurrentClusterState((Option<ActorRef>)new Some((Object)receiver));
        ActorRef x$13 = qual$6.$bang$default$2((Object)x$12);
        qual$6.$bang((Object)x$12, x$13);
    }

    public void join(Address address) {
        ScalaActorRef qual$7 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$14 = new ClusterUserAction.JoinTo(address);
        ActorRef x$15 = qual$7.$bang$default$2((Object)x$14);
        qual$7.$bang((Object)x$14, x$15);
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$8 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$16 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)seedNodes.toVector());
        ActorRef x$17 = qual$8.$bang$default$2((Object)x$16);
        qual$8.$bang((Object)x$16, x$17);
    }

    public void leave(Address address) {
        ScalaActorRef qual$9 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$18 = new ClusterUserAction.Leave(address);
        ActorRef x$19 = qual$9.$bang$default$2((Object)x$18);
        qual$9.$bang((Object)x$18, x$19);
    }

    public void down(Address address) {
        ScalaActorRef qual$10 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$20 = new ClusterUserAction.Down(address);
        ActorRef x$21 = qual$10.$bang$default$2((Object)x$20);
        qual$10.$bang((Object)x$20, x$21);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(this, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$11 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$22 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$23 = qual$11.$bang$default$2((Object)x$22);
        qual$11.$bang((Object)x$22, x$23);
    }

    public void shutdown() {
        if (this._isTerminated().compareAndSet(false, true)) {
            this.InfoLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            this.readView().close();
            this.closeScheduler();
            this.clusterJmx().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ClusterJmx x$1) {
                    x$1.unregisterMBean();
                }
            });
            this.InfoLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Cluster$InfoLogger$ InfoLogger() {
        return this.InfoLogger$module == null ? this.InfoLogger$lzycompute() : this.InfoLogger$module;
    }

    public final FailureDetector akka$cluster$Cluster$$createFailureDetector$1() {
        return FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(this.clusterDaemons()), (Object)InternalClusterAction$GetClusterCoreRef$.MODULE$, timeout$1).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            ActorRef actorRef2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            actorRef = actorRef2 = this.system().deadLetters();
        }
        return actorRef;
    }

    public Cluster(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        ActorRefProvider actorRefProvider = system.provider();
        if (actorRefProvider instanceof ClusterActorRefProvider) {
            $anon$1 v1;
            UniqueAddress uniqueAddress;
            ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
            this.selfUniqueAddress = uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).addressUid());
            this._isTerminated = new AtomicBoolean(false);
            this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)"Cluster", LogSource$.MODULE$.fromString());
            this.clusterJmx = None$.MODULE$;
            this.InfoLogger().logInfo("Starting up...");
            if (this.settings().AutoDown()) {
                this.akka$cluster$Cluster$$log().warning("[akka.cluster.auto-down] setting is replaced by [akka.cluster.auto-down-unreachable-after]");
            }
            this.failureDetector = new DefaultFailureDetectorRegistry((Function0)new $anonfun$2(this));
            package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
            if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
                ThreadFactory threadFactory;
                this.InfoLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
                Config cfg = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.scheduler.tick-duration=", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis())}))).withFallback((ConfigMergeable)system.settings().config());
                ThreadFactory threadFactory2 = system.threadFactory();
                if (threadFactory2 instanceof MonitorableThreadFactory) {
                    MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                    threadFactory = monitorableThreadFactory.withName(new StringBuilder().append((Object)monitorableThreadFactory.name()).append((Object)"-cluster-scheduler").toString());
                } else {
                    threadFactory = threadFactory2;
                }
                ThreadFactory threadFactory3 = threadFactory;
                v1 = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
            } else {
                Scheduler systemScheduler = system.scheduler();
                v1 = new $anon$1(this, systemScheduler);
            }
            this.scheduler = v1;
            this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
            Timeout timeout = system.settings().CreationTimeout();
            this.clusterCore = this.liftedTree1$1(timeout);
            this.readView = new ClusterReadView(this);
            system.registerOnTermination((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.shutdown();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (this.settings().JmxEnabled()) {
                ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
                jmx.createMBean();
                this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
            }
            this.InfoLogger().logInfo("Started up successfully");
            return;
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSystem [", "] needs to have a 'ClusterActorRefProvider' enabled in the configuration, currently uses [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system, actorRefProvider.getClass().getName()})));
    }
}

