/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.netty.http;

import com.typesafe.netty.http.DelegateHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;

class EmptyHttpRequest
extends DelegateHttpRequest
implements FullHttpRequest {
    public EmptyHttpRequest(HttpRequest request) {
        super(request);
    }

    public FullHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    public FullHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    public FullHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    public FullHttpRequest copy() {
        if (this.request instanceof FullHttpRequest) {
            return new EmptyHttpRequest((HttpRequest)((FullHttpRequest)this.request).copy());
        }
        DefaultHttpRequest copy = new DefaultHttpRequest(this.getProtocolVersion(), this.getMethod(), this.getUri());
        copy.headers().set(this.headers());
        return new EmptyHttpRequest((HttpRequest)copy);
    }

    public FullHttpRequest retain(int increment) {
        ReferenceCountUtil.retain((Object)this.message, (int)increment);
        return this;
    }

    public FullHttpRequest retain() {
        ReferenceCountUtil.retain((Object)this.message);
        return this;
    }

    public HttpHeaders trailingHeaders() {
        return new DefaultHttpHeaders();
    }

    public HttpContent duplicate() {
        if (this.request instanceof HttpContent) {
            return ((HttpContent)this.request).duplicate();
        }
        return this;
    }

    public ByteBuf content() {
        return Unpooled.EMPTY_BUFFER;
    }

    public int refCnt() {
        if (this.message instanceof ReferenceCounted) {
            return ((ReferenceCounted)this.message).refCnt();
        }
        return 1;
    }

    public boolean release() {
        return ReferenceCountUtil.release((Object)this.message);
    }

    public boolean release(int decrement) {
        return ReferenceCountUtil.release((Object)this.message, (int)decrement);
    }
}

