/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws.ahc;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.PlayConfig;
import play.api.PlayConfig$;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ahc.AhcWSClientConfig;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u001b\t9\u0012\t[2X'\u000ec\u0017.\u001a8u\u0007>tg-[4QCJ\u001cXM\u001d\u0006\u0003\u0007\u0011\t1!\u00195d\u0015\t)a!\u0001\u0002xg*\u0011q\u0001C\u0001\u0005Y&\u00147O\u0003\u0002\n\u0015\u0005\u0019\u0011\r]5\u000b\u0003-\tA\u0001\u001d7bs\u000e\u00011c\u0001\u0001\u000f-A\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0005Y\u0006twMC\u0001\u0014\u0003\u0011Q\u0017M^1\n\u0005U\u0001\"AB(cU\u0016\u001cG\u000fE\u0002\u00189yi\u0011\u0001\u0007\u0006\u00033i\ta!\u001b8kK\u000e$(\"A\u000e\u0002\u000b)\fg/\u0019=\n\u0005uA\"\u0001\u0003)s_ZLG-\u001a:\u0011\u0005}\u0001S\"\u0001\u0002\n\u0005\u0005\u0012!!E!iG^\u001b6\t\\5f]R\u001cuN\u001c4jO\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\bxg\u000ec\u0017.\u001a8u\u0007>tg-[4\u0011\u0005\u00152S\"\u0001\u0003\n\u0005\u001d\"!AD,T\u00072LWM\u001c;D_:4\u0017n\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u000b\u0017\u000e\u0003!I!!\f\u0005\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014aC3om&\u0014xN\\7f]R\u0004\"aK\u0019\n\u0005IB!aC#om&\u0014xN\\7f]RDQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtD\u0003\u0002\u001c8qe\u0002\"a\b\u0001\t\u000b\r\u001a\u0004\u0019\u0001\u0013\t\u000b%\u001a\u0004\u0019\u0001\u0016\t\u000b=\u001a\u0004\u0019\u0001\u0019)\u0005MZ\u0004CA\f=\u0013\ti\u0004D\u0001\u0004J]*,7\r\u001e\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0004O\u0016$H#\u0001\u0010\t\u000b\t\u0003A\u0011\u0001!\u0002\u000bA\f'o]3)\u0005\u0001!\u0005CA\fF\u0013\t1\u0005DA\u0005TS:<G.\u001a;p]\u0002")
public class AhcWSClientConfigParser
implements Provider<AhcWSClientConfig> {
    private final WSClientConfig wsClientConfig;
    private final Configuration configuration;

    public AhcWSClientConfig get() {
        return this.parse();
    }

    public AhcWSClientConfig parse() {
        PlayConfig playConfig = PlayConfig$.MODULE$.apply(this.configuration);
        int maximumConnectionsPerHost = BoxesRunTime.unboxToInt((Object)this.get$1("maxConnectionsPerHost", ConfigLoader$.MODULE$.intLoader(), playConfig));
        int maximumConnectionsTotal = BoxesRunTime.unboxToInt((Object)this.get$1("maxConnectionsTotal", ConfigLoader$.MODULE$.intLoader(), playConfig));
        Duration maxConnectionLifetime = (Duration)this.get$1("maxConnectionLifetime", ConfigLoader$.MODULE$.durationLoader(), playConfig);
        Duration idleConnectionInPoolTimeout = (Duration)this.get$1("idleConnectionInPoolTimeout", ConfigLoader$.MODULE$.durationLoader(), playConfig);
        int maximumNumberOfRedirects = BoxesRunTime.unboxToInt((Object)this.get$1("maxNumberOfRedirects", ConfigLoader$.MODULE$.intLoader(), playConfig));
        int maxRequestRetry = BoxesRunTime.unboxToInt((Object)this.get$1("maxRequestRetry", ConfigLoader$.MODULE$.intLoader(), playConfig));
        boolean disableUrlEncoding = BoxesRunTime.unboxToBoolean((Object)this.get$1("disableUrlEncoding", ConfigLoader$.MODULE$.booleanLoader(), playConfig));
        boolean keepAlive = BoxesRunTime.unboxToBoolean((Object)this.get$1("keepAlive", ConfigLoader$.MODULE$.booleanLoader(), playConfig));
        if (playConfig.underlying().hasPath("play.ws.ahc.keepAlive")) {
            String msg = "Both allowPoolingConnection and allowSslConnectionPool have been replaced by keepAlive!";
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"play.ws.ning.allowPoolingConnection", "play.ws.ning.allowSslConnectionPool"}))).foreach((Function1)new Serializable(this, playConfig, msg){
                public static final long serialVersionUID = 0L;
                private final PlayConfig playConfig$1;
                private final String msg$1;

                public final void apply(String s) {
                    if (this.playConfig$1.underlying().hasPath(s)) {
                        throw this.playConfig$1.reportError(s, this.msg$1, this.playConfig$1.reportError$default$3());
                    }
                }
                {
                    this.playConfig$1 = playConfig$1;
                    this.msg$1 = msg$1;
                }
            });
        }
        return new AhcWSClientConfig(this.wsClientConfig, maximumConnectionsPerHost, maximumConnectionsTotal, maxConnectionLifetime, idleConnectionInPoolTimeout, maximumNumberOfRedirects, maxRequestRetry, disableUrlEncoding, keepAlive);
    }

    private final Object get$1(String name, ConfigLoader evidence$1, PlayConfig playConfig$1) {
        return playConfig$1.getDeprecated(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"play.ws.ahc.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"play.ws.ning.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name}))}), evidence$1);
    }

    @Inject
    public AhcWSClientConfigParser(WSClientConfig wsClientConfig, Configuration configuration, Environment environment) {
        this.wsClientConfig = wsClientConfig;
        this.configuration = configuration;
    }
}

