/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.routing;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.Address;
import akka.cluster.routing.WeightedRoutees$;
import akka.routing.ActorRefRoutee;
import akka.routing.ActorSelectionRoutee;
import akka.routing.Routee;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001Y3Q!\u0001\u0002\u0001\t!\u0011qbV3jO\"$X\r\u001a*pkR,Wm\u001d\u0006\u0003\u0007\u0011\tqA]8vi&twM\u0003\u0002\u0006\r\u000591\r\\;ti\u0016\u0014(\"A\u0004\u0002\t\u0005\\7.Y\n\u0003\u0001%\u0001\"AC\u0007\u000e\u0003-Q\u0011\u0001D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001d-\u0011a!\u00118z%\u00164\u0007\u0002\u0003\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u000fI|W\u000f^3fg\u000e\u0001\u0001cA\n\u001955\tAC\u0003\u0002\u0016-\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003/-\t!bY8mY\u0016\u001cG/[8o\u0013\tIBC\u0001\u0006J]\u0012,\u00070\u001a3TKF\u0004\"aG\u000f\u000e\u0003qQ!a\u0001\u0004\n\u0005ya\"A\u0002*pkR,W\r\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0003-\u0019X\r\u001c4BI\u0012\u0014Xm]:\u0011\u0005\t*S\"A\u0012\u000b\u0005\u00112\u0011!B1di>\u0014\u0018B\u0001\u0014$\u0005\u001d\tE\r\u001a:fgND\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\bo\u0016Lw\r\u001b;t!\u0011QS&\t\u0019\u000f\u0005)Y\u0013B\u0001\u0017\f\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0004\u001b\u0006\u0004(B\u0001\u0017\f!\tQ\u0011'\u0003\u00023\u0017\t\u0019\u0011J\u001c;\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\u00111\u0004(\u000f\u001e\u0011\u0005]\u0002Q\"\u0001\u0002\t\u000bA\u0019\u0004\u0019\u0001\n\t\u000b\u0001\u001a\u0004\u0019A\u0011\t\u000b!\u001a\u0004\u0019A\u0015\t\u000fq\u0002!\u0019!C\u0005{\u00059!-^2lKR\u001cX#\u0001 \u0011\u0007)y\u0004'\u0003\u0002A\u0017\t)\u0011I\u001d:bs\"1!\t\u0001Q\u0001\ny\n\u0001BY;dW\u0016$8\u000f\t\u0005\u0006\t\u0002!\t!R\u0001\bSN,U\u000e\u001d;z+\u00051\u0005C\u0001\u0006H\u0013\tA5BA\u0004C_>dW-\u00198\t\u000b)\u0003A\u0011A&\u0002\u000bQ|G/\u00197\u0016\u0003ABQ!\u0014\u0001\u0005\u00029\u000bQ!\u00199qYf$\"AG(\t\u000bAc\u0005\u0019\u0001\u0019\u0002\u000bY\fG.^3\t\u000bI\u0003A\u0011B*\u0002\u0007%$\u0007\u0010\u0006\u00021)\")Q+\u0015a\u0001a\u0005\t\u0011\u000e")
public class WeightedRoutees {
    private final IndexedSeq<Routee> routees;
    private final Address selfAddress;
    private final int[] buckets;

    private int[] buckets() {
        return this.buckets;
    }

    public boolean isEmpty() {
        return this.buckets().length == 0 || this.buckets()[this.buckets().length - 1] == 0;
    }

    public int total() {
        Predef$.MODULE$.require(!this.isEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "WeightedRoutees must not be used when empty";
            }
        });
        return this.buckets()[this.buckets().length - 1];
    }

    public Routee apply(int value) {
        Predef$.MODULE$.require(1 <= value && value <= this.total(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedRoutees $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("value must be between [1 - %s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.total())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        return (Routee)this.routees.apply(this.idx(Arrays.binarySearch(this.buckets(), value)));
    }

    private int idx(int i) {
        int n;
        if (i >= 0) {
            n = i;
        } else {
            int j = package$.MODULE$.abs(i + 1);
            if (j >= this.buckets().length) {
                throw new IndexOutOfBoundsException(new StringOps(Predef$.MODULE$.augmentString("Requested index [%s] is > max index [%s]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)this.buckets().length)})));
            }
            n = j;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Address akka$cluster$routing$WeightedRoutees$$fullAddress$1(Routee routee) {
        Address a;
        Address address;
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRefRoutee actorRefRoutee = (ActorRefRoutee)routee2;
            ActorRef ref = actorRefRoutee.ref();
            address = ref.path().address();
        } else {
            if (!(routee2 instanceof ActorSelectionRoutee)) throw new MatchError((Object)routee2);
            ActorSelectionRoutee actorSelectionRoutee = (ActorSelectionRoutee)routee2;
            ActorSelection sel = actorSelectionRoutee.selection();
            address = sel.anchor().path().address();
        }
        Address address2 = a = address;
        if (address2 == null) return address2;
        Option option = address2.host();
        Option option2 = address2.port();
        None$ none$ = None$.MODULE$;
        Option option3 = option;
        if (none$ == null) {
            if (option3 != null) {
                return address2;
            }
        } else if (!none$.equals(option3)) return address2;
        None$ none$2 = None$.MODULE$;
        Option option4 = option2;
        if (none$2 == null) {
            if (option4 == null) return this.selfAddress;
            return address2;
        } else {
            if (!none$2.equals(option4)) return address2;
            return this.selfAddress;
        }
    }

    public WeightedRoutees(IndexedSeq<Routee> routees, Address selfAddress, Map<Address, Object> weights2) {
        this.routees = routees;
        this.selfAddress = selfAddress;
        int[] buckets = (int[])Array$.MODULE$.ofDim(routees.size(), ClassTag$.MODULE$.Int());
        int meanWeight = weights2.isEmpty() ? 1 : BoxesRunTime.unboxToInt((Object)weights2.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / weights2.size();
        Map w = weights2.withDefaultValue((Object)BoxesRunTime.boxToInteger((int)meanWeight));
        IntRef i = new IntRef(0);
        IntRef sum = new IntRef(0);
        routees.foreach((Function1)new $anonfun$3(this, buckets, w, i, sum));
        this.buckets = buckets;
    }
}

