<!--- Copyright (C) 2009-2015 Typesafe Inc. <http://www.typesafe.com> -->
# Play Modules

> This is a temporary location for listing modules, until there will be a location to register them on the Play website.

> Blog posts describing the process of writing a module can be found on [objectify.be](http://www.objectify.be/wordpress/?p=363).

## Airbrake.io notifier

* **Website:** <http://teamon.eu/play-airbrake/>
* **Documentation:** <https://github.com/teamon/play-airbrake/blob/master/README.md>
* **Short description:** Send exception notifications to airbrake.io

## Amazon SES module (Scala)

* **Website:** <https://github.com/Rhinofly/play-mailer>
* **Documentation:** <https://github.com/Rhinofly/play-mailer/blob/master/README.md>
* **Short description:** SES (Simple Email Service) API wrapper for Play

## Amazon S3 module (Scala)

* **Website:** <https://github.com/Rhinofly/play-s3>
* **Documentation:** <https://github.com/Rhinofly/play-s3/blob/master/README.md>
* **Short description:** S3 (Simple Storage Service) API wrapper for Play

## Amf module (Scala)

* **Website:** <https://github.com/Rhinofly/play-amf>
* **Documentation:** <https://github.com/Rhinofly/play-amf/blob/master/README.md>
* **Short description:** AMF (ActionScript Message Format) support for Play

## Authentication and Authorization module (Scala)

* **Website:** <https://github.com/t2v/play20-auth>
* **Documentation(en):** <https://github.com/t2v/play20-auth/blob/master/README.md>
* **Documentation(ja):** <https://github.com/t2v/play20-auth/blob/master/README.ja.md>
* **Short description** This module provides an authentication and authorization way
* Now also has 2.1-SNAPSHOT support: <https://github.com/t2v/play20-auth/tree/play21>

## Authenticity Token module

* **Website:** <https://github.com/orefalo/play2-authenticitytoken>
* **Documentation:** <https://github.com/orefalo/play2-authenticitytoken/blob/master/README.md>
* **Short description:** Brings back play1 authenticity token - provides a way around CSRF attacks


## ClojureScript Plugin

* **Website:** <https://bitbucket.org/jmhofer/play-clojurescript> (docs, code)
* **Short description:** Compiles ClojureScript asset files to JavaScript

## Cloudfront module (Scala)

* **Website:** <https://github.com/mchv/play2-cloudfront>
* **Documentation:** <https://github.com/mchv/play2-cloudfront/blob/master/README.md>
* **Short description** This module helps to integrate a play application with Cloudfront CDN. 

## Currency Converter (Java)

* **Website:** <https://edulify.github.io/play-currency-converter-module.edulify.com/>
* **Documentation:** <https://github.com/edulify/play-currency-converter-module.edulify.com/blob/master/README.md>
* **Short description:** Currency converter for Play. It uses web services to get the current exchange rate.

## Deadbolt 2 Plugin
* **Website (docs, sample):** <https://github.com/schaloner/deadbolt-2>
* **Short description:** Deadbolt is an authorisation mechanism for defining access rights to certain controller methods or parts of a view using a simple AND/OR/NOT syntax

## DDSL Plugin - Dynamic Distributed Service Locator
* **Website (docs, sample):** <https://github.com/mbknor/ddsl-play2-module>
* **Short description:** DDSL - Dynamic Distributed Service Locator - Makes it really easy to create your own dynamic "private cloud" in-house or on EC2/Joyent etc using ZooKeeper

## Dust Plugin
* **Website (docs, sample):** <https://github.com/typesafehub/play-plugins/tree/master/dust>
* **Short description:** Provides support for the dust client side template language

## Google Closure Template Plugin
* **Website (docs, sample):** [https://github.com/gawkermedia/play2-closure](https://github.com/gawkermedia/play2-closure)
* **Short description:** Provides support for Google Closure Templates

## Elasticsearch

* **Website:** <https://github.com/cleverage/play2-elasticsearch>
* **Documentation:** <https://github.com/cleverage/play2-elasticsearch/blob/master/README.md>
* **Repository:** <http://cleverage.github.io/play2-elasticsearch/releases/>
* **Short description** Indexing/Requesting Object in Embedded ElasticSearch Server or remote(s) Node(s). 

## Ember.js

* **Website:** <https://github.com/krumpi/play-emberjs>
* **Documentation:** <https://github.com/krumpi/play-emberjs/blob/master/README.md>
* **Short description** Supports precompilation of ember.js/handlebars templates.

## funcy - Page Driven Functional Tests (Java)

* **Website:** <https://github.com/joergviola/funcy>
* **Documentation:** <https://github.com/joergviola/funcy/blob/master/README.md>
* **Repository:** <http://www.joergviola.de/releases/>
* **Short description** Simplifies writing functional test using Page Driver classes.

## FolderMessages plugin

* **Website:** <https://github.com/germanosin/play-foldermessages>
* **Short Description:** Allows you to split localization messages files into separate manageable files.

## Flyway plugin

* **Website:** <https://github.com/tototoshi/play-flyway>
* **Documentation:** <https://github.com/tototoshi/play-flyway/blob/master/README.md>
* **Short Description:** Supports database migration with Flyway.

## Geolocation (Java)

* **Website:** <https://edulify.github.io/play-geolocation-module.edulify.com/>
* **Documentation:** <https://github.com/edulify/play-geolocation-module.edulify.com/blob/master/README.md>
* **Short description:** Module to retrieve Geolocation data based on IP.

## Google's HTML Compressor (Java and Scala)
* **Website:** <https://github.com/mohiva/play-html-compressor>
* **Documentation:** <https://github.com/mohiva/play-html-compressor/blob/master/README.md>
* **Short description:** Google's HTML Compressor for Play 2.

## Groovy Templates plugin

* **Website:** <https://github.com/manuelbernhardt/play2-groovy-templates>
* **Documentation:** <https://github.com/manuelbernhardt/play2-groovy-templates/blob/master/README.md>
* **Short description:** This module brings the Groovy templates engine of Play 1 to Play 2. 

## Groovy Templates plugin - gt-engine-play2

* **Website:** <https://github.com/mbknor/gt-engine-play2>
* **Documentation:** <https://github.com/mbknor/gt-engine-play2/blob/master/README.markdown>
* **Short description:** This module brings the Groovy Template engine from play 1 to Play. It uses gt-engine which is used by the Play 1 module "Faster Groovy Templates" <http://www.playframework.com/modules/fastergt>
* **Samples:** <https://github.com/mbknor/gt-engine-play2/tree/master/samples>

## Guice Plugin (Java and Scala)
* **Website (docs, sample):** <https://github.com/typesafehub/play-plugins/tree/master/guice>
* **Short description:** Provides DI via Guice

## HTML5 Tags module (Java and Scala)
* **Website:** <https://github.com/loicdescotte/Play2-HTML5Tags>
* **Documentation:** <https://github.com/loicdescotte/Play2-HTML5Tags/blob/master/README.md>
* **Short description:** These tags add client side validation capabilities, based on model constraints (e.g required, email pattern, max|min lentgh...) and specific input fields (date, telephone number, url...) to Play templates

## InputValidator (Scala)

* **Website:** <https://github.com/seratch/inputvalidator/tree/master/play-module>
* **Short description:** Provides a simple validation API for Play

## JackRabbit Plugin (Java and Scala)
* **Website (docs, sample):** [JackRabbit Plugin GitHub](https://github.com/sgougi/play21-jackrabbit-plugin)
* **Short description:** Apache JackRabbit Plugin for play! framework 2

## Japid module

* **Website:** <https://github.com/branaway/japid42>
* **Documentation:** <https://github.com/branaway/japid42>
* **Short description:** This module provides Japid java templates for Play

## JsMessages

* **Website:** <https://github.com/julienrf/play-jsmessages>
* **Short description:** Allows to compute localized messages on client side.

## JSON minification Plugin

* **Website:** <https://github.com/joscha/play-jsonminify>
* **Documentation:** <https://github.com/joscha/play-jsonminify/blob/master/README.md>
* **Short description:** Allows JSON asset pretty-printing and minification

## JSONP filter

* **Website:** <https://github.com/julienrf/play-jsonp-filter>
* **Short description:** Enables JSONP on your existing HTTP API.

## Lessc Plugin

* **Website:** <https://github.com/jmparsons/play-lessc>
* **Documentation:** <https://github.com/jmparsons/play-lessc/blob/master/README.md>
* **Short description:** Allows [Less](http://lesscss.org/) command line compilation through Node

## Liquibase Module

* **Website:** <https://github.com/Ticketfly/play-liquibase>
* **Documentation:** <https://github.com/Ticketfly/play-liquibase/blob/master/README.md>
* **Short description:** Runs [Liquibase](http://www.liquibase.org/) database schema migrations on app startup

## Manual Dependency Injection Plugin (Java and Scala)
* **Website (docs, sample):** <https://github.com/typesafehub/play-plugins>
* **Short description:** Provides DI via manual injection

## Memcached Plugin

* **Website:** <https://github.com/mumoshu/play2-memcached>
* **Short description:** Provides a memcached based cache implementation

## Messages Compiler Plugin (Scala)

* **Website:** <https://github.com/tegonal/play-messagescompiler>
* **Documentation:** <https://github.com/tegonal/play-messagescompiler/blob/master/readme.md>
* **Short description:** Provides type safety for the project's messages.

## MongoDB Jackson Mapper Plugin (Java)

* **Website (docs, sample):** <https://github.com/vznet/play-mongo-jackson-mapper>
* **Short description:** Provides managed MongoDB access and object mapping using Jackson annotations

## MongoDB Jongo Plugin (Java)
* **Website (docs, sample):** <https://github.com/alexanderjarvis/play-jongo>
* **Short description:** Provides managed MongoDB access and object mapping using [Jongo](http://jongo.org/)

## MongoDB Morphia Plugin (Java)
* **Website (docs, sample):** <https://github.com/leodagdag/play2-morphia-plugin>
* **Short description:** Provides managed MongoDB access and object mapping via Morphia

## MongoDB Salat, Casbah Plugin (Scala)
* **Website (docs, sample):** <https://github.com/leon/play-salat>
* **Short description:** Provides managed MongoDB access and object mapping using Salat and Casbah 

## Mountable routing

* **Website:** <http://teamon.eu/play-navigator/>
* **Documentation:** <https://github.com/teamon/play-navigator/blob/master/README.md>
* **Description:** <http://codetunes.com/2012/05/09/scala-dsl-tutorial-writing-web-framework-router>

## Mustache (Java,Scala)

* **Website:** <https://github.com/julienba/play2-mustache>
* **Documentation:** <https://github.com/julienba/play2-mustache>
* **Short description:** Mustache template support

## Native Packaging Module

* **Website:** <https://github.com/kryptt/play2-native-packager-plugin>
* **Documentation:** <https://github.com/kryptt/play2-native-packager-plugin/blob/master/README.md>
* **Short description:** Allow to package Play! 2.x applications as a standard system package (deb/rpm/msi).

## NINA (Scala)
* **Website (docs, sample):** <https://github.com/dontcare4free/nina>
* **Short description:** Provides a typesafe way to query SQL databases with a special emphasis on selective querying

## Origami: OrientDB O/G Mapper (Java and Scala)
* **Website (docs, sample):** [Origami Plugin GitHub](https://github.com/sgougi/play21-origami-plugin)
* **Short description:** Origami plugin is a Java O/G mapper for the OrientDB with Play! Framework 2.

## PDF module (Java)

* **Website:** <https://github.com/innoveit/play2-pdf>
* **Documentation:** <https://github.com/innoveit/play2-pdf/blob/master/README.md>
* **Short description** Generate PDF output from HTML templates

## Play! Authenticate (Java)

* **Website:** <https://joscha.github.io/play-authenticate/>
* **Documentation:** <https://github.com/joscha/play-authenticate/blob/master/README.md>
* **Short description:** A highly customizable authentication module for Play

## play2-sprites
* **Website:** <https://github.com/koofr/play2-sprites/>
* **Short description:** play2-sprites is an sbt plugin that generates sprites from images.

## Play-Bootstrap3 (Java and Scala)
* **Website:** <http://play-bootstrap3.herokuapp.com/>
* **Documentation:** <http://play-bootstrap3.herokuapp.com/docs>
* **Repository:** <https://github.com/adrianhurt/play-bootstrap3>
* **Short description:** a collection of input helpers and field constructors for Play Framework 2.4 to render Twitter Bootstrap 3 HTML code.

## play-jaxrs (Java)
* **Website (docs, sample):** [play-jaxrs](https://github.com/pk11/play-jaxrs/)
* **Short description:** a JAX-RS router plugin for play java apps 

## Play-pac4j (Java and Scala)
* **Website:** <https://github.com/leleuj/play-pac4j>
* **Documentation:** <https://github.com/leleuj/play-pac4j/blob/master/README.md>
* **Short description:** Play client in Scala and Java which supports OAuth/CAS/OpenID/HTTP authentication and user profile retrieval

## Play Plovr Plugin
* **Website (docs, sample):** <https://github.com/benmccann/play-plovr-plugin>
* **Short description:** Adds Closure Compiler and Closure Library support to Play

## Play-Slick
* **Website (docs, sample):** <https://github.com/freekh/play-slick>
* **Short description:** This plugin makes Slick a first-class citizen of Play.

## Pusher
* **Website:** <https://pusher.com/>
* **Documentation:** <https://github.com/tindr/Play2Pusher>
* **Short description:** Easily interact with the Pusher Service within your Play application.

## Play Dok

* **Website:** <http://fudok.com/>
* **Documentation:** <https://github.com/cchantep/play-dok/>
* **Short description:** Library to integrate Fukdok PDF templating service with your Play application.

## Qunit (Java)

* **Website:** <https://github.com/gcusnieux/play20-qunit>
* **Documentation:** <https://github.com/gcusnieux/play20-qunit>
* **Short description:** JavaScript unit test suite

## Redis Plugin  (Java and Scala)
* **Website (docs, sample):** <https://github.com/typesafehub/play-plugins>
* **Short description:** Provides a redis based cache implementation, also lets you use Redis specific APIs

## Swaggerkit (Scala)
* **Website (docs, sample, code):** <https://github.com/eamelink/swaggerkit>
* **Short description:** Helps you expose a [Swagger](http://swagger.io/) specification of a JSON REST API built with Play in a clean way.

## Emailer Plugin  (Java and Scala)
* **Website (docs, sample):** <https://github.com/playframework/play-mailer>
* **Short description:** Provides an emailer based on apache commons-email

## Roy Compiled Asset Plugin (Ray)
* **Website:** <https://github.com/pufuwozu/ray>
* **Blog post:** <http://brianmckenna.org/blog/ray>
* **Short description:** Compiles [Roy](http://roy.brianmckenna.org/) files to JavaScript

## Sass Plugin
* **Website:** <https://github.com/jlitola/play-sass>
* **Short description:** Asset handling for [Sass](http://sass-lang.com/) files

## ScalikeJDBC Plugin (Scala)

* **Website:** <https://github.com/scalikejdbc/scalikejdbc-play-support>
* **Short description:** Provides yet another database access API for Play

## SecureSocial (Java and Scala)

* **Website:** <http://securesocial.ws/>
* **Short description:** An authentication module supporting OAuth, OAuth2, OpenID, Username/Password and custom authentication schemes.

## Silhouette (Scala)

* **Website:** <http://silhouette.mohiva.com/>
* **Documentation:** <http://silhouette.mohiva.com/docs/>
* **Short description:** An authentication library that supports several authentication methods, including OAuth1, OAuth2, OpenID, Credentials, Basic Authentication, Two Factor Authentication or custom authentication schemes.

## Sitemap Generator (Java)

* **Website:** <https://edulify.github.io/play-sitemap-module.edulify.com/>
* **Documentation:** <https://github.com/edulify/play-sitemap-module.edulify.com/blob/master/README.md>
* **Short description:** Automatic [sitemaps](http://www.sitemaps.org/) generator for Play

## Snapshot Plugin (Java and Scala)
* **Website (docs, sample):** <https://github.com/vznet/play-snapshot>
* **Short description:** Provides a hash bang snapshot functionality using HtmlUnit, as described by Google [here](https://developers.google.com/webmasters/ajax-crawling/docs/html-snapshot)

## socket.io.play (scala only, pre-alpha)

* **Website:** <https://github.com/milliondreams/socket.io.play>
* **Documentation:** <https://github.com/milliondreams/socket.io.play/blob/master/README.md>

## Stateless client authentication (Scala)
* **Website:** <https://github.com/blendlabs/play20-stateless-auth>
* **Documentation:** <https://github.com/blendlabs/play20-stateless-auth/blob/master/README.md>
* **Short description** Provides required and optional authentication without requiring server-side state (signed auth data is stored on the client)

## Statsd Plugin (Java and Scala)
* **Website (docs, sample):** <https://github.com/vznet/play-statsd>
* **Short description:** Provides a statsd client

## Stylus Plugin

* **Website:** <https://github.com/patiencelabs/play-stylus>
* **Short description:** Support for [Stylus](https://github.com/learnboost/stylus) CSS compilation

## TinkerPop Frames O/G Mapper Plugins (Java)
* **Website (docs, sample):** GitHub: [Frames-Neo4j Plugin](https://github.com/sgougi/play21-frames-neo4j-plugin) / [Frames-OrientDB Plugin](https://github.com/sgougi/play21-frames-orientdb-plugin) / [Frames-Titan Plugin](https://github.com/sgougi/play21-frames-titan-plugin)
* **Short description:** Java O/G mapper plugins for GraphDBs

## Typesafe util Plugin (Scala)
* **Website (docs, sample):** <https://github.com/typesafehub/play-plugins>
* **Short description:** Provides request header based security and syntactic sugar to deal with plugins

## Typesafe SbtGoodies Plugin 
* **Website (docs, sample):** <https://github.com/typesafehub/play-plugins/tree/master/sbtgoodies>
* **Short description:** Provides extra sbt commands

## TypeScript Plugin
* **Website:** <https://github.com/mumoshu/play2-typescript>
* **Short description:** Asset handling for [TypeScript](http://www.typescriptlang.org/) files

## WAR Module

* **Website:** <https://github.com/dlecan/play2-war-plugin>
* **Documentation:** <https://github.com/dlecan/play2-war-plugin/blob/develop/README.md>
* **Short description:** Allow to package Play! 2.x applications into standard WAR packages.

## XForward module

* **Website:** <https://github.com/olsego/play2-xforward>
* **Documentation:** <https://github.com/olsego/play2-xforward/blob/master/Readme.md>
* **Short description:** This module brings back the missing Proxy forwarding settings from Play1.

## XWiki Rendering module (Scala)

* **Website:** <https://literalice.github.io/play-xwiki-rendering/>
* **Documentation:** <https://github.com/literalice/play-xwiki-rendering/>
* **Short description:** XWiki Rendering Framework integration for Play

## Thymeleaf module (Scala)
* **Website:** <https://github.com/dmitraver/scala-play-thymeleaf-plugin>
* **Documentation:** <https://github.com/dmitraver/scala-play-thymeleaf-plugin/blob/master/README.md>
* **Short description:** Allows to use [Thymeleaf](http://www.thymeleaf.org/) template engine as an alternative
to Twirl
