/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

@Metadata(firstVersion="2.13.0", label="language,json", title="JsonPath")
@XmlRootElement(name="jsonpath")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JsonPathExpression
extends ExpressionDefinition {
    @XmlAttribute(name="resultType")
    private String resultTypeName;
    @XmlTransient
    private Class<?> resultType;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean suppressExceptions;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean allowSimple;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean allowEasyPredicate;
    @XmlAttribute
    @Metadata(defaultValue="false")
    private Boolean writeAsString;
    @XmlAttribute
    private String headerName;

    public JsonPathExpression() {
    }

    public JsonPathExpression(String expression) {
        super(expression);
    }

    public String getResultTypeName() {
        return this.resultTypeName;
    }

    public void setResultTypeName(String resultTypeName) {
        this.resultTypeName = resultTypeName;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public Boolean getSuppressExceptions() {
        return this.suppressExceptions;
    }

    public Boolean getAllowSimple() {
        return this.allowSimple;
    }

    public void setAllowSimple(Boolean allowSimple) {
        this.allowSimple = allowSimple;
    }

    public Boolean getAllowEasyPredicate() {
        return this.allowEasyPredicate;
    }

    public void setAllowEasyPredicate(Boolean allowEasyPredicate) {
        this.allowEasyPredicate = allowEasyPredicate;
    }

    public void setSuppressExceptions(Boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public Boolean getWriteAsString() {
        return this.writeAsString;
    }

    public void setWriteAsString(Boolean writeAsString) {
        this.writeAsString = writeAsString;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    @Override
    public String getLanguage() {
        return "jsonpath";
    }

    @Override
    public Expression createExpression(CamelContext camelContext) {
        if (this.resultType == null && this.resultTypeName != null) {
            try {
                this.resultType = camelContext.getClassResolver().resolveMandatoryClass(this.resultTypeName);
            }
            catch (ClassNotFoundException e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return super.createExpression(camelContext);
    }

    @Override
    protected void configureExpression(CamelContext camelContext, Expression expression) {
        if (this.resultType != null) {
            this.setProperty(expression, "resultType", this.resultType);
        }
        if (this.suppressExceptions != null) {
            this.setProperty(expression, "suppressExceptions", this.suppressExceptions);
        }
        if (this.allowSimple != null) {
            this.setProperty(expression, "allowSimple", this.allowSimple);
        }
        if (this.allowEasyPredicate != null) {
            this.setProperty(expression, "allowEasyPredicate", this.allowEasyPredicate);
        }
        if (this.writeAsString != null) {
            this.setProperty(expression, "writeAsString", this.writeAsString);
        }
        if (this.headerName != null) {
            this.setProperty(expression, "headerName", this.headerName);
        }
        super.configureExpression(camelContext, expression);
    }

    @Override
    protected void configurePredicate(CamelContext camelContext, Predicate predicate) {
        if (this.resultType != null) {
            this.setProperty(predicate, "resultType", this.resultType);
        }
        if (this.suppressExceptions != null) {
            this.setProperty(predicate, "suppressExceptions", this.suppressExceptions);
        }
        if (this.allowSimple != null) {
            this.setProperty(predicate, "allowSimple", this.allowSimple);
        }
        if (this.allowEasyPredicate != null) {
            this.setProperty(predicate, "allowEasyPredicate", this.allowEasyPredicate);
        }
        if (this.writeAsString != null) {
            this.setProperty(predicate, "writeAsString", this.writeAsString);
        }
        if (this.headerName != null) {
            this.setProperty(predicate, "headerName", this.headerName);
        }
        super.configurePredicate(camelContext, predicate);
    }
}

