/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.server;

import java.net.InetSocketAddress;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.core.GFacThreadPoolExecutor;
import org.apache.airavata.gfac.cpi.GfacService;
import org.apache.airavata.gfac.server.GfacServerHandler;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GfacServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(GfacServer.class);
    private static final String SERVER_NAME = "Gfac Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;

    public GfacServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public void StartGfacServer(GfacService.Processor<GfacServerHandler> gfacServerHandlerProcessor) throws Exception {
        final int serverPort = Integer.parseInt(ServerSettings.getGFacServerPort());
        try {
            String serverHost = ServerSettings.getGfacServerHost();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
            TServerSocket serverTransport = new TServerSocket(inetSocketAddress);
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processor(gfacServerHandlerProcessor));
            new Thread(){

                @Override
                public void run() {
                    GfacServer.this.server.serve();
                    GfacServer.this.setStatus(IServer.ServerStatus.STARTING);
                    logger.info("Starting Gfac Server ...");
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    while (!GfacServer.this.server.isServing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (GfacServer.this.server.isServing()) {
                        GfacServer.this.setStatus(IServer.ServerStatus.STARTED);
                        logger.info("Started Gfac Server on Port " + serverPort + " ...");
                    }
                }
            }.start();
        }
        catch (TTransportException e) {
            logger.error(e.getMessage());
            this.setStatus(IServer.ServerStatus.FAILED);
            logger.error("Failed to start Gfac server on port " + serverPort + " ...");
        }
    }

    public static void main(String[] args) {
        try {
            new GfacServer().start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.setStatus(IServer.ServerStatus.STARTING);
        GfacService.Processor gfacService = new GfacService.Processor((GfacService.Iface)new GfacServerHandler());
        this.StartGfacServer((GfacService.Processor<GfacServerHandler>)gfacService);
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
        GFacThreadPoolExecutor.getCachedThreadPool().shutdownNow();
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }
}

