/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools;

import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.globus.common.CoGProperties;
import org.globus.common.Version;
import org.globus.gsi.util.CertificateLoadUtil;
import org.globus.gsi.util.CertificateUtil;

public class CertInfo {
    private static final int SUBJECT = 2;
    private static final int ISSUER = 4;
    private static final int SDATE = 8;
    private static final int EDATE = 16;
    private static final int ALL = 32;
    private static String message = "\nSyntax: java CertInfo [-help] [-file certfile] [-all] [-subject] [...]\n\n\tDisplays certificate information. Unless the optional \n\tfile argument is given, the default location of the file\n\tcontaining the certficate is assumed:\n\n\t  -- " + CoGProperties.getDefault().getUserCertFile() + "\n\n" + "\tOptions\n" + "\t-help | -usage\n" + "\t\tDisplay usage.\n" + "\t-version\n" + "\t\tDisplay version.\n" + "\t-file certfile\n" + "\t\tUse 'certfile' at non-default location.\n" + "\t-globus\n" + "\t\tPrints information in globus format.\n\n" + "\tOptions determining what to print from certificate\n\n" + "\t-all\n" + "\t\tWhole certificate.\n" + "\t-subject\n" + "\t\tSubject string of the cert.\n" + "\t-issuer\n" + "\t\tIssuer.\n" + "\t-startdate\n" + "\t\tValidity of cert: start date.\n" + "\t-enddate\n" + "\t\tValidity of cert: end date.\n\n";

    public static void main(String[] args) {
        String dt;
        String dn;
        String file = null;
        int options = 0;
        boolean error = false;
        boolean globusStyle = false;
        boolean debug = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-file")) {
                file = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-subject")) {
                options |= 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-issuer")) {
                options |= 4;
                continue;
            }
            if (args[i].equalsIgnoreCase("-startdate")) {
                options |= 8;
                continue;
            }
            if (args[i].equalsIgnoreCase("-enddate")) {
                options |= 0x10;
                continue;
            }
            if (args[i].equalsIgnoreCase("-all")) {
                options |= 0x20;
                continue;
            }
            if (args[i].equalsIgnoreCase("-globus")) {
                globusStyle = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-version")) {
                System.err.println(Version.getVersion());
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-usage")) {
                System.err.println(message);
                System.exit(1);
                continue;
            }
            System.err.println("Error: argument not recognized : " + args[i]);
            error = true;
        }
        if (error) {
            System.err.println("\nUsage: java CertInfo [-help] [-file certfile] [-all] [-subject] [...]\n");
            System.err.println("Use -help to display full usage.");
            System.exit(1);
        }
        if (file == null) {
            file = CoGProperties.getDefault().getUserCertFile();
        }
        X509Certificate cert = null;
        try {
            cert = CertificateLoadUtil.loadCertificate(file);
        }
        catch (Exception e) {
            System.err.println("Unable to load the certificate : " + e.getMessage());
            System.exit(1);
        }
        if (options == 0) {
            options = 30;
        }
        if ((options & 2) != 0) {
            dn = null;
            dn = globusStyle ? CertificateUtil.toGlobusID(cert.getSubjectDN()) : cert.getSubjectDN().getName();
            System.out.println("subject     : " + dn);
        }
        if ((options & 4) != 0) {
            dn = null;
            dn = globusStyle ? CertificateUtil.toGlobusID(cert.getIssuerDN()) : cert.getIssuerDN().getName();
            System.out.println("issuer      : " + dn);
        }
        TimeZone tz = null;
        SimpleDateFormat df = null;
        if (globusStyle) {
            tz = TimeZone.getTimeZone("GMT");
            df = new SimpleDateFormat("MMM dd HH:mm:ss yyyy z");
            df.setTimeZone(tz);
        }
        if ((options & 8) != 0) {
            dt = null;
            dt = globusStyle ? df.format(cert.getNotBefore()) : cert.getNotBefore().toString();
            System.out.println("start date  : " + dt);
        }
        if ((options & 0x10) != 0) {
            dt = null;
            dt = globusStyle ? df.format(cert.getNotAfter()) : cert.getNotAfter().toString();
            System.out.println("end date    : " + dt);
        }
        if ((options & 0x20) != 0) {
            System.out.println("certificate :");
            System.out.println(cert.toString());
        }
    }
}

