/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.credential.store.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.airavata.credential.store.store.CredentialStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationReader {
    private String successUrl;
    private String errorUrl;
    private String portalRedirectUrl;

    public String getPortalRedirectUrl() {
        return this.portalRedirectUrl;
    }

    public void setPortalRedirectUrl(String portalRedirectUrl) {
        this.portalRedirectUrl = portalRedirectUrl;
    }

    public ConfigurationReader() throws CredentialStoreException {
        try {
            this.loadConfigurations();
        }
        catch (Exception e) {
            throw new CredentialStoreException("Unable to read credential store specific configurations.", e);
        }
    }

    private void loadConfigurations() throws ParserConfigurationException, IOException, SAXException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("credential-store/client.xml");
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(inputStream);
        doc.getDocumentElement().normalize();
        NodeList nodeList = doc.getElementsByTagName("credential-store");
        this.readElementValue(nodeList);
    }

    private void readElementValue(NodeList nodeList) {
        for (int temp = 0; temp < nodeList.getLength(); ++temp) {
            Node nNode = nodeList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element eElement = (Element)nNode;
            this.successUrl = eElement.getElementsByTagName("successUri").item(0).getTextContent();
            this.errorUrl = eElement.getElementsByTagName("errorUri").item(0).getTextContent();
            this.portalRedirectUrl = eElement.getElementsByTagName("redirectUri").item(0).getTextContent();
        }
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public String getErrorUrl() {
        return this.errorUrl;
    }

    public void setErrorUrl(String errorUrl) {
        this.errorUrl = errorUrl;
    }
}

