/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.api.service;

import java.net.InetSocketAddress;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.registry.api.RegistryService;
import org.apache.airavata.registry.api.service.handler.RegistryServerHandler;
import org.apache.airavata.registry.api.service.messaging.RegistryServiceDBEventMessagingFactory;
import org.apache.airavata.registry.api.service.util.AppCatalogInitUtil;
import org.apache.airavata.registry.api.service.util.Constants;
import org.apache.airavata.registry.api.service.util.ExperimentCatalogInitUtil;
import org.apache.airavata.registry.api.service.util.ReplicaCatalogInitUtil;
import org.apache.airavata.registry.api.service.util.WorkflowCatalogInitUtil;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAPIServer
implements IServer {
    private static final Logger logger = LoggerFactory.getLogger(RegistryAPIServer.class);
    private static final String SERVER_NAME = "Registry API Server";
    private static final String SERVER_VERSION = "1.0";
    private IServer.ServerStatus status;
    private TServer server;

    public RegistryAPIServer() {
        this.setStatus(IServer.ServerStatus.STOPPED);
    }

    public void StartRegistryServer(RegistryService.Processor<RegistryServerHandler> orchestratorServerHandlerProcessor) throws Exception {
        logger.info("Initializing ExperimentCatalog DB");
        ExperimentCatalogInitUtil.initializeDB();
        logger.info("Initializing AppCatalog DB");
        AppCatalogInitUtil.initializeDB();
        logger.info("Initializing WorkflowCatalog DB");
        WorkflowCatalogInitUtil.initializeDB();
        logger.info("Initializing ReplicaCatalog DB");
        ReplicaCatalogInitUtil.initializeDB();
        final int serverPort = Integer.parseInt(ServerSettings.getSetting((String)"regserver.server.port", (String)"8960"));
        try {
            TServerSocket serverTransport;
            String serverHost = ServerSettings.getSetting((String)"regserver.server.host", null);
            if (serverHost == null) {
                serverTransport = new TServerSocket(serverPort);
            } else {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(serverHost, serverPort);
                serverTransport = new TServerSocket(inetSocketAddress);
            }
            TThreadPoolServer.Args options = new TThreadPoolServer.Args((TServerTransport)serverTransport);
            options.minWorkerThreads = Integer.parseInt(ServerSettings.getSetting((String)"regserver.server.min.threads", (String)"30"));
            this.server = new TThreadPoolServer((TThreadPoolServer.Args)options.processor(orchestratorServerHandlerProcessor));
            new Thread(){

                @Override
                public void run() {
                    RegistryAPIServer.this.server.serve();
                    RegistryAPIServer.this.setStatus(IServer.ServerStatus.STARTING);
                    logger.info("Starting Registry Server ... ");
                }
            }.start();
            new Thread(){

                @Override
                public void run() {
                    while (!RegistryAPIServer.this.server.isServing()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                    if (RegistryAPIServer.this.server.isServing()) {
                        RegistryAPIServer.this.setStatus(IServer.ServerStatus.STARTED);
                        logger.info("Started Registry Server on Port " + serverPort + " ...");
                        if (!RegistryAPIServer.this.startDatabaseEventHandlers()) {
                            logger.error("Stopping Registry Server as DB event handlers failed to start!");
                            RegistryAPIServer.this.server.stop();
                        }
                    }
                }
            }.start();
        }
        catch (TTransportException e) {
            logger.error(e.getMessage());
            this.setStatus(IServer.ServerStatus.FAILED);
            logger.error("Failed to start Registry server on port " + serverPort + " ...");
        }
    }

    private boolean startDatabaseEventHandlers() {
        try {
            logger.info("Registring registry service with publishers for db-events.");
            RegistryServiceDBEventMessagingFactory.registerRegistryServiceWithPublishers(Constants.DB_EVENT_SUBSCRIBERS);
            logger.info("Starting registry service db-event-handler subscriber.");
            RegistryServiceDBEventMessagingFactory.getDBEventSubscriber();
        }
        catch (Exception ex) {
            logger.error("Failed to start database event handlers, reason: " + ex.getMessage(), (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            new RegistryAPIServer().start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void start() throws Exception {
        this.setStatus(IServer.ServerStatus.STARTING);
        RegistryService.Processor orchestratorService = new RegistryService.Processor((RegistryService.Iface)new RegistryServerHandler());
        this.StartRegistryServer((RegistryService.Processor<RegistryServerHandler>)orchestratorService);
    }

    public void stop() throws Exception {
        if (this.server != null && this.server.isServing()) {
            this.setStatus(IServer.ServerStatus.STOPING);
            this.server.stop();
        }
    }

    public void restart() throws Exception {
        this.stop();
        this.start();
    }

    public void configure() throws Exception {
    }

    public IServer.ServerStatus getStatus() throws Exception {
        return this.status;
    }

    private void setStatus(IServer.ServerStatus stat) {
        this.status = stat;
        this.status.updateTime();
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getVersion() {
        return SERVER_VERSION;
    }
}

