/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.client.request.CallbackRequest;
import edu.uiuc.ncsa.security.delegation.client.request.CallbackResponse;
import edu.uiuc.ncsa.security.delegation.client.server.CBServer;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.services.Response;
import edu.uiuc.ncsa.security.delegation.services.Server;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import java.net.URI;
import javax.servlet.ServletRequest;
import net.oauth.OAuth;

public class CBServerImpl
implements AddressableServer,
CBServer {
    TokenForge tokenForge;
    URI address;

    public CBServerImpl(TokenForge tokenForge, URI address) {
        this.tokenForge = tokenForge;
        this.address = address;
    }

    public URI getAddress() {
        return this.address;
    }

    public Response process(Request request) {
        return request.process((Server)this);
    }

    public CallbackResponse processCallback(CallbackRequest callbackRequest) {
        CallbackResponse cResp = new CallbackResponse();
        ServletRequest servletRequest = callbackRequest.getServletRequest();
        String token = servletRequest.getParameter("oauth_token");
        if (token == null || token.length() == 0) {
            throw new GeneralException("Error: No token found");
        }
        String tc = OAuth.decodePercent((String)token);
        String verifier = servletRequest.getParameter("oauth_verifier");
        if (verifier == null || verifier.length() == 0) {
            throw new GeneralException("Error: No verifier found");
        }
        String v = OAuth.decodePercent((String)verifier);
        AuthorizationGrant ag = this.tokenForge.getAuthorizationGrant(new String[]{tc});
        cResp.setAuthorizationGrant(ag);
        cResp.setVerifier(this.tokenForge.getVerifier(new String[]{v}));
        return cResp;
    }
}

