/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.orchestrator.cpi.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.gfac.core.task.TaskException;
import org.apache.airavata.model.appcatalog.appinterface.ApplicationInterfaceDescription;
import org.apache.airavata.model.appcatalog.computeresource.BatchQueue;
import org.apache.airavata.model.appcatalog.computeresource.ComputeResourceDescription;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.MonitorMode;
import org.apache.airavata.model.appcatalog.computeresource.SSHJobSubmission;
import org.apache.airavata.model.appcatalog.gatewayprofile.ComputeResourcePreference;
import org.apache.airavata.model.application.io.DataType;
import org.apache.airavata.model.application.io.InputDataObjectType;
import org.apache.airavata.model.application.io.OutputDataObjectType;
import org.apache.airavata.model.commons.ErrorModel;
import org.apache.airavata.model.data.movement.DataMovementProtocol;
import org.apache.airavata.model.error.LaunchValidationException;
import org.apache.airavata.model.error.ValidationResults;
import org.apache.airavata.model.error.ValidatorResult;
import org.apache.airavata.model.experiment.ExperimentModel;
import org.apache.airavata.model.process.ProcessModel;
import org.apache.airavata.model.scheduling.ComputationalResourceSchedulingModel;
import org.apache.airavata.model.status.TaskState;
import org.apache.airavata.model.status.TaskStatus;
import org.apache.airavata.model.task.DataStageType;
import org.apache.airavata.model.task.DataStagingTaskModel;
import org.apache.airavata.model.task.EnvironmentSetupTaskModel;
import org.apache.airavata.model.task.JobSubmissionTaskModel;
import org.apache.airavata.model.task.MonitorTaskModel;
import org.apache.airavata.model.task.TaskModel;
import org.apache.airavata.model.task.TaskTypes;
import org.apache.airavata.model.util.ExperimentModelUtil;
import org.apache.airavata.orchestrator.core.exception.OrchestratorException;
import org.apache.airavata.orchestrator.core.impl.GFACPassiveJobSubmitter;
import org.apache.airavata.orchestrator.core.job.JobSubmitter;
import org.apache.airavata.orchestrator.core.utils.OrchestratorUtils;
import org.apache.airavata.orchestrator.core.validator.JobMetadataValidator;
import org.apache.airavata.orchestrator.cpi.impl.AbstractOrchestrator;
import org.apache.airavata.registry.core.experiment.catalog.impl.RegistryFactory;
import org.apache.airavata.registry.cpi.AppCatalog;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.apache.airavata.registry.cpi.ExpCatChildDataType;
import org.apache.airavata.registry.cpi.ExperimentCatalog;
import org.apache.airavata.registry.cpi.ExperimentCatalogModelType;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleOrchestratorImpl
extends AbstractOrchestrator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleOrchestratorImpl.class);
    private ExecutorService executor;
    private JobSubmitter jobSubmitter = null;

    public SimpleOrchestratorImpl() throws OrchestratorException {
        try {
            try {
                this.jobSubmitter = new GFACPassiveJobSubmitter();
                this.jobSubmitter.initialize(this.orchestratorContext);
            }
            catch (Exception e) {
                String error = "Error creating JobSubmitter in non threaded mode ";
                logger.error(error);
                throw new OrchestratorException(error, e);
            }
        }
        catch (OrchestratorException e) {
            logger.error("Error Constructing the Orchestrator");
            throw e;
        }
    }

    @Override
    public boolean launchProcess(ProcessModel processModel, String tokenId) throws OrchestratorException {
        try {
            return this.jobSubmitter.submit(processModel.getExperimentId(), processModel.getProcessId(), tokenId);
        }
        catch (Exception e) {
            throw new OrchestratorException("Error launching the job", e);
        }
    }

    @Override
    public ValidationResults validateExperiment(ExperimentModel experiment) throws OrchestratorException, LaunchValidationException {
        ValidationResults validationResults = new ValidationResults();
        validationResults.setValidationState(true);
        String errorMsg = "Validation Errors : ";
        if (this.orchestratorConfiguration.isEnableValidation()) {
            List<String> validatorClasses = this.orchestratorContext.getOrchestratorConfiguration().getValidatorClasses();
            for (String validator : validatorClasses) {
                try {
                    Class<JobMetadataValidator> vClass = Class.forName(validator.trim()).asSubclass(JobMetadataValidator.class);
                    JobMetadataValidator jobMetadataValidator = vClass.newInstance();
                    validationResults = jobMetadataValidator.validate(experiment, null);
                    if (validationResults.isValidationState()) {
                        logger.info("Validation of " + validator + " is SUCCESSFUL");
                        continue;
                    }
                    List validationResultList = validationResults.getValidationResultList();
                    for (ValidatorResult result : validationResultList) {
                        String validationError;
                        if (result.isResult() || (validationError = result.getErrorDetails()) == null) continue;
                        errorMsg = errorMsg + validationError + " ";
                    }
                    logger.error("Validation of " + validator + " for experiment Id " + experiment.getExperimentId() + " is FAILED:[error]. " + errorMsg);
                    validationResults.setValidationState(false);
                    try {
                        ErrorModel details = new ErrorModel();
                        details.setActualErrorMessage(errorMsg);
                        details.setCreationTime(Calendar.getInstance().getTimeInMillis());
                        this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.EXPERIMENT_ERROR, (Object)details, (Object)experiment.getExperimentId());
                    }
                    catch (RegistryException e) {
                        logger.error("Error while saving error details to registry", (Throwable)e);
                    }
                    break;
                }
                catch (ClassNotFoundException e) {
                    logger.error("Error loading the validation class: ", (Object)validator, (Object)e);
                    validationResults.setValidationState(false);
                }
                catch (InstantiationException e) {
                    logger.error("Error loading the validation class: ", (Object)validator, (Object)e);
                    validationResults.setValidationState(false);
                }
                catch (IllegalAccessException e) {
                    logger.error("Error loading the validation class: ", (Object)validator, (Object)e);
                    validationResults.setValidationState(false);
                }
            }
        }
        if (validationResults.isValidationState()) {
            return validationResults;
        }
        LaunchValidationException launchValidationException = new LaunchValidationException();
        launchValidationException.setValidationResult(validationResults);
        launchValidationException.setErrorMessage("Validation failed refer the validationResults list for detail error. Validation errors : " + errorMsg);
        throw launchValidationException;
    }

    @Override
    public ValidationResults validateProcess(ExperimentModel experiment, ProcessModel processModel) throws OrchestratorException, LaunchValidationException {
        ValidationResults validationResults = new ValidationResults();
        validationResults.setValidationState(true);
        String errorMsg = "Validation Errors : ";
        if (this.orchestratorConfiguration.isEnableValidation()) {
            List<String> validatorClzzez = this.orchestratorContext.getOrchestratorConfiguration().getValidatorClasses();
            for (String validator : validatorClzzez) {
                try {
                    Class<JobMetadataValidator> vClass = Class.forName(validator.trim()).asSubclass(JobMetadataValidator.class);
                    JobMetadataValidator jobMetadataValidator = vClass.newInstance();
                    validationResults = jobMetadataValidator.validate(experiment, processModel);
                    if (validationResults.isValidationState()) {
                        logger.info("Validation of " + validator + " is SUCCESSFUL");
                        continue;
                    }
                    List validationResultList = validationResults.getValidationResultList();
                    for (ValidatorResult result : validationResultList) {
                        String validationError;
                        if (result.isResult() || (validationError = result.getErrorDetails()) == null) continue;
                        errorMsg = errorMsg + validationError + " ";
                    }
                    logger.error("Validation of " + validator + " for experiment Id " + experiment.getExperimentId() + " is FAILED:[error]. " + errorMsg);
                    validationResults.setValidationState(false);
                    try {
                        ErrorModel details = new ErrorModel();
                        details.setActualErrorMessage(errorMsg);
                        details.setCreationTime(Calendar.getInstance().getTimeInMillis());
                        this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.PROCESS_ERROR, (Object)details, (Object)processModel.getProcessId());
                    }
                    catch (RegistryException e) {
                        logger.error("Error while saving error details to registry", (Throwable)e);
                    }
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    logger.error("Error loading the validation class: ", (Object)validator, (Object)e);
                    validationResults.setValidationState(false);
                }
            }
        }
        if (validationResults.isValidationState()) {
            return validationResults;
        }
        LaunchValidationException launchValidationException = new LaunchValidationException();
        launchValidationException.setValidationResult(validationResults);
        launchValidationException.setErrorMessage("Validation failed refer the validationResults list for detail error. Validation errors : " + errorMsg);
        throw launchValidationException;
    }

    @Override
    public void cancelExperiment(ExperimentModel experiment, ProcessModel processModel, String tokenId) throws OrchestratorException {
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public JobSubmitter getJobSubmitter() {
        return this.jobSubmitter;
    }

    public void setJobSubmitter(JobSubmitter jobSubmitter) {
        this.jobSubmitter = jobSubmitter;
    }

    @Override
    public void initialize() throws OrchestratorException {
    }

    public List<ProcessModel> createProcesses(String experimentId, String gatewayId) throws OrchestratorException {
        ArrayList<ProcessModel> processModels = new ArrayList<ProcessModel>();
        try {
            Registry registry = this.orchestratorContext.getRegistry();
            ExperimentModel experimentModel = (ExperimentModel)registry.getExperimentCatalog().get(ExperimentCatalogModelType.EXPERIMENT, (Object)experimentId);
            List processList = registry.getExperimentCatalog().get(ExperimentCatalogModelType.PROCESS, "experimentId", (Object)experimentId);
            if (processList != null && !processList.isEmpty()) {
                for (Object processObject : processList) {
                    ProcessModel processModel = (ProcessModel)processObject;
                    processModels.add(processModel);
                }
            } else {
                ProcessModel processModel = ExperimentModelUtil.cloneProcessFromExperiment((ExperimentModel)experimentModel);
                String processId = (String)registry.getExperimentCatalog().add(ExpCatChildDataType.PROCESS, (Object)processModel, (Object)experimentId);
                processModel.setProcessId(processId);
                processModels.add(processModel);
            }
        }
        catch (Exception e) {
            throw new OrchestratorException("Error during creating process");
        }
        return processModels;
    }

    public String createAndSaveTasks(String gatewayId, ProcessModel processModel, boolean autoSchedule) throws OrchestratorException {
        try {
            ExperimentCatalog experimentCatalog = this.orchestratorContext.getRegistry().getExperimentCatalog();
            AppCatalog appCatalog = this.orchestratorContext.getRegistry().getAppCatalog();
            ComputationalResourceSchedulingModel resourceSchedule = processModel.getProcessResourceSchedule();
            String userGivenQueueName = resourceSchedule.getQueueName();
            int userGivenWallTime = resourceSchedule.getWallTimeLimit();
            String resourceHostId = resourceSchedule.getResourceHostId();
            if (resourceHostId == null) {
                throw new OrchestratorException("Compute Resource Id cannot be null at this point");
            }
            ComputeResourceDescription computeResource = appCatalog.getComputeResource().getComputeResource(resourceHostId);
            JobSubmissionInterface preferredJobSubmissionInterface = OrchestratorUtils.getPreferredJobSubmissionInterface(this.orchestratorContext, processModel, gatewayId);
            ComputeResourcePreference resourcePreference = OrchestratorUtils.getComputeResourcePreference(this.orchestratorContext, processModel, gatewayId);
            ArrayList<String> taskIdList = new ArrayList<String>();
            if (resourcePreference.getPreferredJobSubmissionProtocol() == JobSubmissionProtocol.UNICORE) {
                taskIdList.addAll(this.createAndSaveSubmissionTasks(gatewayId, preferredJobSubmissionInterface, processModel, userGivenWallTime));
            } else {
                taskIdList.addAll(this.createAndSaveEnvSetupTask(gatewayId, processModel, experimentCatalog));
                taskIdList.addAll(this.createAndSaveInputDataStagingTasks(processModel, gatewayId));
                if (autoSchedule) {
                    List definedBatchQueues = computeResource.getBatchQueues();
                    for (BatchQueue batchQueue : definedBatchQueues) {
                        if (!batchQueue.getQueueName().equals(userGivenQueueName)) continue;
                        int maxRunTime = batchQueue.getMaxRunTime();
                        if (maxRunTime < userGivenWallTime) {
                            resourceSchedule.setWallTimeLimit(maxRunTime);
                            int numOfMaxWallTimeJobs = (int)Math.floor(userGivenWallTime / maxRunTime);
                            for (int i = 1; i <= numOfMaxWallTimeJobs; ++i) {
                                taskIdList.addAll(this.createAndSaveSubmissionTasks(gatewayId, preferredJobSubmissionInterface, processModel, maxRunTime));
                            }
                            int leftWallTime = userGivenWallTime % maxRunTime;
                            if (leftWallTime == 0) continue;
                            taskIdList.addAll(this.createAndSaveSubmissionTasks(gatewayId, preferredJobSubmissionInterface, processModel, leftWallTime));
                            continue;
                        }
                        taskIdList.addAll(this.createAndSaveSubmissionTasks(gatewayId, preferredJobSubmissionInterface, processModel, userGivenWallTime));
                    }
                } else {
                    taskIdList.addAll(this.createAndSaveSubmissionTasks(gatewayId, preferredJobSubmissionInterface, processModel, userGivenWallTime));
                }
                taskIdList.addAll(this.createAndSaveOutputDataStagingTasks(processModel, gatewayId));
            }
            experimentCatalog.update(ExperimentCatalogModelType.PROCESS, (Object)processModel, (Object)processModel.getProcessId());
            return this.getTaskDag(taskIdList);
        }
        catch (Exception e) {
            throw new OrchestratorException("Error during creating process", e);
        }
    }

    private String getTaskDag(List<String> taskIdList) {
        if (taskIdList.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : taskIdList) {
            sb.append(s).append(",");
        }
        String dag = sb.toString();
        return dag.substring(0, dag.length() - 1);
    }

    private List<String> createAndSaveEnvSetupTask(String gatewayId, ProcessModel processModel, ExperimentCatalog experimentCatalog) throws RegistryException, TException, AiravataException {
        ArrayList<String> envTaskIds = new ArrayList<String>();
        TaskModel envSetupTask = new TaskModel();
        envSetupTask.setTaskType(TaskTypes.ENV_SETUP);
        envSetupTask.setTaskStatuses(Arrays.asList(new TaskStatus(TaskState.CREATED)));
        envSetupTask.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        envSetupTask.setParentProcessId(processModel.getProcessId());
        EnvironmentSetupTaskModel envSetupSubModel = new EnvironmentSetupTaskModel();
        envSetupSubModel.setProtocol(OrchestratorUtils.getSecurityProtocol(this.orchestratorContext, processModel, gatewayId));
        ComputeResourcePreference computeResourcePreference = OrchestratorUtils.getComputeResourcePreference(this.orchestratorContext, processModel, gatewayId);
        String scratchLocation = OrchestratorUtils.getScratchLocation(this.orchestratorContext, processModel, gatewayId);
        String workingDir = scratchLocation + File.separator + processModel.getProcessId();
        envSetupSubModel.setLocation(workingDir);
        byte[] envSetupSub = ThriftUtils.serializeThriftObject((TBase)envSetupSubModel);
        envSetupTask.setSubTaskModel(envSetupSub);
        String envSetupTaskId = (String)experimentCatalog.add(ExpCatChildDataType.TASK, (Object)envSetupTask, (Object)processModel.getProcessId());
        envSetupTask.setTaskId(envSetupTaskId);
        envTaskIds.add(envSetupTaskId);
        return envTaskIds;
    }

    public List<String> createAndSaveInputDataStagingTasks(ProcessModel processModel, String gatewayId) throws RegistryException, AiravataException {
        ArrayList<String> dataStagingTaskIds = new ArrayList<String>();
        List processInputs = processModel.getProcessInputs();
        this.sortByInputOrder(processInputs);
        if (processInputs != null) {
            for (InputDataObjectType processInput : processInputs) {
                DataType type = processInput.getType();
                switch (type) {
                    case STDERR: {
                        break;
                    }
                    case STDOUT: {
                        break;
                    }
                    case URI: 
                    case URI_COLLECTION: {
                        try {
                            TaskModel inputDataStagingTask = this.getInputDataStagingTask(processModel, processInput, gatewayId);
                            String taskId = (String)this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)inputDataStagingTask, (Object)processModel.getProcessId());
                            inputDataStagingTask.setTaskId(taskId);
                            dataStagingTaskIds.add(inputDataStagingTask.getTaskId());
                            break;
                        }
                        catch (TaskException | AppCatalogException | TException e) {
                            throw new RegistryException("Error while serializing data staging sub task model");
                        }
                    }
                }
            }
        }
        return dataStagingTaskIds;
    }

    public List<String> createAndSaveOutputDataStagingTasks(ProcessModel processModel, String gatewayId) throws RegistryException, AiravataException {
        ArrayList<String> dataStagingTaskIds = new ArrayList<String>();
        List processOutputs = processModel.getProcessOutputs();
        String appName = OrchestratorUtils.getApplicationInterfaceName(this.orchestratorContext, processModel);
        if (processOutputs != null) {
            for (OutputDataObjectType processOutput : processOutputs) {
                DataType type = processOutput.getType();
                switch (type) {
                    case STDOUT: {
                        if (null == processOutput.getValue() || processOutput.getValue().trim().isEmpty()) {
                            processOutput.setValue(appName + ".stdout");
                        }
                        this.createOutputDataSatagingTasks(processModel, gatewayId, dataStagingTaskIds, processOutput);
                        break;
                    }
                    case STDERR: {
                        if (null == processOutput.getValue() || processOutput.getValue().trim().isEmpty()) {
                            processOutput.setValue(appName + ".stderr");
                        }
                        this.createOutputDataSatagingTasks(processModel, gatewayId, dataStagingTaskIds, processOutput);
                        break;
                    }
                    case URI: {
                        this.createOutputDataSatagingTasks(processModel, gatewayId, dataStagingTaskIds, processOutput);
                        break;
                    }
                    case FLOAT: 
                    case STRING: 
                    case INTEGER: {
                        this.createOutputDataSatagingTasks(processModel, gatewayId, dataStagingTaskIds, processOutput);
                        break;
                    }
                }
            }
        }
        try {
            if (this.isArchive(processModel, gatewayId)) {
                this.createArchiveDataStatgingTask(processModel, gatewayId, dataStagingTaskIds);
            }
        }
        catch (AppCatalogException e) {
            throw new RegistryException("Error! Application interface retrieval failed");
        }
        return dataStagingTaskIds;
    }

    private boolean isArchive(ProcessModel processModel, String gatewayId) throws AppCatalogException {
        AppCatalog appCatalog = RegistryFactory.getAppCatalog();
        ApplicationInterfaceDescription appInterface = appCatalog.getApplicationInterface().getApplicationInterface(processModel.getApplicationInterfaceId());
        return appInterface.isArchiveWorkingDirectory();
    }

    private void createArchiveDataStatgingTask(ProcessModel processModel, String gatewayId, List<String> dataStagingTaskIds) throws RegistryException, AiravataException {
        TaskModel archiveTask = null;
        try {
            archiveTask = this.getOutputDataStagingTask(processModel, null, gatewayId);
        }
        catch (TException e) {
            throw new RegistryException("Error! DataStaging sub task serialization failed");
        }
        String taskId = (String)this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)archiveTask, (Object)processModel.getProcessId());
        archiveTask.setTaskId(taskId);
        dataStagingTaskIds.add(archiveTask.getTaskId());
    }

    private void createOutputDataSatagingTasks(ProcessModel processModel, String gatewayId, List<String> dataStagingTaskIds, OutputDataObjectType processOutput) throws RegistryException, AiravataException {
        try {
            TaskModel outputDataStagingTask = this.getOutputDataStagingTask(processModel, processOutput, gatewayId);
            String taskId = (String)this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)outputDataStagingTask, (Object)processModel.getProcessId());
            outputDataStagingTask.setTaskId(taskId);
            dataStagingTaskIds.add(outputDataStagingTask.getTaskId());
        }
        catch (TException e) {
            throw new RegistryException("Error while serializing data staging sub task model", (Throwable)e);
        }
    }

    private List<String> createAndSaveSubmissionTasks(String gatewayId, JobSubmissionInterface jobSubmissionInterface, ProcessModel processModel, int wallTime) throws TException, RegistryException, OrchestratorException {
        JobSubmissionProtocol jobSubmissionProtocol = jobSubmissionInterface.getJobSubmissionProtocol();
        MonitorMode monitorMode = null;
        if (jobSubmissionProtocol == JobSubmissionProtocol.SSH || jobSubmissionProtocol == JobSubmissionProtocol.SSH_FORK) {
            SSHJobSubmission sshJobSubmission = OrchestratorUtils.getSSHJobSubmission(this.orchestratorContext, jobSubmissionInterface.getJobSubmissionInterfaceId());
            monitorMode = sshJobSubmission.getMonitorMode();
        } else if (jobSubmissionProtocol == JobSubmissionProtocol.UNICORE) {
            monitorMode = MonitorMode.FORK;
        } else if (jobSubmissionProtocol == JobSubmissionProtocol.LOCAL) {
            monitorMode = MonitorMode.LOCAL;
        } else if (jobSubmissionProtocol == JobSubmissionProtocol.CLOUD) {
            monitorMode = MonitorMode.CLOUD_JOB_MONITOR;
        } else {
            logger.error("expId : {}, processId : {} :- Unsupported Job submission protocol {}.", new Object[]{processModel.getExperimentId(), processModel.getProcessId(), jobSubmissionProtocol.name()});
            throw new OrchestratorException("Unsupported Job Submission Protocol " + jobSubmissionProtocol.name());
        }
        ArrayList<String> submissionTaskIds = new ArrayList<String>();
        TaskModel taskModel = new TaskModel();
        taskModel.setParentProcessId(processModel.getProcessId());
        taskModel.setCreationTime(new Date().getTime());
        taskModel.setLastUpdateTime(taskModel.getCreationTime());
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskModel.setTaskStatuses(Arrays.asList(taskStatus));
        taskModel.setTaskType(TaskTypes.JOB_SUBMISSION);
        JobSubmissionTaskModel submissionSubTask = new JobSubmissionTaskModel();
        submissionSubTask.setMonitorMode(monitorMode);
        submissionSubTask.setJobSubmissionProtocol(jobSubmissionProtocol);
        submissionSubTask.setWallTime(wallTime);
        byte[] bytes = ThriftUtils.serializeThriftObject((TBase)submissionSubTask);
        taskModel.setSubTaskModel(bytes);
        String taskId = (String)this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)taskModel, (Object)processModel.getProcessId());
        taskModel.setTaskId(taskId);
        submissionTaskIds.add(taskModel.getTaskId());
        if (monitorMode == MonitorMode.JOB_EMAIL_NOTIFICATION_MONITOR || monitorMode == MonitorMode.CLOUD_JOB_MONITOR) {
            TaskModel monitorTaskModel = new TaskModel();
            monitorTaskModel.setParentProcessId(processModel.getProcessId());
            monitorTaskModel.setCreationTime(new Date().getTime());
            monitorTaskModel.setLastUpdateTime(monitorTaskModel.getCreationTime());
            TaskStatus monitorTaskStatus = new TaskStatus(TaskState.CREATED);
            monitorTaskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            monitorTaskModel.setTaskStatuses(Arrays.asList(monitorTaskStatus));
            monitorTaskModel.setTaskType(TaskTypes.MONITORING);
            MonitorTaskModel monitorSubTaskModel = new MonitorTaskModel();
            monitorSubTaskModel.setMonitorMode(monitorMode);
            monitorTaskModel.setSubTaskModel(ThriftUtils.serializeThriftObject((TBase)monitorSubTaskModel));
            String mTaskId = (String)this.orchestratorContext.getRegistry().getExperimentCatalog().add(ExpCatChildDataType.TASK, (Object)monitorTaskModel, (Object)processModel.getProcessId());
            monitorTaskModel.setTaskId(mTaskId);
            submissionTaskIds.add(monitorTaskModel.getTaskId());
        }
        return submissionTaskIds;
    }

    private void sortByInputOrder(List<InputDataObjectType> processInputs) {
        Collections.sort(processInputs, new Comparator<InputDataObjectType>(){

            @Override
            public int compare(InputDataObjectType inputDT_1, InputDataObjectType inputDT_2) {
                return inputDT_1.getInputOrder() - inputDT_2.getInputOrder();
            }
        });
    }

    private TaskModel getInputDataStagingTask(ProcessModel processModel, InputDataObjectType processInput, String gatewayId) throws RegistryException, TException, AppCatalogException, TaskException, AiravataException {
        TaskModel taskModel = new TaskModel();
        taskModel.setParentProcessId(processModel.getProcessId());
        taskModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
        taskModel.setLastUpdateTime(taskModel.getCreationTime());
        TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
        taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
        taskModel.setTaskStatuses(Arrays.asList(taskStatus));
        taskModel.setTaskType(TaskTypes.DATA_STAGING);
        DataStagingTaskModel submodel = new DataStagingTaskModel();
        ComputeResourceDescription computeResource = this.orchestratorContext.getRegistry().getAppCatalog().getComputeResource().getComputeResource(processModel.getComputeResourceId());
        String workingDir = OrchestratorUtils.getScratchLocation(this.orchestratorContext, processModel, gatewayId) + File.separator + processModel.getProcessId() + File.separator;
        URI destination = null;
        try {
            DataMovementProtocol dataMovementProtocol = OrchestratorUtils.getPreferredDataMovementProtocol(this.orchestratorContext, processModel, gatewayId);
            String loginUserName = OrchestratorUtils.getLoginUserName(this.orchestratorContext, processModel, gatewayId);
            destination = new URI(dataMovementProtocol.name(), loginUserName, computeResource.getHostName(), OrchestratorUtils.getDataMovementPort(this.orchestratorContext, processModel, gatewayId), workingDir, null, null);
        }
        catch (URISyntaxException e) {
            throw new TaskException("Error while constructing destination file URI");
        }
        submodel.setType(DataStageType.INPUT);
        submodel.setSource(processInput.getValue());
        submodel.setProcessInput(processInput);
        submodel.setDestination(destination.toString());
        taskModel.setSubTaskModel(ThriftUtils.serializeThriftObject((TBase)submodel));
        return taskModel;
    }

    private TaskModel getOutputDataStagingTask(ProcessModel processModel, OutputDataObjectType processOutput, String gatewayId) throws RegistryException, TException, AiravataException {
        try {
            TaskModel taskModel = new TaskModel();
            taskModel.setParentProcessId(processModel.getProcessId());
            taskModel.setCreationTime(AiravataUtils.getCurrentTimestamp().getTime());
            taskModel.setLastUpdateTime(taskModel.getCreationTime());
            TaskStatus taskStatus = new TaskStatus(TaskState.CREATED);
            taskStatus.setTimeOfStateChange(AiravataUtils.getCurrentTimestamp().getTime());
            taskModel.setTaskStatuses(Arrays.asList(taskStatus));
            taskModel.setTaskType(TaskTypes.DATA_STAGING);
            ComputeResourceDescription computeResource = this.orchestratorContext.getRegistry().getAppCatalog().getComputeResource().getComputeResource(processModel.getComputeResourceId());
            String workingDir = OrchestratorUtils.getScratchLocation(this.orchestratorContext, processModel, gatewayId) + File.separator + processModel.getProcessId() + File.separator;
            DataStagingTaskModel submodel = new DataStagingTaskModel();
            DataMovementProtocol dataMovementProtocol = OrchestratorUtils.getPreferredDataMovementProtocol(this.orchestratorContext, processModel, gatewayId);
            URI source = null;
            try {
                String loginUserName = OrchestratorUtils.getLoginUserName(this.orchestratorContext, processModel, gatewayId);
                if (processOutput != null) {
                    submodel.setType(DataStageType.OUPUT);
                    submodel.setProcessOutput(processOutput);
                    source = new URI(dataMovementProtocol.name(), loginUserName, computeResource.getHostName(), OrchestratorUtils.getDataMovementPort(this.orchestratorContext, processModel, gatewayId), workingDir + processOutput.getValue(), null, null);
                } else {
                    submodel.setType(DataStageType.ARCHIVE_OUTPUT);
                    source = new URI(dataMovementProtocol.name(), loginUserName, computeResource.getHostName(), OrchestratorUtils.getDataMovementPort(this.orchestratorContext, processModel, gatewayId), workingDir, null, null);
                }
            }
            catch (URISyntaxException e) {
                throw new TaskException("Error while constructing source file URI");
            }
            submodel.setSource(source.toString());
            submodel.setDestination("dummy://temp/file/location");
            taskModel.setSubTaskModel(ThriftUtils.serializeThriftObject((TBase)submodel));
            return taskModel;
        }
        catch (TaskException | AppCatalogException e) {
            throw new RegistryException("Error occurred while retrieving data movement from app catalog", e);
        }
    }
}

