/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.security;

import org.apache.airavata.security.AbstractAuthenticator;
import org.apache.airavata.security.UserStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractDatabaseAuthenticator
extends AbstractAuthenticator {
    private String databaseURL;
    private String databaseDriver;
    private String databaseUserName;
    private String databasePassword;

    public AbstractDatabaseAuthenticator() {
    }

    public AbstractDatabaseAuthenticator(String name) {
        super(name);
    }

    @Override
    public void configure(Node node) {
        NodeList databaseNodeList = node.getChildNodes();
        Node databaseNode = null;
        for (int k = 0; k < databaseNodeList.getLength(); ++k) {
            Node n = databaseNodeList.item(k);
            if (n == null || n.getNodeType() != 1) continue;
            databaseNode = n;
        }
        if (databaseNode != null) {
            NodeList nodeList = databaseNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node n = nodeList.item(i);
                if (n.getNodeType() != 1) continue;
                Element element = (Element)n;
                if (element.getNodeName().equals("jdbcUrl")) {
                    this.databaseURL = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("databaseDriver")) {
                    this.databaseDriver = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (element.getNodeName().equals("userName")) {
                    this.databaseUserName = element.getFirstChild().getNodeValue();
                    continue;
                }
                if (!element.getNodeName().equals("password")) continue;
                this.databasePassword = element.getFirstChild().getNodeValue();
            }
        }
        StringBuilder stringBuilder = new StringBuilder("Configuring DB parameters for authenticator with JDBC URL - ");
        stringBuilder.append(this.databaseURL).append(" DB driver - ").append(" DB user - ").append(this.databaseUserName).append(" DB password - xxxxxx");
        log.debug(stringBuilder.toString());
        try {
            this.getUserStore().configure(node);
        }
        catch (UserStoreException e) {
            String msg = "Error configuring user store associated with authenticator.";
            log.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
    }

    public String getDatabaseURL() {
        return this.databaseURL;
    }

    public String getDatabaseDriver() {
        return this.databaseDriver;
    }

    public String getDatabaseUserName() {
        return this.databaseUserName;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }
}

