/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.crl;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.WeakTimerTask;
import eu.emi.security.authn.x509.helpers.crl.AbstractCRLStoreSPI;
import eu.emi.security.authn.x509.helpers.pkipath.PlainStoreUtils;
import eu.emi.security.authn.x509.impl.CRLParameters;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidAlgorithmParameterException;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.security.auth.x500.X500Principal;

public class PlainCRLStoreSpi
extends AbstractCRLStoreSPI {
    private final PlainStoreUtils utils;
    private Timer timer;
    private Object intervalLock = new Object();
    private Map<X500Principal, Set<URL>> ca2location;
    private Map<URL, SoftReference<X509CRL>> loadedCRLs = new HashMap<URL, SoftReference<X509CRL>>();

    public PlainCRLStoreSpi(CRLParameters params, Timer t, ObserversHandler observers) throws InvalidAlgorithmParameterException {
        super(params, observers);
        this.ca2location = new HashMap<X500Principal, Set<URL>>();
        this.utils = new PlainStoreUtils(this.params.getDiskCachePath(), "-crl", this.params.getCrls());
        this.timer = t;
    }

    public void start() {
        this.update();
        this.scheduleUpdate();
    }

    protected X509CRL loadCRL(URL url) throws IOException, CRLException, URISyntaxException {
        X509CRL ret2;
        String protocol = url.getProtocol();
        boolean local = false;
        if (protocol.equalsIgnoreCase("file")) {
            local = true;
        }
        try {
            URLConnection conn = url.openConnection();
            if (!local) {
                conn.setConnectTimeout(this.params.getRemoteConnectionTimeout());
                conn.setReadTimeout(this.params.getRemoteConnectionTimeout());
            }
            BufferedInputStream is = new BufferedInputStream(conn.getInputStream());
            ret2 = this.loadCrlWrapper(is);
        }
        catch (IOException e) {
            if (!local && this.params.getDiskCachePath() != null) {
                File input = this.utils.getCacheFile(url);
                if (input.exists()) {
                    BufferedInputStream is = new BufferedInputStream(new FileInputStream(input));
                    X509CRL ret2 = this.loadCrlWrapper(is);
                    this.notifyObservers(url.toExternalForm(), StoreUpdateListener.Severity.WARNING, new IOException("Warning: CRL was not loaded from its URL, but its previously cached copy was loaded from disk file " + input.getPath(), e));
                    return ret2;
                }
                throw e;
            }
            throw e;
        }
        if (!local) {
            this.utils.saveCacheFile(ret2.getEncoded(), url);
        }
        return ret2;
    }

    private X509CRL loadCrlWrapper(InputStream is) throws IOException, CRLException {
        X509CRL ret = (X509CRL)this.factory.generateCRL(is);
        if (ret == null) {
            throw new CRLException("Unknown problem when parsing/loading the CRL");
        }
        is.close();
        return ret;
    }

    public List<String> getLocations() {
        return this.utils.getLocations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUpdateInterval(long newInterval) {
        Object object = this.intervalLock;
        synchronized (object) {
            long old = this.updateInterval;
            this.updateInterval = newInterval;
            if (old <= 0L) {
                this.scheduleUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUpdateInterval() {
        long ret;
        Object object = this.intervalLock;
        synchronized (object) {
            ret = this.updateInterval;
        }
        return ret;
    }

    private synchronized void removeStaleIssuerMapping() {
        for (Map.Entry<X500Principal, Set<URL>> entry : this.ca2location.entrySet()) {
            Iterator<URL> it = entry.getValue().iterator();
            while (it.hasNext()) {
                URL u = it.next();
                if (this.utils.isPresent(u)) continue;
                it.remove();
                this.loadedCRLs.remove(u);
            }
        }
    }

    private void reloadCRLs(Collection<URL> locations) {
        for (URL location : locations) {
            this.reloadCRL(location);
        }
    }

    protected X509CRL reloadCRL(URL location) {
        X509CRL crl;
        try {
            crl = this.loadCRL(location);
            this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.NOTIFICATION, null);
        }
        catch (Exception e) {
            this.notifyObservers(location.toExternalForm(), StoreUpdateListener.Severity.ERROR, e);
            return null;
        }
        this.addCRL(crl, location);
        return crl;
    }

    protected synchronized void addCRL(X509CRL crl, URL location) {
        Set<URL> set = this.ca2location.get(crl.getIssuerX500Principal());
        if (set == null) {
            set = new HashSet<URL>();
            this.ca2location.put(crl.getIssuerX500Principal(), set);
        }
        set.add(location);
        this.loadedCRLs.put(location, new SoftReference<X509CRL>(crl));
    }

    private void update() {
        this.utils.establishWildcardsLocations();
        this.removeStaleIssuerMapping();
        this.reloadCRLs(this.utils.getURLLocations());
        this.reloadCRLs(this.utils.getResolvedWildcards());
    }

    private void scheduleUpdate() {
        long updateInterval = this.getUpdateInterval();
        if (updateInterval > 0L) {
            this.timer.schedule((TimerTask)new CRLAsyncUpdateTask(this), updateInterval);
        }
    }

    private X509CRL getOrLoadCRL(URL location) {
        X509CRL ret = this.loadedCRLs.get(location).get();
        if (ret != null) {
            return ret;
        }
        return this.reloadCRL(location);
    }

    @Override
    protected synchronized Collection<X509CRL> getCRLForIssuer(X500Principal issuer) {
        Set<URL> locations = this.ca2location.get(issuer);
        if (locations == null) {
            return Collections.emptyList();
        }
        ArrayList<X509CRL> ret = new ArrayList<X509CRL>(locations.size());
        for (URL location : locations) {
            ret.add(this.getOrLoadCRL(location));
        }
        return ret;
    }

    @Override
    public void dispose() {
        this.setUpdateInterval(-1L);
    }

    private static class CRLAsyncUpdateTask
    extends WeakTimerTask<PlainCRLStoreSpi> {
        public CRLAsyncUpdateTask(PlainCRLStoreSpi partner) {
            super(partner);
        }

        @Override
        public void run() {
            PlainCRLStoreSpi partner = (PlainCRLStoreSpi)this.partnerRef.get();
            if (partner == null) {
                return;
            }
            try {
                if (partner.getUpdateInterval() > 0L) {
                    partner.update();
                }
                partner.scheduleUpdate();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

