/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.tx;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.queue.QueueContainer;
import com.hazelcast.queue.QueueOperation;
import com.hazelcast.spi.WaitNotifyKey;
import com.hazelcast.spi.WaitSupport;
import java.io.IOException;

public class TxnReserveOfferOperation
extends QueueOperation
implements WaitSupport {
    int txSize;

    public TxnReserveOfferOperation() {
    }

    public TxnReserveOfferOperation(String name, long timeoutMillis, int txSize) {
        super(name, timeoutMillis);
        this.txSize = txSize;
    }

    @Override
    public void run() throws Exception {
        QueueContainer container = this.getOrCreateContainer();
        if (container.hasEnoughCapacity(this.txSize + 1)) {
            this.response = container.txnOfferReserve();
        }
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return this.getOrCreateContainer().getOfferWaitNotifyKey();
    }

    @Override
    public boolean shouldWait() {
        QueueContainer container = this.getOrCreateContainer();
        return this.getWaitTimeoutMillis() != 0L && !container.hasEnoughCapacity(this.txSize + 1);
    }

    @Override
    public void onWaitExpire() {
        this.getResponseHandler().sendResponse(null);
    }

    @Override
    public int getId() {
        return 29;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.txSize);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.txSize = in.readInt();
    }
}

