/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ResourceJobManager;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceJobManagerResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ResourceJobManagerResource.class);
    private String resourceJobManagerId;
    private String pushMonitoringEndpoint;
    private String jobManagerBinPath;
    private String resourceJobManagerType;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ResourceJobManager", new Object[0][]);
            generator.setParameter("resourceJobManagerId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ResourceJobManager", new Object[0][]);
            generator.setParameter("resourceJobManagerId", identifier);
            Query q = generator.selectQuery(em);
            ResourceJobManager resourceJobManager = (ResourceJobManager)q.getSingleResult();
            ResourceJobManagerResource resourceJobManagerResource = (ResourceJobManagerResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.RESOURCE_JOB_MANAGER, resourceJobManager);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ResourceJobManagerResource resourceJobManagerResource2 = resourceJobManagerResource;
            return resourceJobManagerResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> resourceJobManagerResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ResourceJobManager", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("pushMonitoringEndpoint") || fieldName.equals("jobManagerBinPath") || fieldName.equals("resourceJobManagerType")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ResourceJobManager resourceJobManager = (ResourceJobManager)result;
                    ResourceJobManagerResource resourceJobManagerResource = (ResourceJobManagerResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.RESOURCE_JOB_MANAGER, resourceJobManager);
                    resourceJobManagerResources.add(resourceJobManagerResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Resource Job Manager Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Resource Job Manager Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceJobManagerResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> resourceJobManagerResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ResourceJobManager", new Object[0][]);
            if (fieldName.equals("resourceJobManagerId") || fieldName.equals("pushMonitoringEndpoint") || fieldName.equals("jobManagerBinPath") || fieldName.equals("resourceJobManagerType")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ResourceJobManager resourceJobManager = (ResourceJobManager)result;
                    ResourceJobManagerResource resourceJobManagerResource = (ResourceJobManagerResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.RESOURCE_JOB_MANAGER, resourceJobManager);
                    resourceJobManagerResourceIDs.add(resourceJobManagerResource.getResourceJobManagerId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Resource Job Manager Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Resource Job Manager Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return resourceJobManagerResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            ResourceJobManager resourceJobManager;
            em = AppCatalogJPAUtils.getEntityManager();
            ResourceJobManager existingResourceJobManager = (ResourceJobManager)em.find(ResourceJobManager.class, (Object)this.resourceJobManagerId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingResourceJobManager == null) {
                resourceJobManager = new ResourceJobManager();
                resourceJobManager.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                resourceJobManager = existingResourceJobManager;
                resourceJobManager.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            resourceJobManager.setResourceJobManagerId(this.getResourceJobManagerId());
            resourceJobManager.setPushMonitoringEndpoint(this.getPushMonitoringEndpoint());
            resourceJobManager.setJobManagerBinPath(this.getJobManagerBinPath());
            resourceJobManager.setResourceJobManagerType(this.getResourceJobManagerType());
            if (existingResourceJobManager == null) {
                em.persist((Object)resourceJobManager);
            } else {
                em.merge((Object)resourceJobManager);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ResourceJobManager resourceJobManager = (ResourceJobManager)em.find(ResourceJobManager.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = resourceJobManager != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getResourceJobManagerId() {
        return this.resourceJobManagerId;
    }

    public String getPushMonitoringEndpoint() {
        return this.pushMonitoringEndpoint;
    }

    public String getJobManagerBinPath() {
        return this.jobManagerBinPath;
    }

    public String getResourceJobManagerType() {
        return this.resourceJobManagerType;
    }

    public void setResourceJobManagerId(String resourceJobManagerId) {
        this.resourceJobManagerId = resourceJobManagerId;
    }

    public void setPushMonitoringEndpoint(String pushMonitoringEndpoint) {
        this.pushMonitoringEndpoint = pushMonitoringEndpoint;
    }

    public void setJobManagerBinPath(String jobManagerBinPath) {
        this.jobManagerBinPath = jobManagerBinPath;
    }

    public void setResourceJobManagerType(String resourceJobManagerType) {
        this.resourceJobManagerType = resourceJobManagerType;
    }
}

