/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.ldap;

import java.util.ArrayList;
import org.wso2.carbon.user.api.Property;

public class ActiveDirectoryUserStoreConstants {
    public static final ArrayList<Property> ACTIVE_DIRECTORY_UM_PROPERTIES = new ArrayList();
    public static final ArrayList<Property> OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES = new ArrayList();

    private static void setMandatoryProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        ACTIVE_DIRECTORY_UM_PROPERTIES.add(property);
    }

    private static void setProperty(String name, String value, String description) {
        Property property = new Property(name, value, description, null);
        OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.add(property);
    }

    static {
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("ConnectionName", "CN=,DC=", "This should be the DN (Distinguish Name) of the admin user in LDAP");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("ConnectionURL", "ldaps://", "Connection URL for the user store");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("ConnectionPassword", "", "Password of the admin user");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserSearchBase", "CN=Users,DC=WSO2,DC=Com", "DN of the context under which user entries are stored in LDAP");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("Disabled", "false", "Whether user store is disabled");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserNameListFilter", "(objectClass=person)", "Filtering criteria for listing all the user entries in LDAP");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserNameAttribute", "cn", "Attribute used for uniquely identifying a user entry. Users can be authenticated using their email address, uid and etc");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserNameSearchFilter", "(&amp;(objectClass=user)(cn=?))", "Filtering criteria for searching a particular user entry");
        ActiveDirectoryUserStoreConstants.setMandatoryProperty("UserEntryObjectClass", "user", "Object Class used to construct user entries");
        ActiveDirectoryUserStoreConstants.setProperty("GroupEntryObjectClass", "group", "Object Class used to construct group entries");
        ActiveDirectoryUserStoreConstants.setProperty("MaxUserNameListLength", "100", "Maximum number of users retrieved at once");
        ActiveDirectoryUserStoreConstants.setProperty("MaxRoleNameListLength", "100", "Maximum number of roles retrieved at once");
        ActiveDirectoryUserStoreConstants.setProperty("UserRolesCacheEnabled", "true", "This is to indicate whether to cache the role list of a user");
        ActiveDirectoryUserStoreConstants.setProperty("SCIMEnabled", "false", "Whether SCIM is enabled for the user store");
        Property readLDAPGroups = new Property("ReadGroups", "true", "Specifies whether groups should be read from LDAP", null);
        Property groupSearchBase = new Property("GroupSearchBase", "CN=Users,DC=WSO2,DC=Com", "DN of the context under which user entries are stored in LDAP", null);
        Property groupNameListFilter = new Property("GroupNameListFilter", "(objectcategory=group)", "Filtering criteria for listing all the group entries in LDAP", null);
        Property groupNameAttribute = new Property("GroupNameAttribute", "cn", "Attribute used for uniquely identifying a user entry", null);
        Property membershipAttribute = new Property("MembershipAttribute", "member", "Attribute used to define members of LDAP groups", null);
        Property groupNameSearchFilter = new Property("GroupNameSearchFilter", "(&amp;(objectClass=group)(cn=?))", "Filtering criteria for searching a particular group entry", null);
        readLDAPGroups.setChildProperties(new Property[]{groupSearchBase, groupNameListFilter, groupNameAttribute, membershipAttribute, groupNameSearchFilter});
        OPTIONAL_ACTIVE_DIRECTORY_UM_PROPERTIES.add(readLDAPGroups);
        ActiveDirectoryUserStoreConstants.setProperty("GroupSearchBase", "CN=Users,DC=WSO2,DC=Com", "DN of the context under which user entries are stored in LDAP");
        ActiveDirectoryUserStoreConstants.setProperty("GroupNameListFilter", "(objectcategory=group)", "Filtering criteria for listing all the group entries in LDAP");
        ActiveDirectoryUserStoreConstants.setProperty("GroupNameAttribute", "cn", "Attribute used for uniquely identifying a user entry");
        ActiveDirectoryUserStoreConstants.setProperty("MembershipAttribute", "member", "Attribute used to define members of LDAP groups");
        ActiveDirectoryUserStoreConstants.setProperty("GroupNameSearchFilter", "(&amp;(objectClass=group)(cn=?))", "Filtering criteria for searching a particular group entry");
        ActiveDirectoryUserStoreConstants.setProperty("PasswordHashMethod", "PLAIN_TEXT", "Password Hash method to use when storing user entries");
        ActiveDirectoryUserStoreConstants.setProperty("PasswordJavaScriptRegEx", "^[\\S]{5,30}$", "Policy that defines the password format");
        ActiveDirectoryUserStoreConstants.setProperty("UserNameJavaScriptRegEx", "^[\\S]{3,30}$", "The regular expression used by the front-end components for username validation");
        ActiveDirectoryUserStoreConstants.setProperty("UserNameJavaRegEx", "[a-zA-Z0-9._-|//]{3,30}$", "A regular expression to validate user names");
        ActiveDirectoryUserStoreConstants.setProperty("RoleNameJavaScriptRegEx", "^[\\S]{3,30}$", "The regular expression used by the front-end components for role name validation");
        ActiveDirectoryUserStoreConstants.setProperty("RoleNameJavaRegEx", "[a-zA-Z0-9._-|//]{3,30}$", "A regular expression to validate role names");
        ActiveDirectoryUserStoreConstants.setProperty("WriteGroups", "true", "Indicate whether write groups enabled");
        ActiveDirectoryUserStoreConstants.setProperty("UserDNPattern", "uid={0},ou=Users,dc=wso2,dc=org", "The patten for user's DN. It can be defined to improve the LDAP search");
        ActiveDirectoryUserStoreConstants.setProperty("EmptyRolesAllowed", "true", "Specifies whether the underlying user store allows empty roles to be added");
        ActiveDirectoryUserStoreConstants.setProperty("defaultRealmName", "WSO2.ORG", "Default name for the realm");
        ActiveDirectoryUserStoreConstants.setProperty("kdcEnabled", "false", "Whether key distribution center enabled");
        ActiveDirectoryUserStoreConstants.setProperty("DisplayNameAttribute", "cn", "The display name which usually is the combination of the users first name, middle initial, and last name");
        ActiveDirectoryUserStoreConstants.setProperty("isADLDSRole", "false", "Whether an Active Directory Lightweight Directory Services role");
        ActiveDirectoryUserStoreConstants.setProperty("userAccountControl", "512", "Flags that control the behavior of the user account");
        ActiveDirectoryUserStoreConstants.setProperty("Referral", "follow", "Guides the requests to a domain controller in the correct domain");
        ActiveDirectoryUserStoreConstants.setProperty("BackLinksEnabled", "true", " Whether to allow attributes to be result from references to the object from other objects");
    }
}

