/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.sharing.registry.db.repositories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.airavata.sharing.registry.db.entities.GroupMembershipEntity;
import org.apache.airavata.sharing.registry.db.entities.GroupMembershipPK;
import org.apache.airavata.sharing.registry.db.entities.UserEntity;
import org.apache.airavata.sharing.registry.db.entities.UserGroupEntity;
import org.apache.airavata.sharing.registry.db.repositories.AbstractRepository;
import org.apache.airavata.sharing.registry.db.repositories.UserGroupRepository;
import org.apache.airavata.sharing.registry.db.repositories.UserRepository;
import org.apache.airavata.sharing.registry.models.GroupChildType;
import org.apache.airavata.sharing.registry.models.GroupMembership;
import org.apache.airavata.sharing.registry.models.SharingRegistryException;
import org.apache.airavata.sharing.registry.models.User;
import org.apache.airavata.sharing.registry.models.UserGroup;

public class GroupMembershipRepository
extends AbstractRepository<GroupMembership, GroupMembershipEntity, GroupMembershipPK> {
    public GroupMembershipRepository() {
        super(GroupMembership.class, GroupMembershipEntity.class);
    }

    public List<User> getAllChildUsers(String domainId, String groupId) throws SharingRegistryException {
        String queryString = "SELECT DISTINCT U FROM " + UserEntity.class.getSimpleName() + " U, " + GroupMembershipEntity.class.getSimpleName() + " GM WHERE GM." + "childId" + " = U." + "userId" + " AND GM." + "domainId" + " = U." + "domainId" + " AND GM." + "domainId" + "=:" + "domainId" + " AND GM." + "parentId" + "=:" + "parentId" + " AND GM." + "childType" + "=:" + "childType";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("domainId", domainId);
        queryParameters.put("parentId", groupId);
        queryParameters.put("childType", GroupChildType.USER.toString());
        UserRepository userRepository = new UserRepository();
        List<User> users = userRepository.select(queryString, queryParameters, 0, -1);
        return users;
    }

    public List<UserGroup> getAllChildGroups(String domainId, String groupId) throws SharingRegistryException {
        String queryString = "SELECT DISTINCT G FROM " + UserGroupEntity.class.getSimpleName() + " G, " + GroupMembershipEntity.class.getSimpleName() + " GM WHERE GM." + "childId" + " = G." + "groupId" + " AND GM." + "domainId" + " = G." + "domainId" + " AND GM." + "domainId" + "=:" + "domainId" + " AND GM." + "parentId" + "=:" + "parentId" + " AND GM." + "childType" + "=:" + "childType";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("domainId", domainId);
        queryParameters.put("parentId", groupId);
        queryParameters.put("childType", GroupChildType.GROUP.toString());
        UserGroupRepository userGroupRepository = new UserGroupRepository();
        List<UserGroup> groups = userGroupRepository.select(queryString, queryParameters, 0, -1);
        return groups;
    }

    public List<UserGroup> getAllMemberGroupsForUser(String domainId, String userId) throws SharingRegistryException {
        String queryString = "SELECT DISTINCT G FROM " + UserGroupEntity.class.getSimpleName() + " G, " + GroupMembershipEntity.class.getSimpleName() + " GM WHERE GM." + "parentId" + " = G." + "groupId" + " AND GM." + "domainId" + " = G." + "domainId" + " AND GM." + "domainId" + "=:" + "domainId" + " AND GM." + "childId" + "=:" + "childId" + " AND GM." + "childType" + "=:" + "childType";
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.put("domainId", domainId);
        queryParameters.put("childId", userId);
        queryParameters.put("childType", GroupChildType.USER.toString());
        UserGroupRepository userGroupRepository = new UserGroupRepository();
        List<UserGroup> groups = userGroupRepository.select(queryString, queryParameters, 0, -1);
        return groups;
    }

    public List<GroupMembership> getAllParentMembershipsForChild(String domainId, String childId) throws SharingRegistryException {
        ArrayList<GroupMembership> finalParentGroups = new ArrayList<GroupMembership>();
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("childId", childId);
        filters.put("domainId", domainId);
        LinkedList temp = new LinkedList();
        this.select(filters, 0, -1).stream().forEach(m -> temp.addLast(m));
        while (temp.size() > 0) {
            GroupMembership gm = (GroupMembership)temp.pop();
            filters = new HashMap();
            filters.put("childId", gm.parentId);
            filters.put("domainId", domainId);
            this.select(filters, 0, -1).stream().forEach(m -> temp.addLast(m));
            finalParentGroups.add(gm);
        }
        return finalParentGroups;
    }
}

