/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.impl;

import java.io.Serializable;
import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.abdera.protocol.Request;
import org.apache.abdera.protocol.Resolver;
import org.apache.abdera.protocol.server.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSubjectResolver
implements Resolver<Subject> {
    public static final Principal ANONYMOUS = new AnonymousPrincipal();

    @Override
    public Subject resolve(Request request) {
        RequestContext context = (RequestContext)request;
        return this.resolve(context.getPrincipal());
    }

    public Subject resolve(Principal principal) {
        Subject subject = new Subject();
        subject.getPrincipals().add(principal != null ? principal : ANONYMOUS);
        return subject;
    }

    public Subject resolve(String userid) {
        if (userid == null) {
            return this.resolve(ANONYMOUS);
        }
        return this.resolve(new SimplePrincipal(userid));
    }

    public static final class AnonymousPrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = -5050930075733261944L;
        final String name = "Anonymous";

        public String getName() {
            return "Anonymous";
        }

        public String toString() {
            return "Anonymous";
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            return this == other;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + ("Anonymous" == null ? 0 : "Anonymous".hashCode());
            return result;
        }
    }

    static class SimplePrincipal
    implements Principal,
    Serializable {
        private static final long serialVersionUID = 7161420960293729670L;
        final String name;

        SimplePrincipal(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimplePrincipal other = (SimplePrincipal)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

