/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.util.httpclient;

import eu.unicore.samly2.assertion.Assertion;
import eu.unicore.security.dsig.DigSignatureUtil;
import eu.unicore.security.etd.TrustDelegation;
import eu.unicore.util.httpclient.ClientSecuritySession;
import eu.unicore.util.httpclient.ETDClientSettings;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.SessionIDProvider;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.security.auth.x500.X500Principal;
import org.w3c.dom.Element;

public class SessionIDProviderImpl
implements SessionIDProvider {
    private static final long EXPIRY_BEFORE = 18000L;
    private static final byte[] SEP = "||~~||".getBytes();
    private Map<String, ArrayList<ClientSecuritySession>> sessions = new HashMap<String, ArrayList<ClientSecuritySession>>();

    public static String extractServerID(String uri) {
        try {
            String[] parts = uri.split("services");
            if (parts.length > 1) {
                return parts[0] + "services";
            }
            return uri;
        }
        catch (Exception ex) {
            return uri;
        }
    }

    @Override
    public synchronized String getSessionID(String url, IClientConfiguration currentSettings) {
        String scope = SessionIDProviderImpl.extractServerID(url);
        ArrayList<ClientSecuritySession> scoped = this.sessions.get(scope);
        if (scoped == null) {
            return null;
        }
        String sessionHash = this.checksumSecuritySettings(currentSettings);
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < scoped.size(); ++i) {
            ClientSecuritySession existing = scoped.get(i);
            if (currentTime > existing.getExpiryTS()) {
                scoped.remove(i);
                --i;
                continue;
            }
            if (!existing.getSessionHash().equals(sessionHash)) continue;
            return existing.getSessionId();
        }
        return null;
    }

    @Override
    public synchronized Collection<ClientSecuritySession> getAllSessions() {
        ArrayList<ClientSecuritySession> ret = new ArrayList<ClientSecuritySession>(this.sessions.size() * 2);
        for (List list : this.sessions.values()) {
            ret.addAll(list);
        }
        return ret;
    }

    @Override
    public synchronized void clearAll() {
        this.sessions.clear();
    }

    @Override
    public synchronized void addSession(ClientSecuritySession session) {
        ArrayList<ClientSecuritySession> scoped = this.sessions.get(session.getScope());
        if (scoped == null) {
            scoped = new ArrayList(5);
            this.sessions.put(session.getScope(), scoped);
        }
        scoped.add(session);
    }

    @Override
    public synchronized void registerSession(String sessionId, String url, long lifetime, IClientConfiguration sessionSettings) {
        String scope = SessionIDProviderImpl.extractServerID(url);
        ArrayList<ClientSecuritySession> scoped = this.sessions.get(scope);
        if (scoped == null) {
            scoped = new ArrayList(5);
            this.sessions.put(scope, scoped);
        }
        String sessionHash = this.checksumSecuritySettings(sessionSettings);
        boolean add = true;
        long expiry = lifetime + System.currentTimeMillis() - 18000L;
        for (int i = 0; i < scoped.size(); ++i) {
            ClientSecuritySession existing = scoped.get(i);
            if (!existing.getSessionHash().equals(sessionHash)) continue;
            if (existing.getExpiryTS() > expiry) {
                add = false;
                break;
            }
            scoped.remove(i);
            break;
        }
        if (add) {
            scoped.add(new ClientSecuritySession(sessionId, expiry, sessionHash, scope));
        }
    }

    protected String checksumSecuritySettings(IClientConfiguration settings) {
        byte[] res = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (settings.getCredential() != null) {
                md.update(this.safeToBytes(settings.getCredential().getSubjectName()));
            } else {
                md.update(this.safeToBytes(null));
            }
            ETDClientSettings etd = settings.getETDSettings();
            md.update(this.safeToBytes(etd.getRequestedUser()));
            List<TrustDelegation> baseChain = etd.getTrustDelegationTokens();
            if (baseChain != null) {
                for (TrustDelegation td : baseChain) {
                    md.update(this.safeToBytes(td.getXMLBeanDoc().xmlText()));
                }
            } else {
                md.update(this.safeToBytes(null));
            }
            X500Principal receiver = etd.getReceiver();
            if (receiver != null) {
                md.update(this.safeToBytes(receiver.getName()));
            } else {
                md.update(this.safeToBytes(null));
            }
            Map<String, String[]> attrs = settings.getETDSettings().getRequestedUserAttributes2();
            TreeSet<String> sortedAttr = new TreeSet<String>(attrs.keySet());
            for (String k : sortedAttr) {
                String val = Arrays.asList((Object[])attrs.get(k)).toString();
                md.update(this.safeToBytes(k));
                md.update(this.safeToBytes(val));
            }
            md.update(this.safeToBytes(settings.getHttpUser()));
            md.update(this.safeToBytes(settings.getHttpPassword()));
            Map<String, Object> extraTokens = settings.getExtraSecurityTokens();
            sortedAttr = new TreeSet<String>(extraTokens.keySet());
            for (String key : sortedAttr) {
                md.update(this.safeToBytes(key));
                Object val = extraTokens.get(key);
                if (val instanceof List) {
                    List someList = (List)val;
                    for (Object listEl : someList) {
                        if (listEl instanceof Assertion) {
                            String text = ((Assertion)listEl).getXMLBeanDoc().xmlText();
                            md.update(this.safeToBytes(text));
                            continue;
                        }
                        if (listEl instanceof Element) {
                            String xml = DigSignatureUtil.dumpDOMToString((Element)listEl);
                            md.update(this.safeToBytes(xml));
                            continue;
                        }
                        if (listEl == null) continue;
                        md.update(ByteBuffer.allocate(4).putInt(val.hashCode()).array());
                    }
                    continue;
                }
                if (val == null) continue;
                md.update(ByteBuffer.allocate(4).putInt(val.hashCode()).array());
            }
            res = md.digest();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't calculate security session hash of the client's configuration", ex);
        }
        return SessionIDProviderImpl.hexString(res);
    }

    private byte[] safeToBytes(String arg) {
        if (arg == null) {
            return SEP;
        }
        return (SEP + arg).getBytes();
    }

    private static String hexString(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(0xFF & bytes[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

