/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.endpoint.lifecycle.impl;

import java.lang.reflect.Method;
import javax.xml.ws.WebServiceContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.context.WebServiceContextImpl;
import org.apache.axis2.jaxws.context.factory.MessageContextFactory;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.SoapMessageContext;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.injection.ResourceInjectionException;
import org.apache.axis2.jaxws.lifecycle.BaseLifecycleManager;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescriptionFactory;
import org.apache.axis2.jaxws.server.endpoint.injection.ResourceInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.WebServiceContextInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.factory.ResourceInjectionFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EndpointLifecycleManagerImpl
extends BaseLifecycleManager
implements EndpointLifecycleManager {
    public static final String WEBSERVICE_MESSAGE_CONTEXT = "javax.xml.ws.WebServiceContext";
    private static final Log log = LogFactory.getLog(EndpointLifecycleManagerImpl.class);

    public EndpointLifecycleManagerImpl(Object endpointInstance) {
        this.instance = endpointInstance;
    }

    public EndpointLifecycleManagerImpl() {
    }

    public Object createServiceInstance(org.apache.axis2.jaxws.core.MessageContext mc, Class serviceImplClass) throws LifecycleException, ResourceInjectionException {
        MessageContext msgContext = mc.getAxisMessageContext();
        ServiceDescription serviceDesc = mc.getEndpointDescription().getServiceDescription();
        ResourceInjectionServiceRuntimeDescription injectionDesc = this.getInjectionDesc(serviceDesc, serviceImplClass);
        Object serviceimpl = this.retrieveServiceInstance(mc);
        if (serviceimpl != null) {
            this.instance = serviceimpl;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Service Instance found in the service context, reusing the instance");
            }
            if (this.hasResourceAnnotation(injectionDesc)) {
                this.performWebServiceContextUpdate(mc);
            }
            return serviceimpl;
        }
        this.instance = serviceimpl = this.createServiceInstance(msgContext.getAxisService(), serviceImplClass);
        if (log.isDebugEnabled()) {
            log.debug((Object)"New Service Instance created");
        }
        if (this.hasResourceAnnotation(injectionDesc)) {
            this.performWebServiceContextInjection(mc, serviceimpl);
        }
        if (injectionDesc != null && injectionDesc.getPostConstructMethod() != null) {
            this.invokePostConstruct(injectionDesc.getPostConstructMethod());
        }
        ServiceContext serviceContext = msgContext.getServiceContext();
        serviceContext.setProperty("serviceObject", serviceimpl);
        return serviceimpl;
    }

    protected Object retrieveServiceInstance(org.apache.axis2.jaxws.core.MessageContext mc) {
        Object instance = null;
        ServiceContext serviceContext = mc.getAxisMessageContext().getServiceContext();
        instance = serviceContext.getProperty("serviceObject");
        return instance;
    }

    protected void performWebServiceContextInjection(org.apache.axis2.jaxws.core.MessageContext mc, Object serviceImpl) throws ResourceInjectionException {
        WebServiceContext wsContext = this.createWebServiceContext(mc);
        this.injectWebServiceContext(mc, wsContext, serviceImpl);
        this.saveWebServiceContext(mc, wsContext);
    }

    protected void performWebServiceContextUpdate(org.apache.axis2.jaxws.core.MessageContext mc) throws ResourceInjectionException {
        javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
        ServiceContext serviceContext = mc.getAxisMessageContext().getServiceContext();
        WebServiceContext ws = (WebServiceContext)serviceContext.getProperty(WEBSERVICE_MESSAGE_CONTEXT);
        if (ws != null) {
            this.updateWebServiceContext(ws, soapMessageContext);
            mc.setProperty(WEBSERVICE_MESSAGE_CONTEXT, ws);
        }
    }

    protected void saveWebServiceContext(org.apache.axis2.jaxws.core.MessageContext mc, WebServiceContext wsContext) {
        ServiceContext sc = mc.getAxisMessageContext().getServiceContext();
        sc.setProperty(WEBSERVICE_MESSAGE_CONTEXT, wsContext);
    }

    protected WebServiceContext createWebServiceContext(org.apache.axis2.jaxws.core.MessageContext mc) {
        javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
        WebServiceContextImpl wsContext = new WebServiceContextImpl();
        wsContext.setSoapMessageContext(soapMessageContext);
        mc.setProperty(WEBSERVICE_MESSAGE_CONTEXT, wsContext);
        return wsContext;
    }

    protected ResourceInjectionServiceRuntimeDescription getInjectionDesc(ServiceDescription serviceDesc, Class serviceImplClass) {
        ResourceInjectionServiceRuntimeDescription injectionDesc = null;
        if (serviceDesc != null) {
            injectionDesc = ResourceInjectionServiceRuntimeDescriptionFactory.get(serviceDesc, serviceImplClass);
        }
        return injectionDesc;
    }

    protected boolean hasResourceAnnotation(ResourceInjectionServiceRuntimeDescription injectionDesc) {
        return injectionDesc != null && injectionDesc.hasResourceAnnotation();
    }

    private Object createServiceInstance(AxisService service, Class serviceImplClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating new instance of service endpoint");
        }
        if (serviceImplClass == null) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("EndpointControllerErr5"));
        }
        Object instance = null;
        try {
            Parameter serviceObjectParam;
            ClassLoader classLoader;
            Class serviceObjectMaker;
            Method method;
            if (service != null && service.getParameter("ServiceObjectSupplier") != null && (method = (serviceObjectMaker = Loader.loadClass(classLoader = service.getClassLoader(), ((String)(serviceObjectParam = service.getParameter("ServiceObjectSupplier")).getValue()).trim())).getMethod("getServiceObject", AxisService.class)) != null) {
                return method.invoke(serviceObjectMaker.newInstance(), service);
            }
            instance = serviceImplClass.newInstance();
        }
        catch (IllegalAccessException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("EndpointControllerErr6", serviceImplClass.getName()));
        }
        catch (InstantiationException e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("EndpointControllerErr6", serviceImplClass.getName()));
        }
        catch (Exception e) {
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("EndpointControllerErr6", serviceImplClass.getName()));
        }
        return instance;
    }

    protected javax.xml.ws.handler.MessageContext createSOAPMessageContext(org.apache.axis2.jaxws.core.MessageContext mc) {
        SoapMessageContext soapMessageContext = MessageContextFactory.createSoapMessageContext(mc);
        return soapMessageContext;
    }

    protected void injectWebServiceContext(org.apache.axis2.jaxws.core.MessageContext mc, WebServiceContext wsContext, Object serviceInstance) throws ResourceInjectionException {
        ResourceInjector ri = ResourceInjectionFactory.createResourceInjector(WebServiceContext.class);
        ri.inject(wsContext, serviceInstance);
    }

    protected void updateWebServiceContext(WebServiceContext wsContext, javax.xml.ws.handler.MessageContext soapMessageContext) throws ResourceInjectionException {
        WebServiceContextInjector wci = (WebServiceContextInjector)ResourceInjectionFactory.createResourceInjector(WebServiceContextInjector.class);
        wci.addMessageContext(wsContext, soapMessageContext);
    }
}

