/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.batch.internal.BasicBatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.MutationExecutor;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.jdbc.mutation.spi.MutationExecutorService;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jdbc.Expectations;
import org.hibernate.mapping.Collection;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.OneToManyCollectionPart;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinator;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinatorStandard;
import org.hibernate.persister.collection.mutation.DeleteRowsCoordinatorTablePerSubclass;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinator;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinatorStandard;
import org.hibernate.persister.collection.mutation.InsertRowsCoordinatorTablePerSubclass;
import org.hibernate.persister.collection.mutation.OperationProducer;
import org.hibernate.persister.collection.mutation.RemoveCoordinator;
import org.hibernate.persister.collection.mutation.RemoveCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.RemoveCoordinatorStandard;
import org.hibernate.persister.collection.mutation.RemoveCoordinatorTablePerSubclass;
import org.hibernate.persister.collection.mutation.RowMutationOperations;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinator;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorNoOp;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorOneToMany;
import org.hibernate.persister.collection.mutation.UpdateRowsCoordinatorTablePerSubclass;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.model.ModelMutationLogging;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.ColumnValueParameterList;
import org.hibernate.sql.model.ast.ColumnWriteFragment;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.ast.TableMutation;
import org.hibernate.sql.model.ast.TableUpdate;
import org.hibernate.sql.model.ast.builder.CollectionRowDeleteByUpdateSetNullBuilder;
import org.hibernate.sql.model.ast.builder.TableUpdateBuilderStandard;
import org.hibernate.sql.model.internal.MutationOperationGroupFactory;
import org.hibernate.sql.model.internal.TableUpdateStandard;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;

@Internal
public class OneToManyPersister
extends AbstractCollectionPersister {
    private final RowMutationOperations rowMutationOperations;
    private final InsertRowsCoordinator insertRowsCoordinator;
    private final UpdateRowsCoordinator updateRowsCoordinator;
    private final DeleteRowsCoordinator deleteRowsCoordinator;
    private final RemoveCoordinator removeCoordinator;
    private final boolean cascadeDeleteEnabled;
    private final boolean keyIsNullable;
    private final boolean keyIsUpdateable;
    private final MutationExecutorService mutationExecutorService;

    @Deprecated(since="6.0")
    public OneToManyPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, PersisterCreationContext creationContext) throws MappingException, CacheException {
        this(collectionBinding, cacheAccessStrategy, (RuntimeModelCreationContext)creationContext);
    }

    public OneToManyPersister(Collection collectionBinding, CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) throws MappingException, CacheException {
        super(collectionBinding, cacheAccessStrategy, creationContext);
        this.cascadeDeleteEnabled = collectionBinding.getKey().isCascadeDeleteEnabled() && creationContext.getDialect().supportsCascadeDelete();
        this.keyIsNullable = collectionBinding.getKey().isNullable();
        this.keyIsUpdateable = collectionBinding.getKey().isUpdateable();
        this.rowMutationOperations = this.buildRowMutationOperations();
        this.insertRowsCoordinator = this.buildInsertCoordinator();
        this.updateRowsCoordinator = this.buildUpdateCoordinator();
        this.deleteRowsCoordinator = this.buildDeleteCoordinator();
        this.removeCoordinator = this.buildDeleteAllCoordinator();
        this.mutationExecutorService = creationContext.getServiceRegistry().getService(MutationExecutorService.class);
    }

    @Override
    protected RowMutationOperations getRowMutationOperations() {
        return this.rowMutationOperations;
    }

    protected InsertRowsCoordinator getInsertRowsCoordinator() {
        return this.insertRowsCoordinator;
    }

    protected UpdateRowsCoordinator getUpdateRowsCoordinator() {
        return this.updateRowsCoordinator;
    }

    protected DeleteRowsCoordinator getDeleteRowsCoordinator() {
        return this.deleteRowsCoordinator;
    }

    @Override
    protected RemoveCoordinator getRemoveCoordinator() {
        return this.removeCoordinator;
    }

    @Override
    protected boolean isRowDeleteEnabled() {
        return this.keyIsUpdateable && this.keyIsNullable;
    }

    @Override
    protected boolean isRowInsertEnabled() {
        return this.keyIsUpdateable;
    }

    @Override
    public boolean isCascadeDeleteEnabled() {
        return this.cascadeDeleteEnabled;
    }

    @Override
    public void recreate(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        this.getInsertRowsCoordinator().insertRows(collection, id, collection::includeInRecreate, session);
        this.writeIndex(collection, collection.entries(this), id, true, session);
    }

    @Override
    public void insertRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        this.getInsertRowsCoordinator().insertRows(collection, id, collection::includeInInsert, session);
        this.writeIndex(collection, collection.entries(this), id, true, session);
    }

    @Override
    public void updateRows(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) {
        this.getUpdateRowsCoordinator().updateRows(id, collection, session);
    }

    @Override
    public void deleteRows(PersistentCollection<?> collection, Object key, SharedSessionContractImplementor session) {
        this.getDeleteRowsCoordinator().deleteRows(collection, key, session);
    }

    @Override
    protected void doProcessQueuedOps(PersistentCollection<?> collection, Object id, SharedSessionContractImplementor session) throws HibernateException {
        this.writeIndex(collection, collection.queuedAdditionIterator(), id, false, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(PersistentCollection<?> collection, Iterator<?> entries, Object key, boolean resetIndex, SharedSessionContractImplementor session) {
        boolean doWrite;
        if (!entries.hasNext()) {
            return;
        }
        boolean bl = doWrite = this.isInverse && this.hasIndex() && !this.indexContainsFormula && ArrayHelper.countTrue(this.indexColumnIsSettable) > 0;
        if (!doWrite) {
            return;
        }
        JdbcMutationOperation updateRowOperation = this.rowMutationOperations.getUpdateRowOperation();
        RowMutationOperations.Values updateRowValues = this.rowMutationOperations.getUpdateRowValues();
        RowMutationOperations.Restrictions updateRowRestrictions = this.rowMutationOperations.getUpdateRowRestrictions();
        assert (NullnessHelper.areAllNonNull(updateRowOperation, updateRowValues, updateRowRestrictions));
        MutationExecutor mutationExecutor = this.mutationExecutorService.createExecutor(() -> new BasicBatchKey(this.getNavigableRole() + "#INDEX"), MutationOperationGroupFactory.singleOperation(MutationType.UPDATE, this, updateRowOperation), session);
        JdbcValueBindings jdbcValueBindings = mutationExecutor.getJdbcValueBindings();
        try {
            int nextIndex;
            int n = nextIndex = resetIndex ? 0 : this.getSize(key, session);
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (entry == null || !collection.entryExists(entry, nextIndex)) continue;
                updateRowValues.applyValues(collection, key, entry, nextIndex, session, jdbcValueBindings);
                updateRowRestrictions.applyRestrictions(collection, key, entry, nextIndex, session, jdbcValueBindings);
                mutationExecutor.execute(collection, null, null, null, session);
                ++nextIndex;
            }
        }
        finally {
            mutationExecutor.release();
        }
    }

    @Override
    public boolean consumesEntityAlias() {
        return true;
    }

    @Override
    public boolean consumesCollectionAlias() {
        return true;
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    @Override
    public boolean isManyToMany() {
        return false;
    }

    @Override
    public String getTableName() {
        return ((Joinable)((Object)this.getElementPersister())).getTableName();
    }

    @Override
    protected void applyWhereFragments(Consumer<Predicate> predicateConsumer, String alias, TableGroup tableGroup, SqlAstCreationState astCreationState) {
        super.applyWhereFragments(predicateConsumer, alias, tableGroup, astCreationState);
        if (!astCreationState.supportsEntityNameUsage()) {
            this.getElementPersisterInternal().applyDiscriminator(predicateConsumer, alias, tableGroup, astCreationState);
        }
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return this.getElementPersister().getFilterAliasGenerator(rootAlias);
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(TableGroup rootTableGroup) {
        return this.getElementPersister().getFilterAliasGenerator(rootTableGroup);
    }

    @Override
    public RestrictedTableMutation<JdbcMutationOperation> generateDeleteAllAst(MutatingTableReference tableReference) {
        assert (this.getAttributeMapping() != null);
        ForeignKeyDescriptor fkDescriptor = this.getAttributeMapping().getKeyDescriptor();
        assert (fkDescriptor != null);
        int keyColumnCount = fkDescriptor.getJdbcTypeCount();
        int valuesCount = this.hasIndex() ? keyColumnCount + this.indexColumnNames.length : keyColumnCount;
        ColumnValueParameterList parameterBinders = new ColumnValueParameterList(tableReference, ParameterUsage.RESTRICT, keyColumnCount);
        ArrayList<ColumnValueBinding> keyRestrictionBindings = CollectionHelper.arrayList(keyColumnCount);
        ArrayList<ColumnValueBinding> valueBindings = CollectionHelper.arrayList(valuesCount);
        fkDescriptor.getKeyPart().forEachSelectable(parameterBinders);
        for (ColumnValueParameter columnValueParameter : parameterBinders) {
            ColumnReference columnReference = columnValueParameter.getColumnReference();
            keyRestrictionBindings.add(new ColumnValueBinding(columnReference, new ColumnWriteFragment("?", columnValueParameter, columnReference.getJdbcMapping())));
            valueBindings.add(new ColumnValueBinding(columnReference, new ColumnWriteFragment("null", columnReference.getJdbcMapping())));
        }
        if (this.hasIndex() && !this.indexContainsFormula) {
            this.getAttributeMapping().getIndexDescriptor().forEachSelectable((selectionIndex, selectableMapping) -> {
                if (!selectableMapping.isUpdateable()) {
                    return;
                }
                valueBindings.add(new ColumnValueBinding(new ColumnReference(tableReference, selectableMapping), new ColumnWriteFragment("null", selectableMapping.getJdbcMapping())));
            });
        }
        return new TableUpdateStandard(tableReference, this, "one-shot delete for " + this.getRolePath(), valueBindings, keyRestrictionBindings, null, parameterBinders, this.sqlWhereString, Expectations.NONE);
    }

    private RowMutationOperations buildRowMutationOperations() {
        RowMutationOperations.Restrictions deleteEntryRestrictions;
        OperationProducer deleteEntryOperationProducer;
        RowMutationOperations.Restrictions writeIndexRestrictions;
        RowMutationOperations.Values writeIndexValues;
        OperationProducer writeIndexOperationProducer;
        boolean needsWriteIndex;
        RowMutationOperations.Values insertRowValues;
        OperationProducer insertRowOperationProducer;
        if (!this.isInverse() && this.isRowInsertEnabled()) {
            insertRowOperationProducer = this::generateInsertRowOperation;
            insertRowValues = this::applyInsertRowValues;
        } else {
            insertRowOperationProducer = null;
            insertRowValues = null;
        }
        boolean bl = needsWriteIndex = this.isInverse && this.hasIndex() && !this.indexContainsFormula && !ArrayHelper.isAllFalse(this.indexColumnIsSettable);
        if (needsWriteIndex) {
            writeIndexOperationProducer = this::generateWriteIndexOperation;
            writeIndexValues = this::applyWriteIndexValues;
            writeIndexRestrictions = this::applyWriteIndexRestrictions;
        } else {
            writeIndexOperationProducer = null;
            writeIndexValues = null;
            writeIndexRestrictions = null;
        }
        if (!this.isInverse() && this.isRowDeleteEnabled()) {
            deleteEntryOperationProducer = this::generateDeleteRowOperation;
            deleteEntryRestrictions = this::applyDeleteRowRestrictions;
        } else {
            deleteEntryOperationProducer = null;
            deleteEntryRestrictions = null;
        }
        return new RowMutationOperations(this, insertRowOperationProducer, insertRowValues, writeIndexOperationProducer, writeIndexValues, writeIndexRestrictions, deleteEntryOperationProducer, deleteEntryRestrictions);
    }

    private InsertRowsCoordinator buildInsertCoordinator() {
        if (this.isInverse() || !this.isRowInsertEnabled()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection (re)creation - %s", (Object)this.getRolePath());
            }
            return new InsertRowsCoordinatorNoOp(this);
        }
        if (this.getElementPersisterInternal() != null && this.getElementPersisterInternal().hasSubclasses() && this.getElementPersisterInternal() instanceof UnionSubclassEntityPersister) {
            return new InsertRowsCoordinatorTablePerSubclass(this, this.rowMutationOperations, this.getFactory().getServiceRegistry());
        }
        return new InsertRowsCoordinatorStandard(this, this.rowMutationOperations, this.getFactory().getServiceRegistry());
    }

    private UpdateRowsCoordinator buildUpdateCoordinator() {
        if (!this.isRowDeleteEnabled() && !this.isRowInsertEnabled()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row updates - %s", (Object)this.getRolePath());
            }
            return new UpdateRowsCoordinatorNoOp(this);
        }
        if (this.getElementPersisterInternal() != null && this.getElementPersisterInternal().hasSubclasses() && this.getElementPersisterInternal() instanceof UnionSubclassEntityPersister) {
            return new UpdateRowsCoordinatorTablePerSubclass(this, this.rowMutationOperations, this.getFactory());
        }
        return new UpdateRowsCoordinatorOneToMany(this, this.getRowMutationOperations(), this.getFactory());
    }

    private DeleteRowsCoordinator buildDeleteCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection row deletions - %s", (Object)this.getRolePath());
            }
            return new DeleteRowsCoordinatorNoOp(this);
        }
        if (this.getElementPersisterInternal() != null && this.getElementPersisterInternal().hasSubclasses() && this.getElementPersisterInternal() instanceof UnionSubclassEntityPersister) {
            return new DeleteRowsCoordinatorTablePerSubclass(this, this.rowMutationOperations, false, this.getFactory().getServiceRegistry());
        }
        return new DeleteRowsCoordinatorStandard(this, this.rowMutationOperations, false, this.getFactory().getServiceRegistry());
    }

    private RemoveCoordinator buildDeleteAllCoordinator() {
        if (!this.needsRemove()) {
            if (ModelMutationLogging.MODEL_MUTATION_LOGGER.isDebugEnabled()) {
                ModelMutationLogging.MODEL_MUTATION_LOGGER.debugf("Skipping collection removals - %s", (Object)this.getRolePath());
            }
            return new RemoveCoordinatorNoOp(this);
        }
        if (this.getElementPersisterInternal() != null && this.getElementPersisterInternal().hasSubclasses() && this.getElementPersisterInternal() instanceof UnionSubclassEntityPersister) {
            return new RemoveCoordinatorTablePerSubclass(this, this::buildDeleteAllOperation, this.getFactory().getServiceRegistry());
        }
        return new RemoveCoordinatorStandard(this, this::buildDeleteAllOperation, this.getFactory().getServiceRegistry());
    }

    private JdbcMutationOperation generateDeleteRowOperation(MutatingTableReference tableReference) {
        RestrictedTableMutation<JdbcMutationOperation> sqlAst = this.generateDeleteRowAst(tableReference);
        SqlAstTranslator<JdbcMutationOperation> translator = this.getFactory().getJdbcServices().getDialect().getSqlAstTranslatorFactory().buildModelMutationTranslator(sqlAst, this.getFactory());
        return translator.translate(null, MutationQueryOptions.INSTANCE);
    }

    public RestrictedTableMutation<JdbcMutationOperation> generateDeleteRowAst(MutatingTableReference tableReference) {
        CollectionRowDeleteByUpdateSetNullBuilder updateBuilder = new CollectionRowDeleteByUpdateSetNullBuilder(this, tableReference, this.getFactory(), this.sqlWhereString);
        ForeignKeyDescriptor keyDescriptor = this.getAttributeMapping().getKeyDescriptor();
        int keyTypeCount = keyDescriptor.getJdbcTypeCount();
        for (int i = 0; i < keyTypeCount; ++i) {
            SelectableMapping selectable = keyDescriptor.getSelectable(i);
            if (selectable.isFormula()) continue;
            if (selectable.isUpdateable()) {
                updateBuilder.addValueColumn(selectable.getSelectionExpression(), "null", selectable.getJdbcMapping(), selectable.isLob());
            }
            updateBuilder.addKeyRestrictionLeniently(selectable);
        }
        if (this.hasIndex() && !this.indexContainsFormula) {
            CollectionPart indexDescriptor = this.getAttributeMapping().getIndexDescriptor();
            assert (indexDescriptor != null);
            int indexTypeCount = indexDescriptor.getJdbcTypeCount();
            for (int i = 0; i < indexTypeCount; ++i) {
                SelectableMapping selectable = indexDescriptor.getSelectable(i);
                if (!selectable.isUpdateable()) continue;
                updateBuilder.addValueColumn(selectable.getSelectionExpression(), "null", selectable.getJdbcMapping(), selectable.isLob());
            }
        }
        EntityCollectionPart entityPart = (EntityCollectionPart)this.getAttributeMapping().getElementDescriptor();
        EntityIdentifierMapping entityId = entityPart.getAssociatedEntityMappingType().getIdentifierMapping();
        updateBuilder.addKeyRestrictionsLeniently(entityId);
        return updateBuilder.buildMutation();
    }

    private void applyDeleteRowRestrictions(PersistentCollection<?> collection, Object keyValue, Object rowValue, int rowPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        PluralAttributeMapping pluralAttribute = this.getAttributeMapping();
        pluralAttribute.getKeyDescriptor().decompose(keyValue, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
        pluralAttribute.getElementDescriptor().decompose(rowValue, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
    }

    private JdbcMutationOperation generateInsertRowOperation(MutatingTableReference tableReference) {
        TableUpdate<JdbcMutationOperation> tableUpdate = this.buildTableUpdate(tableReference);
        return (JdbcMutationOperation)tableUpdate.createMutationOperation(null, this.getFactory());
    }

    private TableUpdate<JdbcMutationOperation> buildTableUpdate(MutatingTableReference tableReference) {
        TableUpdateBuilderStandard updateBuilder = new TableUpdateBuilderStandard(this, tableReference, this.getFactory(), this.sqlWhereString);
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        attributeMapping.getKeyDescriptor().getKeyPart().forEachSelectable(updateBuilder);
        CollectionPart indexDescriptor = attributeMapping.getIndexDescriptor();
        if (indexDescriptor != null) {
            indexDescriptor.forEachUpdatable(updateBuilder);
        }
        EntityCollectionPart elementDescriptor = (EntityCollectionPart)attributeMapping.getElementDescriptor();
        EntityMappingType elementType = elementDescriptor.getAssociatedEntityMappingType();
        assert (elementType.containsTableReference(tableReference.getTableName()));
        updateBuilder.addKeyRestrictionsLeniently(elementType.getIdentifierMapping());
        return (TableUpdate)updateBuilder.buildMutation();
    }

    private void applyInsertRowValues(PersistentCollection<?> collection, Object keyValue, Object rowValue, int rowPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        PluralAttributeMapping attributeMapping = this.getAttributeMapping();
        attributeMapping.getKeyDescriptor().getKeyPart().decompose(keyValue, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_VALUE_SETTER, session);
        CollectionPart indexDescriptor = attributeMapping.getIndexDescriptor();
        if (indexDescriptor != null) {
            indexDescriptor.decompose(this.incrementIndexByBase(collection.getIndex(rowValue, rowPosition, this)), 0, jdbcValueBindings, null, (valueIndex, bindings, noop, value, jdbcValueMapping) -> {
                if (!jdbcValueMapping.isUpdateable()) {
                    return;
                }
                bindings.bindValue(value, jdbcValueMapping, ParameterUsage.SET);
            }, session);
        }
        Object elementValue = collection.getElement(rowValue);
        EntityCollectionPart elementDescriptor = (EntityCollectionPart)attributeMapping.getElementDescriptor();
        EntityIdentifierMapping identifierMapping = elementDescriptor.getAssociatedEntityMappingType().getIdentifierMapping();
        identifierMapping.decompose(identifierMapping.getIdentifier(elementValue), 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
    }

    private JdbcMutationOperation generateWriteIndexOperation(MutatingTableReference tableReference) {
        TableUpdateBuilderStandard updateBuilder = new TableUpdateBuilderStandard(this, tableReference, this.getFactory(), this.sqlWhereString);
        OneToManyCollectionPart elementDescriptor = (OneToManyCollectionPart)this.getAttributeMapping().getElementDescriptor();
        updateBuilder.addKeyRestrictionsLeniently(elementDescriptor.getAssociatedEntityMappingType().getIdentifierMapping());
        if (this.getAttributeMapping().getIdentifierDescriptor() != null) {
            updateBuilder.addKeyRestrictionsLeniently(this.getAttributeMapping().getIdentifierDescriptor());
        }
        this.getAttributeMapping().getIndexDescriptor().forEachUpdatable(updateBuilder);
        TableMutation tableUpdate = updateBuilder.buildMutation();
        return (JdbcMutationOperation)tableUpdate.createMutationOperation(null, this.getFactory());
    }

    private void applyWriteIndexValues(PersistentCollection<?> collection, Object key, Object entry, int entryPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        Object index = collection.getIndex(entry, entryPosition, this);
        this.getAttributeMapping().getIndexDescriptor().decompose(index, 0, jdbcValueBindings, null, (valueIndex, bindings, noop, jdbcValue, jdbcValueMapping) -> {
            if (!jdbcValueMapping.isUpdateable()) {
                return;
            }
            bindings.bindValue(jdbcValue, jdbcValueMapping, ParameterUsage.SET);
        }, session);
    }

    private void applyWriteIndexRestrictions(PersistentCollection<?> collection, Object key, Object entry, int entryPosition, SharedSessionContractImplementor session, JdbcValueBindings jdbcValueBindings) {
        OneToManyCollectionPart elementDescriptor = (OneToManyCollectionPart)this.getAttributeMapping().getElementDescriptor();
        EntityMappingType associatedType = elementDescriptor.getAssociatedEntityMappingType();
        Object element = collection.getElement(entry);
        Object elementIdentifier = associatedType.getIdentifierMapping().getIdentifier(element);
        associatedType.getIdentifierMapping().decompose(elementIdentifier, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
        if (this.getAttributeMapping().getIdentifierDescriptor() != null) {
            Object identifier = collection.getIdentifier(entry, entryPosition);
            this.getAttributeMapping().getIdentifierDescriptor().decompose(identifier, 0, jdbcValueBindings, null, RowMutationOperations.DEFAULT_RESTRICTOR, session);
        }
    }
}

