/**
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.aries.cdi.test.tb152_3;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;

import org.apache.aries.cdi.test.interfaces.BeanService;
import org.osgi.service.cdi.annotations.Bean;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.cdi.annotations.Service;
import org.osgi.service.cdi.propertytypes.ServiceDescription;

@ApplicationScoped
@Bean
@Service
@ServiceDescription("one")
public class One implements BeanService<Context> {

	protected One() {
		// no-op: a normal scoped bean MUST have a default constructor to let container create a proxy
	}

	private Context _context;

	void onComponent(@Observes @Initialized(ComponentScoped.class) Object obj, BeanManager bm) {
		_context = bm.getContext(ComponentScoped.class);
	}

	@Override
	public String doSomething() {
		return _context.toString();
	}

	@Override
	public Context get() {
		return _context;
	}

}
