/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.openapi;

import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.integration.JaxrsOpenApiContextBuilder;
import io.swagger.v3.jaxrs2.integration.resources.BaseOpenApiResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiContext;
import io.swagger.v3.oas.integration.api.OpenApiScanner;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Optional;
import javax.servlet.ServletConfig;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.apache.aries.jax.rs.openapi.JaxrsWhiteboardScanner;
import org.apache.aries.jax.rs.whiteboard.ApplicationClasses;
import org.osgi.annotation.bundle.Capability;

@Path(value="/openapi.{type:json|yaml}")
@Capability(namespace="osgi.implementation", name="org.apache.aries.jax.rs.openapi")
public class OpenApiResource
extends BaseOpenApiResource {
    @Context
    Application app;
    @Context
    ApplicationClasses applicationClasses;
    @Context
    ServletConfig config;
    private long serviceId;
    @Context
    Providers providers;
    @Context
    Configuration configuration;

    public OpenApiResource(long serviceId) {
        this.serviceId = serviceId;
    }

    @GET
    @Produces(value={"application/json", "application/yaml"})
    @Operation(hidden=true)
    public Response getOpenApi(@Context HttpHeaders headers, @Context UriInfo uriInfo, @PathParam(value="type") String type) throws Exception {
        String ctxId = this.app.getClass().getCanonicalName().concat("#").concat(String.valueOf(System.identityHashCode(this.app))).concat(String.valueOf(this.serviceId));
        OpenApiContext ctx = new JaxrsOpenApiContextBuilder().servletConfig(this.config).application(this.app).configLocation(this.configLocation).openApiConfiguration(this.openApiConfiguration).ctxId(ctxId).buildContext(false);
        ctx.setOpenApiScanner((OpenApiScanner)new JaxrsWhiteboardScanner(this.app, this.applicationClasses));
        ctx.init();
        OpenAPI oas = ctx.read();
        if (oas == null) {
            return Response.status((int)404).build();
        }
        boolean pretty = Optional.ofNullable(ctx.getOpenApiConfiguration()).map(OpenAPIConfiguration::isPrettyPrint).orElse(Boolean.FALSE);
        if (Optional.ofNullable(type).map(String::trim).map("yaml"::equalsIgnoreCase).orElse(Boolean.FALSE).booleanValue()) {
            return Response.status((Response.Status)Response.Status.OK).entity((Object)(pretty ? Yaml.pretty((Object)oas) : Yaml.mapper().writeValueAsString((Object)oas))).type("application/yaml").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)(pretty ? Json.pretty((Object)oas) : Json.mapper().writeValueAsString((Object)oas))).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

