/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.AbstractRequirement;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class BasicRequirement
extends AbstractRequirement {
    private final Map<String, Object> attributes;
    private final Map<String, String> directives;
    private final String namespace;
    private final Resource resource;

    public BasicRequirement(Requirement requirement, Resource resource) {
        this.attributes = requirement.getAttributes();
        this.directives = requirement.getDirectives();
        this.namespace = requirement.getNamespace();
        this.resource = resource;
    }

    public BasicRequirement(String namespace, String filter) throws InvalidSyntaxException {
        this(namespace, FrameworkUtil.createFilter((String)filter));
    }

    public BasicRequirement(String namespace, Filter filter) {
        if (namespace == null) {
            throw new NullPointerException("Missing required parameter: namespace");
        }
        this.attributes = Collections.emptyMap();
        HashMap<String, String> directives = new HashMap<String, String>(1);
        directives.put("filter", filter.toString());
        this.directives = Collections.unmodifiableMap(directives);
        this.namespace = namespace;
        this.resource = null;
    }

    private BasicRequirement(String namespace, Map<String, Object> attributes, Map<String, String> directives, Resource resource) {
        if (namespace == null) {
            throw new NullPointerException();
        }
        this.namespace = namespace;
        this.attributes = attributes == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, Object>(attributes));
        this.directives = directives == null ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(directives));
        if (resource == null) {
            throw new NullPointerException();
        }
        this.resource = resource;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Resource getResource() {
        return this.resource;
    }

    public static class Builder {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final Map<String, String> directives = new HashMap<String, String>();
        private Resource resource;
        private String namespace;

        public Builder attribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder attributes(Map<String, Object> values) {
            this.attributes.putAll(values);
            return this;
        }

        public BasicRequirement build() {
            return new BasicRequirement(this.namespace, this.attributes, this.directives, this.resource);
        }

        public Builder directive(String key, String value) {
            this.directives.put(key, value);
            return this;
        }

        public Builder directives(Map<String, String> values) {
            this.directives.putAll(values);
            return this;
        }

        public Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public Builder resource(Resource value) {
            this.resource = value;
            return this;
        }
    }
}

