/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AUnorderedListSerializerDeserializer;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.CastTypeEvaluator;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractArrayAddRemoveEval
implements IScalarEvaluator {
    static final int RETURN_MISSING = -1;
    static final int RETURN_NULL = -2;
    private final IAType[] argTypes;
    private final ArrayBackedValueStorage storage;
    private final IPointable listArg;
    private final IPointable tempList;
    private final IPointable tempItem;
    private final IPointable[] valuesArgs;
    private final IScalarEvaluator listArgEval;
    private final IScalarEvaluator[] valuesEval;
    private final CastTypeEvaluator caster;
    private final ListAccessor listAccessor;
    private final int listOffset;
    private final int valuesOffset;
    private final boolean makeOpen;
    private final boolean acceptNullValues;
    private IAsterixListBuilder orderedListBuilder;
    private IAsterixListBuilder unorderedListBuilder;

    AbstractArrayAddRemoveEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, int listOffset, int valuesOffset, int numValues, IAType[] argTypes, boolean makeOpen, boolean acceptNullValues) throws HyracksDataException {
        this.listOffset = listOffset;
        this.valuesOffset = valuesOffset;
        this.argTypes = argTypes;
        this.makeOpen = makeOpen;
        this.acceptNullValues = acceptNullValues;
        this.orderedListBuilder = null;
        this.unorderedListBuilder = null;
        this.listAccessor = new ListAccessor();
        this.caster = new CastTypeEvaluator();
        this.storage = new ArrayBackedValueStorage();
        this.listArg = new VoidPointable();
        this.tempList = new VoidPointable();
        this.tempItem = new VoidPointable();
        this.listArgEval = args[listOffset].createScalarEvaluator(ctx);
        this.valuesArgs = new IPointable[numValues];
        this.valuesEval = new IScalarEvaluator[numValues];
        for (int i = 0; i < numValues; ++i) {
            this.valuesArgs[i] = new VoidPointable();
            this.valuesEval[i] = args[i + valuesOffset].createScalarEvaluator(ctx);
        }
    }

    protected int getPosition(IFrameTupleReference tuple, IPointable list, ATypeTag listType) throws HyracksDataException {
        if (listType == ATypeTag.ARRAY) {
            return AOrderedListSerializerDeserializer.getNumberOfItems((byte[])list.getByteArray(), (int)list.getStartOffset());
        }
        if (listType == ATypeTag.MULTISET) {
            return AUnorderedListSerializerDeserializer.getNumberOfItems((byte[])list.getByteArray(), (int)list.getStartOffset());
        }
        return -2;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.listArgEval.evaluate(tuple, this.tempList);
        ATypeTag listArgTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.tempList.getByteArray()[this.tempList.getStartOffset()]);
        int adjustedPosition = this.getPosition(tuple, this.tempList, listArgTag);
        if (listArgTag == ATypeTag.MISSING || adjustedPosition == -1) {
            PointableHelper.setMissing(result);
            return;
        }
        boolean returnNull = false;
        if (!listArgTag.isListType() || adjustedPosition == -2) {
            returnNull = true;
        }
        try {
            AOrderedListType listType;
            IAsterixListBuilder listBuilder;
            for (int i = 0; i < this.valuesEval.length; ++i) {
                IAType defaultOpenType = DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)this.argTypes[i + this.valuesOffset].getTypeTag());
                if (defaultOpenType != null && !returnNull && this.makeOpen) {
                    this.caster.resetAndAllocate(defaultOpenType, this.argTypes[i + this.valuesOffset], this.valuesEval[i]);
                    this.caster.evaluate(tuple, this.valuesArgs[i]);
                } else {
                    this.valuesEval[i].evaluate(tuple, this.valuesArgs[i]);
                }
                ATypeTag valueTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.valuesArgs[i].getByteArray()[this.valuesArgs[i].getStartOffset()]);
                if (valueTag == ATypeTag.MISSING) {
                    PointableHelper.setMissing(result);
                    return;
                }
                if (this.acceptNullValues || valueTag != ATypeTag.NULL) continue;
                returnNull = true;
            }
            if (returnNull) {
                PointableHelper.setNull(result);
                return;
            }
            if (listArgTag == ATypeTag.ARRAY) {
                if (this.orderedListBuilder == null) {
                    this.orderedListBuilder = new OrderedListBuilder();
                }
                listBuilder = this.orderedListBuilder;
                if (this.makeOpen || this.argTypes[this.listOffset].getTypeTag() != ATypeTag.ARRAY) {
                    listType = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
                    this.caster.resetAndAllocate((IAType)listType, this.argTypes[this.listOffset], this.listArgEval);
                    this.caster.cast(this.tempList, this.listArg);
                } else {
                    listType = (AbstractCollectionType)this.argTypes[this.listOffset];
                    this.listArg.set((IValueReference)this.tempList);
                }
            } else {
                if (this.unorderedListBuilder == null) {
                    this.unorderedListBuilder = new UnorderedListBuilder();
                }
                listBuilder = this.unorderedListBuilder;
                if (this.makeOpen || this.argTypes[this.listOffset].getTypeTag() != ATypeTag.MULTISET) {
                    listType = DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
                    this.caster.resetAndAllocate((IAType)listType, this.argTypes[this.listOffset], this.listArgEval);
                    this.caster.cast(this.tempList, this.listArg);
                } else {
                    listType = (AbstractCollectionType)this.argTypes[this.listOffset];
                    this.listArg.set((IValueReference)this.tempList);
                }
            }
            listBuilder.reset((AbstractCollectionType)listType);
            this.listAccessor.reset(this.listArg.getByteArray(), this.listArg.getStartOffset());
            this.processList(this.listAccessor, listBuilder, this.valuesArgs, adjustedPosition);
            this.storage.reset();
            listBuilder.write(this.storage.getDataOutput(), true);
            result.set((IValueReference)this.storage);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            this.caster.deallocatePointables();
        }
    }

    protected void processList(ListAccessor listAccessor, IAsterixListBuilder listBuilder, IPointable[] values, int position) throws IOException {
        int i;
        for (i = 0; i < position; ++i) {
            listAccessor.getOrWriteItem(i, this.tempItem, this.storage);
            listBuilder.addItem((IValueReference)this.tempItem);
        }
        for (int j = 0; j < values.length; ++j) {
            listBuilder.addItem((IValueReference)values[j]);
        }
        while (i < listAccessor.size()) {
            listAccessor.getOrWriteItem(i, this.tempItem, this.storage);
            listBuilder.addItem((IValueReference)this.tempItem);
            ++i;
        }
    }
}

