/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream.factory;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.input.stream.SocketServerInputStream;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;

public class SocketServerInputStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    private List<Pair<String, Integer>> sockets;

    @Override
    public void configure(IServiceContext serviceCtx, Map<String, String> configuration, IWarningCollector warningCollector) throws CompilationException {
        try {
            this.sockets = FeedUtils.extractHostsPorts(configuration.get("address-type"), serviceCtx, configuration.get("sockets"));
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CompilationException(3081, new Serializable[0]);
        }
    }

    @Override
    public synchronized AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            Pair<String, Integer> socket = this.sockets.get(partition);
            ServerSocket server = new ServerSocket();
            server.bind(new InetSocketAddress((Integer)socket.getRight()));
            return new SocketServerInputStream(server);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        return FeedUtils.addressToAbsolutePartitionConstraints(this.sockets);
    }

    public List<Pair<String, Integer>> getSockets() {
        return this.sockets;
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.STREAM;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }
}

