/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.client.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.hyracks.api.client.impl.IConnectorDescriptorVisitor;
import org.apache.hyracks.api.client.impl.IOperatorDescriptorVisitor;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.OperatorDescriptorId;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobSpecification;

public class PlanUtils {
    public static void visit(JobSpecification spec, IOperatorDescriptorVisitor visitor) throws HyracksException {
        HashSet<OperatorDescriptorId> seen = new HashSet<OperatorDescriptorId>();
        for (IOperatorDescriptor op : spec.getOperatorMap().values()) {
            PlanUtils.visitOperator(visitor, seen, op);
        }
    }

    private static void visitOperator(IOperatorDescriptorVisitor visitor, Set<OperatorDescriptorId> seen, IOperatorDescriptor op) throws HyracksException {
        if (!seen.contains(op.getOperatorId())) {
            visitor.visit(op);
        }
        seen.add(op.getOperatorId());
    }

    public static void visit(JobSpecification spec, IConnectorDescriptorVisitor visitor) throws HyracksException {
        for (IConnectorDescriptor c : spec.getConnectorMap().values()) {
            visitor.visit(c);
        }
    }
}

