/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.transactions.ITxnIdFactory;
import org.apache.asterix.common.transactions.TxnId;

public class BulkTxnIdFactory
implements ITxnIdFactory {
    private final AtomicLong maxId = new AtomicLong();

    public TxnId create() {
        return new TxnId(this.maxId.incrementAndGet());
    }

    public long getIdBlock(int blockSize) {
        if (blockSize < 1) {
            throw new IllegalArgumentException("block size cannot be smaller than 1, but was " + blockSize);
        }
        return this.maxId.getAndAdd(blockSize) + 1L;
    }

    public void ensureMinimumId(long id) {
        this.maxId.getAndUpdate(next -> Math.max(next, id));
    }

    public long getMaxTxnId() {
        return this.maxId.get();
    }
}

